/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.miniorange.sso.saml.scheduler.MetadataRefreshScheduler;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class DeleteIdpServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DeleteIdpServlet.class);
    private PluginSettingsService pluginSettingsService;
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean useDomainMapping;
    private List<String> domainsList;
    private MetadataRefreshScheduler metadataRefreshService;

    public DeleteIdpServlet(PluginSettingsService settings, MetadataRefreshScheduler metadataRefreshService) {
        this.pluginSettingsService = settings;
        this.metadataRefreshService = metadataRefreshService;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("MoDeleteIdpServlet : execute called");
        try {
            String idpID = request.getParameter("idpID");
            String status = "";
            if (StringUtils.isNotBlank(idpID)) {
                HashMap<String, String> idpMap = this.pluginSettingsService.getIdpMap();
                if (idpMap == null || !idpMap.containsKey(idpID)) {
                    status = "missing";
                } else {
                    this.pluginSettingsService.removeIdp(idpID);
                    this.metadataRefreshService.unscheduleJob(idpID);
                    status = "success";
                }
            } else {
                status = "empty";
            }
            response.sendRedirect(this.pluginSettingsService.getSpBaseUrl() + "/plugins/servlet/crowd-saml/config/listidp?operation=delete&status=" + status);
        }
        catch (Exception e) {
            log.error("An error occurred while deleting IDP configuration", (Throwable)e);
        }
    }

    @Generated
    public DeleteIdpServlet() {
    }
}

