/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobConfig;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.scheduler.MetadataRefreshScheduler;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class MetadataRefreshTask
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(MetadataRefreshTask.class);
    private final PluginConfigService pluginConfigService;
    private final PluginSettingsService pluginSettingsService;

    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        log.info("Running Metadata Refresh Task");
        try {
            JobConfig jobConfig = jobRunnerRequest.getJobConfig();
            IDPConfig idpConfig = (IDPConfig)jobConfig.getParameters().get(MetadataRefreshScheduler.IDP_ID);
            String metadataUrl = "";
            String metadata = "";
            String idpId = "miniorange.saml.DEFAULT_IDP_ID";
            String idpName = "IDP";
            if (idpConfig != null) {
                metadataUrl = idpConfig.getMetadataUrl();
                metadata = HttpUtils.sendGetRequest(metadataUrl);
                idpId = idpConfig.getIdpId();
                idpName = idpConfig.getIdpName();
            } else {
                metadataUrl = this.pluginSettingsService.getInputMetadataUrl();
                metadata = HttpUtils.sendGetRequest(metadataUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)metadata)) {
                this.pluginConfigService.configureFromMetadata(idpId, idpName, metadata, Boolean.TRUE);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            log.error("An error occurred while updating the metadata.", t);
        }
        return null;
    }

    @Generated
    public MetadataRefreshTask(PluginConfigService pluginConfigService, PluginSettingsService pluginSettingsService) {
        this.pluginConfigService = pluginConfigService;
        this.pluginSettingsService = pluginSettingsService;
    }
}

