/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.model.PluginAPIResponse;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class PublicPluginConfigAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PublicPluginConfigAPI.class);
    private PluginConfigService pluginConfigService;
    private PluginLicenseService pluginLicenseService;
    private PluginSettingsService pluginSettingsService;
    private UserManager userManager;
    private CrowdService crowdService;

    @UnrestrictedAccess
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Public Plugin Config API : GET");
        try {
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(403, "Access denied. Invalid plugin license.");
                return;
            }
            String action = request.getParameter("action");
            if (action == null) {
                response.sendError(400, "Action parameter is required");
                return;
            }
            log.debug("Public Plugin Config GET API : Action: {}", (Object)action);
            switch (action) {
                case "checkBackdoorAccess": {
                    this.handleCheckBackdoorAccess(request, response);
                    break;
                }
                case "fetchGroups": {
                    this.handleFetchGroups(request, response);
                    break;
                }
                case "getIdpList": {
                    this.handleGetIdpList(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(400, "Invalid Action. Please choose a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Public Plugin Config API Error : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    private void handleCheckBackdoorAccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Checking backdoor access for user");
        String username = request.getParameter("username");
        if (username == null) {
            log.warn("Username parameter is required");
            response.sendError(400, "Username parameter is required");
        }
        UserProfile user = this.userManager.getUserProfile(username);
        List<String> authorisedBackdoorGroups = this.pluginSettingsService.getBackdoorGroups();
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
        if (user != null) {
            JSONObject result = new JSONObject();
            try {
                for (String group : authorisedBackdoorGroups) {
                    if (!this.userManager.isUserInGroup(user.getUserKey(), group)) continue;
                    this.pluginSettingsService.setUserPresent(true);
                    result.put("isUserAllowedBackdoorAccess", true);
                    this.sendSuccessFullResponse(result.toString(), response);
                    return;
                }
            }
            catch (JSONException e) {
                log.error("An Error Occurred while checking Backdoor Access for User ", (Throwable)e);
                return;
            }
        }
    }

    private void handleFetchGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Fetching groups for user");
        try {
            String seachString = request.getParameter("search");
            if (StringUtils.equalsIgnoreCase((CharSequence)seachString, (CharSequence)"*")) {
                log.warn("Ignoring * i.e. seach all to avoid performance issue");
                seachString = "";
            }
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)seachString)).returningAtMost(10);
            log.debug("Running Query : {}", (Object)query.toString());
            Iterable querySearchResult = this.crowdService.search((Query)query);
            JSONObject jsonGroupArrayObject = new JSONObject();
            JSONArray jsonGroupArray = new JSONArray();
            for (Group group : querySearchResult) {
                HashMap<String, String> groupResultsMap = new HashMap<String, String>();
                groupResultsMap.put("id", group.getName());
                groupResultsMap.put("text", group.getName());
                jsonGroupArray.put(groupResultsMap);
            }
            log.debug("Group Search Result : {}", (Object)jsonGroupArray);
            jsonGroupArrayObject.put("results", (Object)jsonGroupArray);
            this.sendSuccessFullResponse(jsonGroupArrayObject.toString(), response);
        }
        catch (Exception e) {
            log.error("Fetching groups failed : ", (Throwable)e);
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(500, "Fetching groups failed");
            this.sendResponse(response, pluginAPIResponse);
        }
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            log.debug("sendSuccessFullResponse with result  =  " + result);
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void handleGetIdpList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Fetching list of active IDPs");
        ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
        JSONObject idpListJsonObject = new JSONObject();
        idpListJsonObject.put("idpList", idpList);
        log.debug("IDP List : {}", (Object)idpListJsonObject);
        this.sendSuccessFullResponse(idpListJsonObject.toString(), response);
    }

    private void sendResponse(HttpServletResponse response, PluginAPIResponse pluginAPIResponse) throws IOException {
        response.setStatus(pluginAPIResponse.getStatusCode());
        response.setContentType("application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", pluginAPIResponse.getStatusCode());
        jsonObject.put("message", (Object)pluginAPIResponse.getMessage());
        response.getOutputStream().write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
        response.getOutputStream().close();
    }

    @Generated
    public PublicPluginConfigAPI(PluginConfigService pluginConfigService, PluginLicenseService pluginLicenseService, PluginSettingsService pluginSettingsService, UserManager userManager, CrowdService crowdService) {
        log.debug("checking the plugin APIs ");
        this.pluginConfigService = pluginConfigService;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginSettingsService = pluginSettingsService;
        this.userManager = userManager;
        this.crowdService = crowdService;
    }
}

