/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginMetadataService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadMetadataAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DownloadMetadataAPI.class);
    private final PluginLicenseService pluginLicenseService;
    private final PluginMetadataService pluginMetadataService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Downloading Crowd SAML Plugin metadata");
        try {
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(401, "Unauthorized access. Invalid License");
            }
            String pluginMetadata = this.pluginMetadataService.generatePluginMetadata();
            response.setContentType("text/xml");
            response.getOutputStream().write(pluginMetadata.getBytes());
        }
        catch (Exception e) {
            log.error("An error occurred while downloading plugin's SAML Metadata ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    @Generated
    public DownloadMetadataAPI(PluginLicenseService pluginLicenseService, PluginMetadataService pluginMetadataService) {
        this.pluginLicenseService = pluginLicenseService;
        this.pluginMetadataService = pluginMetadataService;
    }
}

