/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.handler.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServlet;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="configureplugin")
@Produces(value={"application/json"})
public class ConfigurePluginServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ConfigurePluginServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final MoPluginConfigurationsHandler moPluginConfigurationsHandler;
    private final UserManager userManager;

    @GET
    @AdminOnly
    public Response getPluginConfiguration() {
        log.debug("Configure Plugin API called from GET");
        try {
            if (!this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                return this.buildError("Your License has expired", "Please renew the license to use the API Call.");
            }
            String configJson = this.moPluginConfigurationsHandler.generateConfigurationsJson();
            return Response.ok((Object)configJson).header("Cache-Control", (Object)"no-store, no-cache, must-revalidate, max-age=0").build();
        }
        catch (JSONException e) {
            log.error("Error generating plugin configuration JSON", (Throwable)e);
            return this.buildError("Internal Error", "Failed to generate configuration");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response importPluginConfiguration(String configPayload) {
        log.debug("Configure Plugin API called from POST");
        try {
            if (!this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                return this.buildError("Your License has expired", "Please renew the license to use the API Call.");
            }
            this.pluginConfigHandler.stopAllSchedulers();
            this.pluginSettingsService.clearPluginSettings();
            this.moPluginConfigurationsHandler.importPluginConfigurations(configPayload);
            return this.buildSuccess("SAML settings updated", "SAML App Configured successfully.");
        }
        catch (Exception e) {
            log.error("An error occurred while importing the configuration", (Throwable)e);
            return this.buildError("Import Failed", "Could not import configuration.");
        }
    }

    private Response buildError(String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
        }
        catch (JSONException e) {
            log.error("Error building error response", (Throwable)e);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
    }

    private Response buildSuccess(String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
        }
        catch (JSONException e) {
            log.error("Error building success response", (Throwable)e);
        }
        return Response.ok((Object)json.toString()).build();
    }

    @Inject
    @Generated
    public ConfigurePluginServlet(PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, MoPluginConfigurationsHandler moPluginConfigurationsHandler, UserManager userManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
        this.userManager = userManager;
    }
}

