/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.inject.Named;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MoContactUsAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(MoContactUsAction.class);
    private static final String CONTACTUS_FILE_PATH = "/templates/contactus.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginConfigHandler pluginConfigHandler;
    private final PluginSettingsService pluginSettingsService;
    private final PluginLicenseService pluginLicenseService;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    public String successMessage = "";
    public String errorMessage = "";

    public MoContactUsAction(TemplateRenderer templateRenderer, PluginConfigHandler pluginConfigHandler, PluginSettingsService pluginSettingsService, PluginLicenseService pluginLicenseService, ApplicationServices applicationServices, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginConfigHandler = pluginConfigHandler;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginLicenseService = pluginLicenseService;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the IDP configuration page";
            log.error("Failed to render the IDP Configurations page. Error details: {}", (Object)e.getMessage(), (Object)e);
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONTACTUS_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        return context;
    }
}

