/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
public class ImportExportAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ImportExportAction.class);
    private static final String IMPORT_EXPORT_VM_PATH = "/templates/importexport.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigHandler pluginConfigHandler;
    private String successMessage = "";
    private String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Custom Certificates : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Import Export page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(IMPORT_EXPORT_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Custom Certificates : Post ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            String contentType = request.getHeader("Content-Type");
            if (contentType != null && contentType.contains("application/json")) {
                this.handleUpload(request);
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Import Export page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(IMPORT_EXPORT_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    private HashMap<String, Object> initializeImportExportConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("IdPListSize", this.pluginSettingsService.getIdPList().size());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        return context;
    }

    private void handleUpload(HttpServletRequest request) throws IOException {
        String fileName = null;
        String base64Data = null;
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            String jsonString = sb.toString();
            JSONObject json = new JSONObject(jsonString);
            fileName = "Content";
            base64Data = json.optString("Content");
            if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)base64Data)) {
                this.pluginSettingsService.setSpConfigurationStatus("Invalid upload payload: fileName or base64Data missing.");
                log.error("Upload failed: Missing fileName or base64Data.");
                return;
            }
            byte[] fileBytes = Base64.getDecoder().decode(base64Data);
            String fileContent = new String(fileBytes, StandardCharsets.UTF_8);
            if (fileContent == null || fileContent.isEmpty()) {
                this.pluginSettingsService.setSpConfigurationStatus("Uploaded app configuration file is empty.");
            } else {
                this.pluginConfigHandler.importConfigurations(fileContent);
                this.pluginSettingsService.setSpConfigurationStatus("success");
            }
        }
        catch (Exception e) {
            log.error("Error processing configuration upload", (Throwable)e);
            this.pluginSettingsService.setSpConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
        }
    }

    @Generated
    public ImportExportAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, ApplicationServices applicationServices, LoginUriProvider loginUriProvider, PluginLicenseService pluginLicenseService, PluginConfigHandler pluginConfigHandler) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigHandler = pluginConfigHandler;
    }
}

