/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountDetailsAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AccountDetailsAction.class);
    private static final String ACCOUNT_DETAILS_VM_PATH = "/templates/account.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final PluginLicenseService pluginLicenseService;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    private String successMessage = "";
    private String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Account Details : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render(ACCOUNT_DETAILS_VM_PATH, this.initializeAccountDetailsConfig(request, response), (Writer)response.getWriter());
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (BooleanUtils.toBoolean((String)request.getParameter("reregister"))) {
                this.pluginConfigHandler.deactivateAndRemoveCustomerAccount();
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            if (!this.pluginSettingsService.getLicenseVerified().booleanValue() || this.pluginSettingsService.getLicenseVerified().booleanValue() && this.pluginLicenseService.isLicenseExpired().booleanValue()) {
                log.debug("redirecting to verify license file");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/verify-license"));
                return;
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue() && BooleanUtils.toBoolean((String)request.getParameter("checklicense"))) {
                log.debug("License check initiated...");
                this.pluginConfigHandler.getLicencedUsers(this.pluginSettingsService);
            }
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render(ACCOUNT_DETAILS_VM_PATH, this.initializeAccountDetailsConfig(request, response), (Writer)response.getWriter());
        }
        catch (MoPluginException ex) {
            this.pluginConfigHandler.deactivateAndRemoveCustomerAccount();
            response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
        }
        catch (Exception e) {
            log.error("An error occurred while while verifying license against registered account ", (Throwable)e);
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render(ACCOUNT_DETAILS_VM_PATH, this.initializeAccountDetailsConfig(request, response), (Writer)response.getWriter());
        }
    }

    private HashMap<String, Object> initializeAccountDetailsConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        log.debug(context.toString());
        return context;
    }

    @Generated
    public AccountDetailsAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, PluginLicenseService pluginLicenseService, ApplicationServices applicationServices, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.pluginLicenseService = pluginLicenseService;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
    }
}

