/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoUploadMetadataServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoUploadMetadataServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;
    private String idpID;
    private String idpName;
    private String inputUrl;
    private String fileSubmitted;
    private String urlSubmitted;
    private String metadataImported;
    private UserManager userManager;

    @Autowired
    public MoUploadMetadataServlet(PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService, UserManager userManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
        this.userManager = userManager;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("UploadPluginConfigurationServlet: doPost Called");
        try {
            UserProfile user = this.userManager.getRemoteUser();
            Boolean isAdmin = Boolean.FALSE;
            if (user != null) {
                isAdmin = this.userManager.isAdmin(user.getUserKey());
            }
            if (!isAdmin.booleanValue()) {
                LOGGER.error("Access Denied. You will need admin privileges to make this API call");
                response.sendError(403, "Access Denied. You will need admin privileges to make this API call.");
                return;
            }
            LOGGER.info("Uploading Metadata File");
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            String jsonBody = sb.toString();
            LOGGER.debug("Received JSON body: " + jsonBody);
            JSONObject payload = new JSONObject(jsonBody);
            this.idpID = (String)payload.get("idpID");
            this.idpName = (String)payload.get("idpName");
            if (((Boolean)payload.get("isMetadataFileUploaded")).booleanValue()) {
                String metadata = (String)payload.get("metadataContent");
                this.handleUploadMetadata(request, metadata);
            } else {
                this.inputUrl = (String)payload.get("metadataUrl");
                try {
                    LOGGER.info("Fetching Metadata from URL" + this.inputUrl);
                    this.handleFetchMetadata();
                }
                catch (Exception e) {
                    LOGGER.debug("Exception while importing Metadata from URL", e);
                }
            }
            response.sendRedirect(this.pluginSettingsService.getAddIdpConfigurationPageUrl() + "?idpid=" + this.idpID);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details." + String.valueOf(e));
            this.pluginSettingsService.setMetadataUploadStatus("An error occurred while saving your details.Please check logs for more info.");
            response.sendRedirect(this.pluginSettingsService.getAddIdpConfigurationPageUrl());
        }
    }

    private void handleFetchMetadata() {
        LOGGER.info("handleFetchMetadata called");
        try {
            if (StringUtils.isBlank((CharSequence)this.inputUrl)) {
                LOGGER.error("Input Metadata URL is empty");
            }
            this.pluginConfigService.fetchMetadata(this.idpID, this.idpName, this.inputUrl);
            this.pluginSettingsService.setMetadataUploadStatus("Success.");
        }
        catch (MoPluginException e) {
            if (e.getErrorCode() == MoPluginException.PluginErrorCode.METADATA_PARSE) {
                this.pluginSettingsService.setMetadataUploadStatus("Invalid SAML Metadata provided. Could not parse metadata");
            }
            this.pluginSettingsService.setMetadataUploadStatus("Connection to Metadata URL failed. Download the metadata file and upload it using Upload Metadata file option.");
        }
    }

    private void handleUploadMetadata(HttpServletRequest request, String metadata) throws IOException {
        LOGGER.debug("handleUploadMetadata called");
        try {
            LOGGER.debug("metadataImported submitted via JSON payload.");
            this.pluginConfigService.configureFromMetadata(this.idpID, this.idpName, metadata, false);
            this.pluginConfigService.saveImportMetadata(this.idpID, "", Boolean.FALSE, "", 60, "");
            this.pluginSettingsService.setMetadataUploadStatus("Success.");
        }
        catch (Exception e) {
            LOGGER.error("exception message = " + e.getMessage());
            LOGGER.error("Invalid file is provided. Could not parse SAML Metadata provided.", e);
            this.pluginSettingsService.setMetadataUploadStatus("Invalid SAML Metadata provided. Could not parse metadata");
        }
    }
}

