/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.model.Customer;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.model.IDPMetadata;
import com.miniorange.sso.saml.service.PluginMetadataService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigService {
    private static final Logger log = LoggerFactory.getLogger(PluginConfigService.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginMetadataService pluginMetadataService;

    public HashMap<String, Object> initializeConfig(String successMessage, String errorMessage, Boolean isTrialLicense) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("successMessage", successMessage);
        config.put("errorMessage", errorMessage);
        config.put("isTrialLicense", isTrialLicense);
        config.put("pluginSettingsService", this.pluginSettingsService);
        return config;
    }

    public void saveIdPConfiguration(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        log.info("Saving IdP Configuration, IdpName: {}", (Object)idpName);
        log.debug("idpID :{}, idpEntityId :{}, ssoBinding :{}, ssoUrl :{}, sloBinding{}, sloUrl :{}, x509AllCertificates :{}, x509Certificate :{}, signedRequest :{}, nameIdFormat : {}, Rollover url{}, refreshMetadata : {}, refreshInterval : {}, customRefreshInterval{}, customRefreshIntervalUnit{}", new Object[]{idpID, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, signedRequest, nameIdFormat, inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit});
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            log.debug("Saving configuration for default IDP");
            this.pluginSettingsService.setIdpName(idpName);
            this.pluginSettingsService.setIdpEntityId(idpEntityId);
            this.pluginSettingsService.setSsoServiceUrl(ssoUrl);
            this.pluginSettingsService.setSsoBindingType(ssoBinding);
            this.pluginSettingsService.setSloServiceUrl(sloUrl);
            this.pluginSettingsService.setSloBindingType(sloBinding);
            if (x509Certificate != null) {
                this.pluginSettingsService.setX509Certificate(x509Certificate);
            } else {
                this.pluginSettingsService.setX509Certificate(x509AllCertificates.get(0));
            }
            if (!x509AllCertificates.isEmpty()) {
                this.pluginSettingsService.setAllX509Certificates(x509AllCertificates);
            }
            this.pluginSettingsService.setSignedRequest(signedRequest);
            this.pluginSettingsService.setNameIdFormat(nameIdFormat);
            if (BooleanUtils.toBoolean((Boolean)refreshMetadata)) {
                this.saveImportMetadata(idpID, StringUtils.trim((String)inputUrl), refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            } else {
                this.saveImportMetadata(idpID, inputUrl, false, "hourly", 60, "minutes");
            }
        } else {
            log.debug("Saving configuration for IDP ID {}", (Object)idpID);
            JSONObject idpConfigObj = PluginConfigHandler.buildIdpConfigJSON(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, signedRequest, nameIdFormat, inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            this.saveImportMetadata(idpID, StringUtils.trim((String)inputUrl), refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
            HashMap<String, String> idpMap = this.pluginSettingsService.getIdpMap();
            idpMap.put(idpID, idpName);
            ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
            if (!idpList.contains(idpID)) {
                this.saveDefaultAttributeAndGroupMapping(idpID);
                idpList.add(idpID);
            }
            this.pluginSettingsService.setIdpMap(idpMap);
            this.pluginSettingsService.setIdPList(idpList);
            log.debug("Updated IDP Map: {} ", (Object)this.pluginSettingsService.getIdpMap().toString());
            this.pluginSettingsService.setIdpConfig(idpConfigObj, idpID);
        }
        this.toggleSchedulerService(idpID);
    }

    public void saveDefaultAttributeAndGroupMapping(String idpID) {
        this.saveAttributeMapping(idpID, "NameID", "NameID", "", "", "", Boolean.TRUE, this.pluginSettingsService.getLoginUserAttribute(), Boolean.FALSE, "", new HashMap<String, String>());
        this.saveRoleMapping(idpID, "", Boolean.FALSE, Boolean.TRUE, new HashMap<String, String>(), this.pluginSettingsService.getDefaultGroups(), Boolean.FALSE, Boolean.TRUE, this.pluginSettingsService.getDefaultDirectory(), "newUsers", Boolean.FALSE, new ArrayList<String>(), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, "None", "", "", "", "");
    }

    public void saveImportMetadata(String idpID, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        log.info("Saving Configuration for Import Metadata");
        log.debug("inputUrl/metadata = {} refreshMetadata = {}refreshInterval = {} customRefreshInterval = {} customRefreshIntervalUnit = {}", new Object[]{inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit});
        JSONObject importMetadataObj = PluginConfigHandler.buildImportMetadataJSON(inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
        this.pluginSettingsService.setImportMetadataConfig(importMetadataObj, idpID);
    }

    public void saveAttributeMapping(String idpID, String usernameAttr, String emailAttr, String fullNameAttr, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        log.info("Saving Attribute Mapping Configuration");
        log.debug("Attribute Mapping: Username Attribute: {}, Email Attribute: {}, Name Attribute: {}, useSeparateName: , First Name Attribute: {}, Last Name Attribute: {} keepExistingUserAttributes {} loginUserAttribute : {} regexPatternEnabled : {} regexPattern : {} Custom attributes : {}", new Object[]{usernameAttr, emailAttr, fullNameAttr, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping});
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            this.pluginSettingsService.setUsernameAttribute(usernameAttr);
            this.pluginSettingsService.setEmailAttribute(emailAttr);
            this.pluginSettingsService.setFirstNameAttribute(firstNameAttribute);
            this.pluginSettingsService.setLastNameAttribute(lastNameAttribute);
            this.pluginSettingsService.setFullNameAttribute(fullNameAttr);
            this.pluginSettingsService.setKeepExistingUserAttributes(keepExistingUserAttributes);
            this.pluginSettingsService.setLoginUserAttribute(loginUserAttribute);
            this.pluginSettingsService.setRegexPatternEnabled(regexPatternEnabled);
            this.pluginSettingsService.setRegexPattern(regexPattern);
            this.pluginSettingsService.setCustomAttributeMapping(customAttributeMapping);
        } else {
            JSONObject attributeConfig = PluginConfigHandler.buildAttributeConfigJSON(usernameAttr, emailAttr, fullNameAttr, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping);
            this.pluginSettingsService.setAttributeMappingConfig(attributeConfig, idpID);
        }
    }

    public void saveRoleMapping(String idpID, String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, List<String> defaultGroups, Boolean restrictUserCreation, Boolean updateUserOnlyIfRoleMapped, String defaultDirectory, String enableDefaultGroupsFor, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroups, Boolean createNewGroups, Boolean onTheFlyAssignNewGroupsOnly, Boolean applicationGroupEnrollment, Boolean groupRegexPatternEnabled, String onTheFlyFilterIDPGroupsOption, String onTheFlyFilterIDPGroupsKey, String regexPatternForGroup, String regexGroups, String testRegex) {
        log.info("Saving Group Mapping Configuration ");
        log.debug("roleAttribute = {} createUsersIfRoleMapped = {} keepExistingUserRoles = {} roleMapping = {} defaultGroups = {} restrictUserCreation = {} updateUserOnlyIfRoleMapped = {}defaultDirectory = {} enableDefaultGroupsFor = {},onTheFlyGroupCreation = {}, onTheFlyDoNotRemoveGroups = {}, createNewGroups={}, onTheFlyAssignNewGroupsOnly = {}, applicationGroupEnrollment = {} groupRegexPatternEnabled {} onTheFlyFilterIDPGroupsOption ={} onTheFlyFilterIDPGroupsKey ={} regexPatternForGroup ={} regexGroups ={} testRegex ={}", new Object[]{roleAttribute, createUsersIfRoleMapped, keepExistingUserRoles, roleMapping, defaultGroups, restrictUserCreation, updateUserOnlyIfRoleMapped, defaultDirectory, enableDefaultGroupsFor, onTheFlyGroupCreation, onTheFlyDoNotRemoveGroups, createNewGroups, onTheFlyAssignNewGroupsOnly, applicationGroupEnrollment, groupRegexPatternEnabled, onTheFlyFilterIDPGroupsOption, onTheFlyFilterIDPGroupsKey, regexPatternForGroup, regexGroups, testRegex});
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            this.pluginSettingsService.setRoleAttribute(roleAttribute);
            this.pluginSettingsService.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
            this.pluginSettingsService.setKeepExistingUserRoles(BooleanUtils.toBoolean((Boolean)keepExistingUserRoles));
            this.pluginSettingsService.setRoleMapping(roleMapping);
            this.pluginSettingsService.setRestrictUserCreation(restrictUserCreation);
            this.pluginSettingsService.setEnableDefaultGroupsFor(enableDefaultGroupsFor);
            this.pluginSettingsService.setUpdateUserOnlyIfRoleMapped(updateUserOnlyIfRoleMapped);
            this.pluginSettingsService.setOnTheFlyGroupCreation(onTheFlyGroupCreation);
            this.pluginSettingsService.setApplicationGroupEnrollment(applicationGroupEnrollment);
            if (BooleanUtils.toBoolean((Boolean)onTheFlyGroupCreation)) {
                this.pluginSettingsService.setCreateNewGroups(createNewGroups);
                this.pluginSettingsService.setOnTheFlyDoNotRemoveGroups(onTheFlyDoNotRemoveGroups);
                this.pluginSettingsService.setOnTheFlyAssignNewGroupsOnly(onTheFlyAssignNewGroupsOnly);
            }
            if (!BooleanUtils.toBoolean((Boolean)restrictUserCreation)) {
                this.pluginSettingsService.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
                if (!BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped)) {
                    this.pluginSettingsService.setDefaultGroups(defaultGroups);
                }
            }
            this.pluginSettingsService.setDefaultDirectory(defaultDirectory);
            this.pluginSettingsService.setGroupRegexPatternEnabled(groupRegexPatternEnabled);
            this.pluginSettingsService.setOnTheFlyFilterIDPGroupsOption(onTheFlyFilterIDPGroupsOption);
            this.pluginSettingsService.setOnTheFlyFilterIDPGroupsKey(onTheFlyFilterIDPGroupsKey);
            this.pluginSettingsService.setRegexPatternForGroup(regexPatternForGroup);
            this.pluginSettingsService.setRegexGroups(regexGroups);
            this.pluginSettingsService.setTestRegex(testRegex);
        } else {
            JSONObject groupMappingObject = PluginConfigHandler.buildGroupMappingConfigJSON(roleAttribute, createUsersIfRoleMapped, keepExistingUserRoles, roleMapping, defaultGroups, restrictUserCreation, enableDefaultGroupsFor, defaultDirectory, updateUserOnlyIfRoleMapped, onTheFlyGroupCreation, onTheFlyDoNotRemoveGroups, createNewGroups, onTheFlyAssignNewGroupsOnly, applicationGroupEnrollment, groupRegexPatternEnabled, onTheFlyFilterIDPGroupsOption, onTheFlyFilterIDPGroupsKey, regexPatternForGroup, regexGroups, testRegex);
            log.debug("[saveRoleMapping] Group Mapping Config {}", (Object)groupMappingObject);
            this.pluginSettingsService.setGroupMappingConfig(groupMappingObject, idpID);
        }
    }

    public void saveCustomerDetails(Customer customer) {
        log.debug("Saving customer details {}", (Object)customer.toString());
        this.pluginSettingsService.setCustomerId(customer.getCustomerId().toString());
        this.pluginSettingsService.setCustomerEmail(customer.getEmail());
        this.pluginSettingsService.setCustomerAPIKey(customer.getApiKey());
        this.pluginSettingsService.setCustomerTokenKey(customer.getTokenKey());
    }

    public void saveSPCertificates(Boolean signing, Boolean encryption) {
        log.debug("Saving SPCertificates Saving SP Info, Signing: {}, Encryption: {}", (Object)signing, (Object)encryption);
        this.pluginSettingsService.setSigning(signing);
        this.pluginSettingsService.setEncryption(encryption);
    }

    public void saveSPCertificates(String publicCertificate, String privateCertificate) {
        log.debug("saveSPCertificates Saving certificates " + publicCertificate);
        this.pluginSettingsService.setPublicSPCertificate(SAMLUtils.serializePublicCertificate(publicCertificate));
        this.pluginSettingsService.setPrivateSPCertificate(SAMLUtils.serializePrivateCertificate(privateCertificate));
        this.pluginSettingsService.setSPCertExpireOn(SAMLUtils.getCertificateInfo(publicCertificate).get("Valid To"));
    }

    public void saveSPConfiguration(String spBaseUrl, String spEntityId) {
        log.debug("Saving SPConfiguration Saving SP Info, SPBaseUrl: {}, SPEntityID: {}", (Object)spBaseUrl, (Object)spEntityId);
        this.pluginSettingsService.setSpBaseUrl(spBaseUrl);
        this.pluginSettingsService.setSpEntityId(spEntityId);
    }

    public void saveAdvancedConfiguration(String secretCode) {
        log.debug("Saving Advanced Configuration, secretCode: {}", (Object)secretCode);
        this.pluginSettingsService.setSecretKey(secretCode);
    }

    public void saveSigninSettings(String timeDelay, Boolean disableDefaultLogin, Boolean enableBackdoor, String loginButtonText, String relayState, String loginTemplate, Boolean autoActivateUser, Boolean enableSAMLSSO, Boolean restrictBackdoor, List<String> backdoorGroupsList, Boolean enableErrorMsgTemplate, String errorMsgTemplate) {
        log.debug("Saving AttributeMapping Saving Attribute Mapping: disableDefaultLogin: {}, enableBackdoor: {}, LoginButtonText: {}autoActivateUser: {}timeDelay: {}", new Object[]{disableDefaultLogin, enableBackdoor, loginButtonText, autoActivateUser, timeDelay});
        this.pluginSettingsService.setDefaultLoginDisabled(BooleanUtils.toBoolean((Boolean)disableDefaultLogin));
        this.pluginSettingsService.setAutoActivateUser(BooleanUtils.toBoolean((Boolean)autoActivateUser));
        this.pluginSettingsService.setTimeDelay(timeDelay);
        this.pluginSettingsService.setEnableErrorMsgTemplate(BooleanUtils.toBoolean((Boolean)enableErrorMsgTemplate));
        this.pluginSettingsService.setBackdoorEnabled(BooleanUtils.toBoolean((Boolean)enableBackdoor));
        this.pluginSettingsService.setLoginButtonText(loginButtonText);
        this.pluginSettingsService.setRelayState(relayState);
        this.pluginSettingsService.setLoginTemplate(loginTemplate);
        this.pluginSettingsService.setRestrictBackdoor(restrictBackdoor);
        this.pluginSettingsService.setBackdoorGroups(backdoorGroupsList);
        this.pluginSettingsService.setErrorMsgTemplate(errorMsgTemplate);
        this.pluginSettingsService.setEnableSAMLSSO(enableSAMLSSO);
    }

    public void replaceOldSettingsWithNew(String idpID, String idpName) {
        log.debug("Replacing old configuration with new");
        if (this.pluginSettingsService.getIdPList().isEmpty()) {
            this.saveIdPConfiguration(idpID, idpName, this.pluginSettingsService.getIdpEntityId(), this.pluginSettingsService.getSsoBindingType(), this.pluginSettingsService.getSsoServiceUrl(), this.pluginSettingsService.getSloBindingType(), this.pluginSettingsService.getSloServiceUrl(), (List)this.pluginSettingsService.getAllX509Certificates(), this.pluginSettingsService.getX509Certificate(), this.pluginSettingsService.getSignedRequest(), this.pluginSettingsService.getNameIdFormat(), this.pluginSettingsService.getInputMetadataUrl(), this.pluginSettingsService.getRefreshMetadata(), this.pluginSettingsService.getRefreshInterval(), this.pluginSettingsService.getCustomRefreshInterval(), this.pluginSettingsService.getCustomRefreshIntervalUnit());
            this.saveAttributeMapping(idpID, this.pluginSettingsService.getUsernameAttribute(), this.pluginSettingsService.getEmailAttribute(), this.pluginSettingsService.getFirstNameAttribute(), this.pluginSettingsService.getLastNameAttribute(), this.pluginSettingsService.getFullNameAttribute(), this.pluginSettingsService.getKeepExistingUserAttributes(), this.pluginSettingsService.getLoginUserAttribute(), this.pluginSettingsService.getRegexPatternEnabled(), this.pluginSettingsService.getRegexPattern(), this.pluginSettingsService.getCustomAttributeMapping());
            this.saveRoleMapping(idpID, this.pluginSettingsService.getRoleAttribute(), this.pluginSettingsService.getCreateUsersIfRoleMapped(), this.pluginSettingsService.getKeepExistingUserRoles(), this.pluginSettingsService.getRoleMapping(), this.pluginSettingsService.getDefaultGroups(), this.pluginSettingsService.getRestrictUserCreation(), this.pluginSettingsService.getUpdateUserOnlyIfRoleMapped(), this.pluginSettingsService.getDefaultDirectory(), this.pluginSettingsService.getEnableDefaultGroupsFor(), this.pluginSettingsService.getOnTheFlyGroupCreation(), this.pluginSettingsService.getOnTheFlyDoNotRemoveGroups(), this.pluginSettingsService.getCreateNewGroups(), this.pluginSettingsService.getOnTheFlyAssignNewGroupsOnly(), this.pluginSettingsService.getApplicationGroupEnrollment(), this.pluginSettingsService.getGroupRegexPatternEnabled(), this.pluginSettingsService.getOnTheFlyFilterIDPGroupsOption(), this.pluginSettingsService.getOnTheFlyFilterIDPGroupsKey(), this.pluginSettingsService.getRegexPatternForGroup(), this.pluginSettingsService.getRegexGroups(), this.pluginSettingsService.getTestRegex());
        }
    }

    public void fetchMetadata(String idpID, String idpName, String metadataUrl) {
        log.debug("Fetching metadata from IDP");
        String metadata = HttpUtils.sendGetRequest(metadataUrl);
        log.debug("Idp metadata: {}", (Object)metadata);
        try {
            this.configureFromMetadata(idpID, idpName, metadata, false);
            this.saveImportMetadata(idpID, metadataUrl, false, "hourly", 60, "minutes");
        }
        catch (Exception e) {
            log.error(PluginException.PluginErrorCode.METADATA_PARSE.getMessage(), (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "An error occurred while parsing IDP metadata or saving configuration. Please check logs for more info.", e);
        }
    }

    public void configureFromMetadata(String idpID, String idpName, String metadata, Boolean isRefreshTask) {
        log.debug("Configuring plugin using data retrieved from IDP SAML metadata ");
        metadata = metadata.replaceAll("[^\\x20-\\x7e]", "");
        IDPMetadata idpMetadata = this.pluginMetadataService.parseIdpSAMLMetadata(metadata);
        String idpEntityId = idpMetadata.getEntityId();
        String ssoBinding = "HttpRedirect";
        String ssoUrl = "";
        String sloBinding = "HttpRedirect";
        String sloUrl = "";
        String nameIdFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
        Boolean isRequestSigned = Boolean.TRUE;
        String inputUrl = "";
        Boolean refreshMetadata = Boolean.FALSE;
        String refreshInterval = "hourly";
        Integer customRefreshInterval = 60;
        String customRefreshIntervalUnit = "minutes";
        if (!BooleanUtils.toBoolean((Boolean)isRefreshTask)) {
            if (idpMetadata.getSingleSignOnServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                ssoBinding = "HttpRedirect";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else {
                ssoBinding = "HttpPost";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            }
            if (idpMetadata.getSingleLogoutServices().size() > 0) {
                if (idpMetadata.getSingleLogoutServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    sloBinding = "HttpRedirect";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                } else {
                    sloBinding = "HttpPost";
                    sloUrl = idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
                }
            }
        } else {
            IDPConfig idpConfig = this.buildIdpConfigForIdpId(idpID);
            ssoBinding = idpConfig.getSsoBindingType();
            ssoUrl = idpConfig.getSsoUrl();
            sloUrl = idpConfig.getSloUrl();
            sloBinding = idpConfig.getSloBindingType();
            isRequestSigned = idpConfig.getSignedRequest();
            inputUrl = idpConfig.getMetadataUrl();
            refreshMetadata = idpConfig.getRefreshMetadata();
            refreshInterval = idpConfig.getRefreshInterval();
            customRefreshInterval = idpConfig.getCustomRefreshInterval();
            customRefreshIntervalUnit = idpConfig.getCustomRefreshIntervalUnit();
        }
        String x509Certificate = idpMetadata.getCertificates().get(0);
        List<String> x509AllCertificates = idpMetadata.getCertificates();
        this.saveIdPConfiguration(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, x509AllCertificates, x509Certificate, isRequestSigned, nameIdFormat, inputUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit);
    }

    public void stopAllSchedulers() {
        log.debug("Stopping metadata schedulers ");
        ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
        for (String string : idpList) {
        }
    }

    public void toggleSchedulerService(String idpID) {
        log.debug("Schedule/ Unschedule IDP SSO certificate refresh");
        IDPConfig idpConfig = this.buildIdpConfigForIdpId(idpID);
        if (BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) {
            int n = SAMLUtils.getMetadataRefreshInterval(idpConfig.getRefreshInterval(), idpConfig.getCustomRefreshInterval(), idpConfig.getCustomRefreshIntervalUnit());
        }
    }

    public IDPConfig buildIdpConfigForIdpId(String idpID) {
        log.debug("Constructing IDPConfig - IDP config object");
        IDPConfig idpConfig = null;
        try {
            if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
                log.debug("constructIdpConfigObject for default IDP");
                JSONObject idpConfigObj = PluginConfigHandler.buildIdpConfigJSON(idpID, "IDP", this.pluginSettingsService.getIdpEntityId(), this.pluginSettingsService.getSsoBindingType(), this.pluginSettingsService.getSsoServiceUrl(), this.pluginSettingsService.getSloBindingType(), this.pluginSettingsService.getSloServiceUrl(), (List)this.pluginSettingsService.getAllX509Certificates(), this.pluginSettingsService.getX509Certificate(), this.pluginSettingsService.getSignedRequest(), this.pluginSettingsService.getNameIdFormat(), this.pluginSettingsService.getInputMetadataUrl(), this.pluginSettingsService.getRefreshMetadata(), this.pluginSettingsService.getRefreshInterval(), this.pluginSettingsService.getCustomRefreshInterval(), this.pluginSettingsService.getCustomRefreshIntervalUnit());
                log.debug("constructIdpConfigObject idpConfigObj : " + String.valueOf(idpConfigObj));
                if (idpConfigObj != null) {
                    JSONObject importMetadataConfigObj;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new IDPConfig();
                    PluginConfigHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = PluginConfigHandler.buildAttributeConfigJSON(this.pluginSettingsService.getUsernameAttribute(), this.pluginSettingsService.getEmailAttribute(), this.pluginSettingsService.getFullNameAttribute(), this.pluginSettingsService.getFirstNameAttribute(), this.pluginSettingsService.getLastNameAttribute(), this.pluginSettingsService.getKeepExistingUserAttributes(), this.pluginSettingsService.getLoginUserAttribute(), this.pluginSettingsService.getRegexPatternEnabled(), this.pluginSettingsService.getRegexPattern(), this.pluginSettingsService.getCustomAttributeMapping());
                    if (attributeMappingConfigObj != null) {
                        PluginConfigHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = PluginConfigHandler.buildGroupMappingConfigJSON(this.pluginSettingsService.getRoleAttribute(), this.pluginSettingsService.getCreateUsersIfRoleMapped(), this.pluginSettingsService.getKeepExistingUserRoles(), this.pluginSettingsService.getRoleMapping(), this.pluginSettingsService.getDefaultGroups(), this.pluginSettingsService.getRestrictUserCreation(), this.pluginSettingsService.getEnableDefaultGroupsFor(), this.pluginSettingsService.getDefaultDirectory(), this.pluginSettingsService.getUpdateUserOnlyIfRoleMapped(), this.pluginSettingsService.getOnTheFlyGroupCreation(), this.pluginSettingsService.getOnTheFlyDoNotRemoveGroups(), this.pluginSettingsService.getOnTheFlyAssignNewGroupsOnly(), this.pluginSettingsService.getCreateNewGroups(), this.pluginSettingsService.getApplicationGroupEnrollment(), this.pluginSettingsService.getGroupRegexPatternEnabled(), this.pluginSettingsService.getOnTheFlyFilterIDPGroupsOption(), this.pluginSettingsService.getOnTheFlyFilterIDPGroupsKey(), this.pluginSettingsService.getRegexPatternForGroup(), this.pluginSettingsService.getRegexGroups(), this.pluginSettingsService.getTestRegex())) != null) {
                        PluginConfigHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj, this.pluginSettingsService.getDefaultDirectory(), this.pluginSettingsService.getDefaultGroups());
                    }
                    if ((importMetadataConfigObj = PluginConfigHandler.buildImportMetadataJSON(this.pluginSettingsService.getInputMetadataUrl(), this.pluginSettingsService.getRefreshMetadata(), this.pluginSettingsService.getRefreshInterval(), this.pluginSettingsService.getCustomRefreshInterval(), this.pluginSettingsService.getCustomRefreshIntervalUnit())) != null) {
                        PluginConfigHandler.insertImportMetadataConfig(idpConfig, importMetadataConfigObj);
                    }
                }
            } else {
                log.debug("[constructIdPConfigObject]IDP ID: " + idpID);
                JSONObject idpConfigObj = this.pluginSettingsService.getIdpConfig(idpID);
                if (idpConfigObj != null) {
                    JSONObject importMetadataConfigObj;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new IDPConfig();
                    PluginConfigHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = this.pluginSettingsService.getAttributeMappingConfig(idpID);
                    if (attributeMappingConfigObj != null) {
                        PluginConfigHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = this.pluginSettingsService.getGroupMappingConfig(idpID)) != null) {
                        PluginConfigHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj, this.pluginSettingsService.getDefaultDirectory(), this.pluginSettingsService.getDefaultGroups());
                    }
                    if ((importMetadataConfigObj = this.pluginSettingsService.getImportMetadataConfig(idpID)) != null) {
                        idpConfig.setMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("An exception occurred while initializing IDP Configurations {}", (Object)t.getMessage());
        }
        return idpConfig;
    }

    @Generated
    public PluginConfigService(PluginSettingsService pluginSettingsService, PluginMetadataService pluginMetadataService) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginMetadataService = pluginMetadataService;
    }
}

