/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Base64;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="enablebackdoorurl")
@Produces(value={"application/json"})
@UnrestrictedAccess
public class SamlEnableBackdoorUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlEnableBackdoorUrl.class);
    private final UserManager userManager;
    private final PluginSettingsService settings;

    @GET
    public Response redirectToLoginPage() {
        LOGGER.debug("Enable Backdoor REST GET called, redirecting to login page");
        return Response.status((Response.Status)Response.Status.FOUND).header("Location", (Object)this.settings.getLoginPageUrl()).build();
    }

    @POST
    public Response enableBackdoor(@Context HttpHeaders headers) {
        try {
            boolean isAdmin;
            String authHeader = headers.getHeaderString("Authorization");
            if (StringUtils.isBlank(authHeader) || !authHeader.startsWith("Basic ")) {
                return this.buildError(Response.Status.UNAUTHORIZED, "Missing or invalid Authorization header");
            }
            String base64Credentials = authHeader.substring("Basic ".length()).trim();
            String credentials = new String(Base64.getDecoder().decode(base64Credentials));
            String[] values = credentials.split(":", 2);
            if (values.length < 2) {
                return this.buildError(Response.Status.UNAUTHORIZED, "Invalid Authorization format");
            }
            String username = values[0];
            String password = values[1];
            UserProfile user = this.userManager.getUserProfile(username);
            if (user == null || !this.userManager.authenticate(username, password)) {
                return this.buildError(Response.Status.UNAUTHORIZED, "Authentication failed. Invalid user or credentials.");
            }
            boolean bl = isAdmin = this.userManager.isAdmin(user.getUserKey()) || this.userManager.isSystemAdmin(user.getUserKey());
            if (!isAdmin) {
                LOGGER.error("User '{}' lacks admin privileges", (Object)username);
                return this.buildError(Response.Status.UNAUTHORIZED, "Insufficient privileges to enable backdoor");
            }
            this.settings.setBackdoorEnabled(true);
            JSONObject json = new JSONObject();
            json.put("Status", "SUCCESS");
            json.put("Message", "Successfully Enabled Backdoor URL");
            json.put("Crowd Backdoor-URL", this.settings.getBaseUrl() + "/console/login.action?" + this.settings.getBackdoorKey() + "=" + this.settings.getBackdoorValue());
            return Response.ok((Object)json.toString()).build();
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while enabling backdoor", (Throwable)e);
            return this.buildError(Response.Status.INTERNAL_SERVER_ERROR, "Internal error while processing the request");
        }
    }

    private Response buildError(Response.Status status, String message) {
        try {
            JSONObject json = new JSONObject();
            JSONObject error = new JSONObject();
            error.put("Status", "ERROR");
            error.put("Message", message);
            json.put("error", error);
            return Response.status((Response.Status)status).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to build JSON error response", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"{\"error\":{\"Status\":\"ERROR\",\"Message\":\"Unexpected error\"}}").build();
        }
    }

    @Inject
    @Generated
    public SamlEnableBackdoorUrl(UserManager userManager, PluginSettingsService settings) {
        this.userManager = userManager;
        this.settings = settings;
    }
}

