/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.service.PluginSettingsService;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="sso")
@Produces(value={"application/json"})
public class EnableSSOAPI {
    private final PluginSettingsService pluginSettingsService;
    private static Logger log = LoggerFactory.getLogger(EnableSSOAPI.class);

    @GET
    @AdminOnly
    public Response getNotAllowed() {
        log.info("EnableSSOAPI servlet called from doGet");
        log.info("GET request to /sso/toggle is not allowed");
        return this.buildError("GET method not allowed", "Use POST instead of GET");
    }

    @POST
    @AdminOnly
    public Response toggleSSO(@QueryParam(value="action") String action) {
        log.debug("EnableSSOAPI servlet called from doPost");
        log.debug("POST request received to toggle SSO with action: {}", (Object)action);
        if (StringUtils.isBlank((CharSequence)action)) {
            return this.buildError("No Parameter Sent", "Request does not contain any parameter");
        }
        switch (action.toLowerCase()) {
            case "enable": {
                this.pluginSettingsService.setEnableSAMLSSO(true);
                return this.buildSuccess("SSO Enabled Successfully", "SAML App Configured successfully.");
            }
            case "disable": {
                this.pluginSettingsService.setEnableSAMLSSO(false);
                return this.buildSuccess("SSO Disabled Successfully", "SAML App Configured successfully.");
            }
        }
        return this.buildError("Invalid Parameter", "Request contains invalid parameter");
    }

    private Response buildError(String message, String description) {
        JSONObject json = new JSONObject();
        json.put("Status", "ERROR");
        json.put("Message", message);
        json.put("Description", description);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
    }

    private Response buildSuccess(String message, String description) {
        JSONObject json = new JSONObject();
        json.put("Status", "SUCCESS");
        json.put("Message", message);
        json.put("Description", description);
        return Response.ok((Object)json.toString()).build();
    }

    @Inject
    @Generated
    public EnableSSOAPI(PluginSettingsService pluginSettingsService) {
        this.pluginSettingsService = pluginSettingsService;
    }
}

