/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.handler;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.handler.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.scheduler.MetadataRefreshScheduler;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import com.miniorange.sso.saml.utils.PluginUtils;
import com.miniorange.sso.saml.utils.SAMLUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigHandler {
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final PluginSettingsService pluginSettingsService;
    private final MetadataRefreshScheduler metadataRefreshScheduler;
    private final MoPluginConfigurationsHandler moPluginConfigurationsHandler;
    private static final Logger log = LoggerFactory.getLogger(PluginConfigHandler.class);

    public static JSONObject buildIdpConfigJSON(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        log.debug("Building JSON Object for IDP configuration");
        JSONObject idpConfigObj = new JSONObject();
        try {
            idpConfigObj.put("miniorange.saml.IDP_ID", idpID);
            idpConfigObj.put("miniorange.saml.IDP_NAME", StringUtils.trimToEmpty((String)idpName));
            idpConfigObj.put("miniorange.saml.IDP_ENTITY_ID", StringUtils.trimToEmpty((String)idpEntityId));
            idpConfigObj.put("miniorange.saml.SSO_URL", StringUtils.trimToEmpty((String)ssoUrl));
            idpConfigObj.put("miniorange.saml.SLO_URL", StringUtils.trimToEmpty((String)sloUrl));
            idpConfigObj.put("miniorange.saml.SSO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)ssoBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.put("miniorange.saml.SLO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)sloBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.putOpt("miniorange.saml.X509_CERTIFICATE", StringUtils.trimToEmpty((String)Objects.toString(SAMLUtils.serializePublicCertificate(x509Certificate), "")));
            idpConfigObj.put("miniorange.saml.SIGNED_REQUEST", BooleanUtils.toBooleanDefaultIfNull((Boolean)signedRequest, (boolean)false));
            if (x509AllCertificates != null) {
                for (String certificate : x509AllCertificates) {
                    idpConfigObj.append("miniorange.saml.ALL_X509_CERTIFICATES", StringUtils.trimToEmpty((String)SAMLUtils.serializePublicCertificate(certificate)));
                }
            }
            idpConfigObj.put("miniorange.saml.NAME_ID_FORMAT", StringUtils.defaultIfBlank((CharSequence)nameIdFormat, (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            idpConfigObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)inputUrl, (CharSequence)""));
            idpConfigObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBooleanDefaultIfNull((Boolean)refreshMetadata, (boolean)false));
            idpConfigObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            idpConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            idpConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
            log.debug("IDP config JSON object : {} ", (Object)idpConfigObj);
        }
        catch (JSONException e) {
            log.error("An error occurred while building IDP config JSON object", (Throwable)e);
        }
        return idpConfigObj;
    }

    public static JSONObject buildImportMetadataJSON(String inputUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        log.debug("Building JSON Object for import metadata configuration");
        JSONObject importMetadataObj = new JSONObject();
        try {
            importMetadataObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)inputUrl, (CharSequence)""));
            importMetadataObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBoolean((Boolean)refreshMetadata));
            importMetadataObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
            log.debug("Import metadata JSON object : {} ", (Object)importMetadataObj);
        }
        catch (Exception e) {
            log.error("An error occurred while building import metadata JSON object", (Throwable)e);
        }
        return importMetadataObj;
    }

    public static JSONObject buildAttributeConfigJSON(String usernameAttribute, String emailAttribute, String fullNameAttribute, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        log.debug("Constructing JSON Object for attribute mapping JSON object");
        JSONObject attributeMappingConfigObj = new JSONObject();
        try {
            attributeMappingConfigObj.put("miniorange.saml.USERNAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.EMAIL_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.FULL_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)firstNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.LAST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)lastNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserAttributes, (boolean)Boolean.FALSE));
            attributeMappingConfigObj.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"));
            attributeMappingConfigObj.put("miniorange.saml.ENABLE_REGEX_PATTERN", BooleanUtils.toBooleanDefaultIfNull((Boolean)regexPatternEnabled, (boolean)false));
            attributeMappingConfigObj.put("miniorange.saml.REGEX_PATTERN", StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""));
            JSONObject custom_attributeObj = new JSONObject();
            if (customAttributeMapping != null) {
                for (String keySet : customAttributeMapping.keySet()) {
                    custom_attributeObj.putOpt(keySet, customAttributeMapping.get(keySet));
                }
            }
            attributeMappingConfigObj.put("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING", custom_attributeObj);
            log.debug("Attribute mapping configuration JSON object : {} ", (Object)attributeMappingConfigObj);
        }
        catch (Exception e) {
            log.error("An error occurred while building attribute mapping JSON Object", (Throwable)e);
        }
        return attributeMappingConfigObj;
    }

    public static JSONObject buildGroupMappingConfigJSON(String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, List<String> defaultGroups, Boolean restrictUserCreation, String enableDefaultGroupsFor, String defaultDirectory, Boolean updateUserOnlyIfRoleMapped, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroups, Boolean createNewGroups, Boolean onTheFlyAssignNewGroupsOnly, Boolean applicationGroupEnrollment, Boolean groupRegexPatternEnabled, String onTheFlyFilterIDPGroupsOption, String onTheFlyFilterIDPGroupsKey, String regexPatternForGroup, String regexGroups, String testRegex) {
        log.debug("Building JSON Object for Group mapping JSON Object");
        JSONObject groupMappingConfigObj = new JSONObject();
        try {
            groupMappingConfigObj.put("miniorange.saml.ROLE_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)roleAttribute, (CharSequence)""));
            groupMappingConfigObj.put("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", BooleanUtils.toBooleanDefaultIfNull((Boolean)createUsersIfRoleMapped, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_USER_ROLES", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserRoles, (boolean)Boolean.FALSE));
            JSONObject groupMappingObj = new JSONObject();
            if (roleMapping != null) {
                for (String crowdGroup : roleMapping.keySet()) {
                    groupMappingObj.putOpt(crowdGroup, roleMapping.get(crowdGroup));
                }
            }
            groupMappingConfigObj.put("miniorange.saml.ROLE_MAPPING", groupMappingObj);
            groupMappingConfigObj.put("miniorange.saml.RESTRICT_USER_CREATION", BooleanUtils.toBoolean((Boolean)restrictUserCreation));
            groupMappingConfigObj.put("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", enableDefaultGroupsFor);
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_DIRECTORY", StringUtils.trimToEmpty((String)defaultDirectory));
            groupMappingConfigObj.put("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED", BooleanUtils.toBooleanDefaultIfNull((Boolean)updateUserOnlyIfRoleMapped, (boolean)false));
            JSONArray defaultGroupsObj = new JSONArray();
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_GROUP", defaultGroupsObj);
            for (String group : defaultGroups) {
                groupMappingConfigObj.append("miniorange.saml.DEFAULT_GROUP", group);
            }
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyGroupCreation, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyAssignNewGroupsOnly, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", BooleanUtils.toBooleanDefaultIfNull((Boolean)createNewGroups, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.APPLICATION_GROUP_ENROLLMENT", BooleanUtils.toBooleanDefaultIfNull((Boolean)applicationGroupEnrollment, (boolean)Boolean.FALSE));
            if (onTheFlyDoNotRemoveGroups != null) {
                for (String group : onTheFlyDoNotRemoveGroups) {
                    groupMappingConfigObj.append("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS", group);
                }
            }
            groupMappingConfigObj.put("miniorange.saml.REGEX_FOR_GROUPS_ENABLED", BooleanUtils.toBooleanDefaultIfNull((Boolean)groupRegexPatternEnabled, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION", StringUtils.trimToEmpty((String)onTheFlyFilterIDPGroupsOption));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY", StringUtils.trimToEmpty((String)onTheFlyFilterIDPGroupsKey));
            groupMappingConfigObj.put("miniorange.saml.REGEX_PATTERN_FOR_GROUPS", StringUtils.trimToEmpty((String)regexPatternForGroup));
            groupMappingConfigObj.put("miniorange.saml.REGEX_GROUPS", StringUtils.trimToEmpty((String)regexGroups));
            groupMappingConfigObj.put("miniorange.saml.TEXT_REGEX_FOR_GROUPS", StringUtils.trimToEmpty((String)testRegex));
            log.debug("Group mapping configuration : {} ", (Object)groupMappingConfigObj);
        }
        catch (Exception e) {
            log.error("An error occurred while building Group mapping JSON Object", (Throwable)e);
        }
        return groupMappingConfigObj;
    }

    public static void insertIDPConfig(IDPConfig idpConfig, JSONObject idpConfigObj) {
        log.debug("Inserting IDP configuration object into IDP Config");
        try {
            idpConfig.setIdpId(idpConfigObj.optString("miniorange.saml.IDP_ID", ""));
            idpConfig.setIdpName(idpConfigObj.optString("miniorange.saml.IDP_NAME", ""));
            idpConfig.setIdpEntityId(idpConfigObj.optString("miniorange.saml.IDP_ENTITY_ID", ""));
            idpConfig.setSsoUrl(idpConfigObj.optString("miniorange.saml.SSO_URL", ""));
            idpConfig.setSsoBindingType(idpConfigObj.optString("miniorange.saml.SSO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setSloUrl(idpConfigObj.optString("miniorange.saml.SLO_URL", ""));
            idpConfig.setSloBindingType(idpConfigObj.optString("miniorange.saml.SLO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setX509Certificate(idpConfigObj.optString("miniorange.saml.X509_CERTIFICATE", ""));
            JSONArray certificates = idpConfigObj.optJSONArray("miniorange.saml.ALL_X509_CERTIFICATES");
            ArrayList<String> x509AllCertificates = new ArrayList<String>();
            if (certificates != null) {
                for (int i = 0; i < certificates.length(); ++i) {
                    x509AllCertificates.add(certificates.getString(i));
                }
            }
            idpConfig.setCertificates(x509AllCertificates);
            idpConfig.setSignedRequest(idpConfigObj.optBoolean("miniorange.saml.SIGNED_REQUEST", true));
            idpConfig.setNameIdFormat(idpConfigObj.optString("miniorange.saml.NAME_ID_FORMAT", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            idpConfig.setMetadataUrl(idpConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setRefreshMetadata(idpConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(idpConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(idpConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(idpConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
            log.debug("IDP Config :  {} ", (Object)idpConfig);
        }
        catch (Exception e) {
            log.error("An error occurred while inserting IDP configuration", (Throwable)e);
        }
    }

    public static void insertAttributeMappingConfig(IDPConfig idpConfig, JSONObject attributeMappingConfigObj) {
        log.debug("Inserting Attribute Mapping configuration object into IDP Config");
        try {
            idpConfig.setUsernameAttribute(attributeMappingConfigObj.optString("miniorange.saml.USERNAME_ATTRIBUTE", "NameID"));
            idpConfig.setEmailAttribute(attributeMappingConfigObj.optString("miniorange.saml.EMAIL_ATTRIBUTE", "NameID"));
            idpConfig.setFullNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FULL_NAME_ATTRIBUTE", ""));
            idpConfig.setFirstNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FIRST_NAME_ATTRIBUTE", ""));
            idpConfig.setLastNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.LAST_NAME_ATTRIBUTE", ""));
            idpConfig.setKeepExistingUserAttributes(attributeMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", Boolean.TRUE));
            idpConfig.setLoginUserAttribute(attributeMappingConfigObj.optString("miniorange.saml.LOGIN_USER_ATTRIBUTE", "username"));
            idpConfig.setRegexPatternEnabled(attributeMappingConfigObj.optBoolean("miniorange.saml.ENABLE_REGEX_PATTERN", Boolean.FALSE));
            idpConfig.setRegexPattern(attributeMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN", ""));
            JSONObject customAttributeMapping = attributeMappingConfigObj.optJSONObject("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING");
            HashMap<String, String> customAttributeMappings = new HashMap<String, String>();
            if (customAttributeMapping != null) {
                Iterator<String> keySet = customAttributeMapping.keys();
                while (keySet.hasNext()) {
                    String customAttribute = keySet.next();
                    if (!StringUtils.isNotBlank((CharSequence)customAttributeMapping.getString(customAttribute))) continue;
                    customAttributeMappings.put(customAttribute, customAttributeMapping.getString(customAttribute));
                }
            }
            idpConfig.setCustomAttributeMapping(customAttributeMappings);
            log.debug("IDP Config :  {} ", (Object)idpConfig);
        }
        catch (Exception e) {
            log.error("An error occurred while inserting Attribute Mapping object", (Throwable)e);
        }
    }

    public static void insertGroupMappingConfig(IDPConfig idpConfig, JSONObject groupMappingConfigObj, String defaultDirectory, List<String> defaultGroup) {
        log.debug("Inserting Group Mapping configuration object into IDP Config");
        try {
            idpConfig.setDefaultDirectory(groupMappingConfigObj.optString("miniorange.saml.DEFAULT_DIRECTORY", defaultDirectory));
            idpConfig.setRoleAttribute(groupMappingConfigObj.optString("miniorange.saml.ROLE_ATTRIBUTE", ""));
            idpConfig.setCreateUsersIfRoleMapped(groupMappingConfigObj.optBoolean("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", false));
            idpConfig.setUpdateUserOnlyIfRoleMapped(groupMappingConfigObj.optBoolean("miniorange.saml.UPDATE_USER_ONLY_IF_ROLEMAPPED", false));
            idpConfig.setKeepExistingUserRoles(groupMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_USER_ROLES", Boolean.TRUE));
            List<String> defaultGroupsList = new ArrayList<String>();
            try {
                JSONArray defaultGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.DEFAULT_GROUP");
                if (defaultGroups != null) {
                    for (int i = 0; i < defaultGroups.length(); ++i) {
                        defaultGroupsList.add(defaultGroups.getString(i));
                    }
                }
                idpConfig.setDefaultGroups(defaultGroupsList.isEmpty() ? defaultGroup : defaultGroupsList);
            }
            catch (Exception e) {
                String defaultGroups = groupMappingConfigObj.optString("miniorange.saml.DEFAULT_GROUP");
                defaultGroupsList = Arrays.asList(defaultGroups.split(","));
                idpConfig.setDefaultGroups(defaultGroupsList.isEmpty() ? defaultGroup : defaultGroupsList);
            }
            JSONObject groupMapping = groupMappingConfigObj.optJSONObject("miniorange.saml.ROLE_MAPPING");
            HashMap<String, String> roleMapping = new HashMap<String, String>();
            if (groupMapping != null) {
                Iterator<String> crowdGroups = groupMapping.keys();
                while (crowdGroups.hasNext()) {
                    String crowdGroup = crowdGroups.next();
                    if (!StringUtils.isNotBlank((CharSequence)groupMapping.getString(crowdGroup))) continue;
                    roleMapping.put(crowdGroup, groupMapping.getString(crowdGroup));
                }
            }
            idpConfig.setRoleMapping(roleMapping);
            idpConfig.setRestrictUserCreation(groupMappingConfigObj.optBoolean("miniorange.saml.RESTRICT_USER_CREATION", false));
            idpConfig.setEnableDefaultGroupsFor(groupMappingConfigObj.optString("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", "newUsers"));
            idpConfig.setOnTheFlyGroupCreation(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", false));
            idpConfig.setOnTheFlyAssignNewGroupsOnly(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", Boolean.TRUE));
            idpConfig.setCreateNewGroups(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", Boolean.TRUE));
            idpConfig.setApplicationGroupEnrollment(groupMappingConfigObj.optBoolean("miniorange.saml.APPLICATION_GROUP_ENROLLMENT", false));
            JSONArray doNotRemoveGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
            ArrayList<String> doNotRemoveGroupsList = new ArrayList<String>();
            if (doNotRemoveGroups != null) {
                for (int i = 0; i < doNotRemoveGroups.length(); ++i) {
                    doNotRemoveGroupsList.add(doNotRemoveGroups.getString(i));
                }
            }
            idpConfig.setOnTheFlyDoNotRemoveGroups(doNotRemoveGroupsList);
            idpConfig.setGroupRegexPatternEnabled(groupMappingConfigObj.optBoolean("miniorange.saml.REGEX_FOR_GROUPS_ENABLED", Boolean.FALSE));
            idpConfig.setOnTheFlyFilterIDPGroupsOption(groupMappingConfigObj.optString("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_OPTION", "None"));
            idpConfig.setOnTheFlyFilterIDPGroupsKey(groupMappingConfigObj.optString("miniorange.saml.ON_THE_FLY_FILTER_IDP_GROUPS_KEY", ""));
            idpConfig.setRegexPatternForGroup(groupMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN_FOR_GROUPS", ""));
            idpConfig.setRegexGroups(groupMappingConfigObj.optString("miniorange.saml.REGEX_GROUPS", ""));
            idpConfig.setTestRegex(groupMappingConfigObj.optString("miniorange.saml.TEXT_REGEX_FOR_GROUPS", ""));
            log.debug("IDP Config :  {} ", (Object)idpConfig);
        }
        catch (Exception e) {
            log.error("An error occurred while interacting Group Mapping object", (Throwable)e);
        }
    }

    public static void insertImportMetadataConfig(IDPConfig idpConfig, JSONObject importMetadataConfigObj) {
        log.debug("Inserting Import Metadata configuration object into IDP Config");
        if (importMetadataConfigObj != null) {
            idpConfig.setMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setRefreshMetadata(importMetadataConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(importMetadataConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(importMetadataConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(importMetadataConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
        } else {
            idpConfig.setMetadataUrl("");
            idpConfig.setRefreshMetadata(Boolean.FALSE);
            idpConfig.setRefreshInterval("hourly");
            idpConfig.setCustomRefreshInterval(60);
            idpConfig.setCustomRefreshIntervalUnit("minutes");
        }
        log.debug("IDP Config :  {} ", (Object)idpConfig);
    }

    public HashMap<String, Object> initializeDefaultConfig(HttpServletRequest request, HttpServletResponse response, String successMessage, String errorMessage) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", successMessage);
        context.put("errorMessage", errorMessage);
        context.put("xsrfToken", this.xsrfTokenAccessor.getXsrfToken(request, response, true));
        context.put("contextPath", this.pluginSettingsService.getContextPath());
        context.put("baseUrl", this.pluginSettingsService.getBaseUrl());
        context.put("pluginSettingsService", this.pluginSettingsService);
        return context;
    }

    public void saveSigninSettings(String timeDelay, Boolean disableDefaultLogin, Boolean enableBackdoor, String loginButtonText, String relayState, String loginTemplate, Boolean autoActivateUser, Boolean enableSAMLSSO, Boolean restrictBackdoor, List<String> backdoorGroupsList, Boolean enableErrorMsgTemplate, String errorMsgTemplate, String backdoorKey, String backdoorValue) {
        log.debug("saveAttributeMapping Saving Attribute Mapping: disableDefaultLogin: " + disableDefaultLogin + ", enableBackdoor: " + enableBackdoor + ", LoginButtonText: " + loginButtonText + "autoActivateUser: " + autoActivateUser + "timeDelay: " + timeDelay);
        this.pluginSettingsService.setDefaultLoginDisabled(BooleanUtils.toBoolean((Boolean)disableDefaultLogin));
        this.pluginSettingsService.setAutoActivateUser(BooleanUtils.toBoolean((Boolean)autoActivateUser));
        this.pluginSettingsService.setTimeDelay(timeDelay);
        this.pluginSettingsService.setEnableErrorMsgTemplate(BooleanUtils.toBoolean((Boolean)enableErrorMsgTemplate));
        this.pluginSettingsService.setBackdoorEnabled(BooleanUtils.toBoolean((Boolean)enableBackdoor));
        this.pluginSettingsService.setLoginButtonText(loginButtonText);
        this.pluginSettingsService.setRelayState(relayState);
        this.pluginSettingsService.setLoginTemplate(loginTemplate);
        this.pluginSettingsService.setRestrictBackdoor(restrictBackdoor);
        this.pluginSettingsService.setBackdoorGroups(backdoorGroupsList);
        this.pluginSettingsService.setErrorMsgTemplate(errorMsgTemplate);
        this.pluginSettingsService.setEnableSAMLSSO(enableSAMLSSO);
        this.pluginSettingsService.setBackdoorKey(backdoorKey);
        this.pluginSettingsService.setBackdoorValue(backdoorValue);
    }

    public void replaceOldSettingsWithNew(String idpID, String idpName) {
        log.debug("replaceOldSettingsWithNew Called");
        if (this.pluginSettingsService.getIdPList().size() == 0) {
            // empty if block
        }
    }

    public void saveAttributeMapping(String idpID, String usernameAttr, String emailAttr, String fullNameAttr, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        log.info("Saving Attribute Mapping Configuration");
        log.debug("saveAttributeMapping Saving Attribute Mapping: UsernameAttr: " + usernameAttr + ", EmailAttr: " + emailAttr + ", NameAttr: " + fullNameAttr + ", useSeparateName: , firstName: " + firstNameAttribute + ", lastName: " + lastNameAttribute + "keepExistingUserAttributes " + keepExistingUserAttributes + " loginUserAttribute : " + loginUserAttribute + " regexPatternEnabled : " + regexPatternEnabled + " regexPattern : " + regexPattern + " Custom attributes : " + String.valueOf(customAttributeMapping));
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            this.pluginSettingsService.setUsernameAttribute(usernameAttr);
            this.pluginSettingsService.setEmailAttribute(emailAttr);
            this.pluginSettingsService.setFirstNameAttribute(firstNameAttribute);
            this.pluginSettingsService.setLastNameAttribute(lastNameAttribute);
            this.pluginSettingsService.setFullNameAttribute(fullNameAttr);
            this.pluginSettingsService.setKeepExistingUserAttributes(keepExistingUserAttributes);
            this.pluginSettingsService.setLoginUserAttribute(loginUserAttribute);
            this.pluginSettingsService.setRegexPatternEnabled(regexPatternEnabled);
            this.pluginSettingsService.setRegexPattern(regexPattern);
            this.pluginSettingsService.setCustomAttributeMapping(customAttributeMapping);
        } else {
            JSONObject attributeConfig = this.constructAttributeConfig(usernameAttr, emailAttr, fullNameAttr, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping);
            this.pluginSettingsService.setAttributeMappingConfig(attributeConfig, idpID);
        }
    }

    private JSONObject constructAttributeConfig(String usernameAttribute, String emailAttribute, String fullNameAttribute, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute, Boolean regexPatternEnabled, String regexPattern, HashMap<String, String> customAttributeMapping) {
        log.debug("saveAttributeMapping Saving Attribute Mapping: UsernameAttr: " + usernameAttribute + ", EmailAttr: " + emailAttribute + ", NameAttr: " + fullNameAttribute + ", useSeparateName: , firstName: " + firstNameAttribute + ", lastName: " + lastNameAttribute + "keepExistingUserAttributes " + keepExistingUserAttributes + " loginUserAttribute : " + loginUserAttribute + " regexPatternEnabled : " + regexPatternEnabled + " regexPattern : " + regexPattern + " Custom attributes : " + String.valueOf(customAttributeMapping));
        JSONObject attributeMappingConfigObj = new JSONObject();
        try {
            attributeMappingConfigObj.put("miniorange.saml.USERNAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.EMAIL_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)emailAttribute, (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.FULL_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)fullNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)firstNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.LAST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)lastNameAttribute, (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserAttributes, (boolean)Boolean.FALSE));
            attributeMappingConfigObj.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)loginUserAttribute, (CharSequence)"username"));
            attributeMappingConfigObj.put("miniorange.saml.ENABLE_REGEX_PATTERN", BooleanUtils.toBooleanDefaultIfNull((Boolean)regexPatternEnabled, (boolean)false));
            attributeMappingConfigObj.put("miniorange.saml.REGEX_PATTERN", StringUtils.defaultIfBlank((CharSequence)regexPattern, (CharSequence)""));
            JSONObject custom_attributeObj = new JSONObject();
            if (customAttributeMapping != null) {
                for (String keySet : customAttributeMapping.keySet()) {
                    custom_attributeObj.putOpt(keySet, customAttributeMapping.get(keySet));
                }
            }
            attributeMappingConfigObj.put("miniorange.saml.CUSTOM_ATTRIBUTE_MAPPING", custom_attributeObj);
        }
        catch (Exception e) {
            log.error("An error occurred while initializing attribute mapping configurations", (Throwable)e);
        }
        return attributeMappingConfigObj;
    }

    public Boolean verifyLicense(PluginSettingsService settings, String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", settings.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", settings.getSpBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", PluginConfigHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            log.debug("Verify license response: " + response);
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                log.debug(" statusNode : " + statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    this.getLicencedUsers(settings);
                    settings.setCustomerLicenseKey(key);
                    settings.setLicenseVerified(Boolean.TRUE);
                    return true;
                }
                return false;
            }
            log.debug("Please contact support. Response String: " + response);
            return false;
        }
        catch (Exception e) {
            log.error("An error occurred while verifying license key", (Throwable)e);
            return false;
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public void getLicencedUsers(PluginSettingsService settings) {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", settings.getCustomerID());
            jsonObject.put("applicationName", "crowd_saml_sso_premium_plan");
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", PluginConfigHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            log.debug("check customer license response: " + response);
            if (PluginUtils.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")).toString(), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    settings.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    settings.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    log.debug("no of license in user = " + licensedUsers);
                    if (licensedUsers > 0) {
                        settings.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            log.error("Please contact support. Response String: " + response);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            log.error("an error occurred while getting licensed users", (Throwable)e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            log.debug("getLicenseVerified = " + this.pluginSettingsService.getLicenseVerified());
            if (this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", this.pluginSettingsService.getCustomerLicenseKey());
                jsonObject.put("customerKey", this.pluginSettingsService.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", this.pluginSettingsService.getSpBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", PluginConfigHandler.getAuthorizationHeaders(Long.valueOf(this.pluginSettingsService.getCustomerID()), this.pluginSettingsService.getCustomerAPIKey()));
                log.debug("Deactivate license response: " + response);
            }
            this.pluginSettingsService.removeCustomerAccount();
        }
        catch (Exception e) {
            log.error("An error occurred while deactivating the license.", (Throwable)e);
            this.pluginSettingsService.removeCustomerAccount();
        }
    }

    public void importConfigurations(String pluginConfigurations) {
        log.debug("Importing app's configuration from config file");
        try {
            log.debug("importConfigurations :  pluginConfigurations  = " + pluginConfigurations);
            this.stopAllSchedulers();
            this.pluginSettingsService.clearOldConfiguration();
            this.pluginSettingsService.clearPluginSettings();
            this.moPluginConfigurationsHandler.importPluginConfigurations(pluginConfigurations);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "Invalid file uploaded");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "An error occurred while saving the configuration.");
        }
    }

    public void stopAllSchedulers() {
        log.debug("Stopping metadata schedulers ");
        ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
        for (String idp : idpList) {
            this.metadataRefreshScheduler.unscheduleJob(idp);
        }
        this.metadataRefreshScheduler.unscheduleJob("miniorange.saml.DEFAULT_IDP_ID");
    }

    @Generated
    public PluginConfigHandler(XsrfTokenAccessor xsrfTokenAccessor, PluginSettingsService pluginSettingsService, MetadataRefreshScheduler metadataRefreshScheduler, MoPluginConfigurationsHandler moPluginConfigurationsHandler) {
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.pluginSettingsService = pluginSettingsService;
        this.metadataRefreshScheduler = metadataRefreshScheduler;
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
    }
}

