/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyLicenseAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(VerifyLicenseAction.class);
    private final UserManager userManager;
    private final PluginLicenseService pluginLicenseService;
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginConfigService pluginConfigService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final PluginSettingsService pluginSettingsService;
    private final String VERIFY_LICENSE_FILE_PATH = "/templates/verifylicense.vm";
    public String successMessage = "";
    public String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Login Action: GET");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (this.pluginSettingsService.getTrialActivated().booleanValue() && this.pluginLicenseService.isTrialLicense() && this.pluginLicenseService.isLicenseExpired().booleanValue()) {
                this.pluginConfigHandler.deactivateAndRemoveCustomerAccount();
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue()) {
                if (this.pluginLicenseService.isValidLicense()) {
                    log.info("Valid license found, redirecting user: {} to plugin configuration", (Object)userProfile.getUsername());
                    response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/sp-config"));
                } else {
                    log.warn("Invalid license, redirecting user {} to license configuration", (Object)userProfile.getUsername());
                    response.setContentType("text/html;charset=utf-8");
                    this.templateRenderer.render("/templates/verifylicense.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
                }
                return;
            }
            log.warn("Customer is not registered ");
            response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
            return;
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Login Action: POST");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (userProfile != null && this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                if (Boolean.parseBoolean(request.getParameter("submitted"))) {
                    log.debug("verify license action submitted");
                    String key = request.getParameter("key");
                    log.debug("keyy - " + key);
                    if (StringUtils.isBlank((CharSequence)key)) {
                        this.errorMessage = "samlsso.error.verify.license.empty";
                        response.setContentType("text/html;charset=utf-8");
                        this.templateRenderer.render("/templates/verifylicense.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
                        return;
                    }
                    Boolean valid = this.pluginConfigHandler.verifyLicense(this.pluginSettingsService, key);
                    if (valid.booleanValue()) {
                        response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/sp-config"));
                        return;
                    }
                    this.errorMessage = "samlsso.error.verify.license.invalid";
                    response.setContentType("text/html;charset=utf-8");
                    this.templateRenderer.render("/templates/verifylicense.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
                    return;
                }
                response.setContentType("text/html;charset=utf-8");
                this.templateRenderer.render("/templates/verifylicense.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
                return;
            }
            log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
        }
        catch (PluginException pluginException) {
            log.error("Authentication failed! Invalid customer credentials");
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render("/templates/verifylicense.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while processing the request";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
        }
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("email", this.pluginSettingsService.getCustomerEmail());
        context.put("successMessage", this.successMessage);
        context.put("errorMessage", this.errorMessage);
        context.put("pluginConfigService", this.pluginConfigService);
        context.put("pluginLicenseService", this.pluginLicenseService);
        return context;
    }

    @Generated
    public VerifyLicenseAction(UserManager userManager, PluginLicenseService pluginLicenseService, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginConfigService pluginConfigService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, PluginSettingsService pluginSettingsService) {
        this.userManager = userManager;
        this.pluginLicenseService = pluginLicenseService;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigService = pluginConfigService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.pluginSettingsService = pluginSettingsService;
    }
}

