/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.configuration.SAMLIdpConfigAction;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpListAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLIdpConfigAction.class);
    private static final String CONFIG_FILE_PATH = "/templates/listidp.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseService pluginLicenseService;
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean domainsSubmitted;
    private String[] domains;
    private List<String> domainsList;
    private Boolean useDomainMapping;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    public String successMessage = "";
    public String errorMessage = "";

    public IdpListAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, LoginUriProvider loginUriProvider, PluginLicenseService pluginLicenseService) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseService = pluginLicenseService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SystemAdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            this.idpMap = this.pluginSettingsService.getIdpMap();
            this.idpList = this.pluginSettingsService.getIdPList();
            if (this.idpList.isEmpty()) {
                response.sendRedirect(this.pluginSettingsService.getSpBaseUrl() + "/plugins/servlet/crowd-saml/config/idp-config");
            } else if (this.idpList.size() == 1) {
                String id = this.idpList.get(0);
                response.sendRedirect(this.pluginSettingsService.getSpBaseUrl() + "/plugins/servlet/crowd-saml/config/idp-config?idpid=" + id);
            }
            String status = request.getParameter("status");
            String operation = request.getParameter("operation");
            if (!(StringUtils.isNotBlank((CharSequence)operation) && operation.equals("delete") || !StringUtils.isNotBlank((CharSequence)operation) || status.equals("success"))) {
                // empty if block
            }
        }
        catch (MoPluginException e) {
            log.error("moPluginexeption occurs...", (Throwable)e);
            return;
        }
        catch (Exception e) {
            log.error("An exeption occurs while saving the configuration", (Throwable)e);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeListIdp(request, response), (Writer)response.getWriter());
    }

    private HashMap<String, Object> initializeListIdp(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("idpMap", this.pluginSettingsService.getIdpMap());
        context.put("idpList", this.pluginSettingsService.getIdPList());
        return context;
    }
}

