/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.model.Customer;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.EncryptionUtils;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerLoginAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CustomerLoginAction.class);
    private final UserManager userManager;
    private final PluginLicenseService pluginLicenseService;
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginConfigService pluginConfigService;
    private final PluginConfigHandler pluginConfigHandler;
    private final PluginSettingsService pluginSettingsService;
    private final LicenseHandler licenseHandler;
    private final String CUSTOMER_LOGIN_URL = "/templates/customer-login.vm";
    public String successMessage = "";
    public String errorMessage = "";
    public String email;
    public String password;

    public CustomerLoginAction(UserManager userManager, PluginLicenseService pluginLicenseService, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginConfigService pluginConfigService, PluginConfigHandler pluginConfigHandler, LicenseHandler licenseHandler, PluginSettingsService pluginSettingsService) {
        this.userManager = userManager;
        this.pluginLicenseService = pluginLicenseService;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigService = pluginConfigService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.licenseHandler = licenseHandler;
        this.pluginSettingsService = pluginSettingsService;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Login Action: GET");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue()) {
                if (this.pluginLicenseService.isValidLicense()) {
                    log.info("Valid license found, redirecting user: {} to plugin configuration", (Object)userProfile.getUsername());
                    response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/sp-config"));
                } else {
                    log.warn("Invalid license, redirecting user {} to license configuration", (Object)userProfile.getUsername());
                    response.setContentType("text/html;charset=utf-8");
                    this.templateRenderer.render("/templates/customer-login.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
                }
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/customer-login.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Login Action: POST");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile != null && this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                String contentType = request.getHeader("Content-Type");
                if (contentType != null && contentType.contains("application/json")) {
                    log.info("Received JSON content type, attempting to handle license upload.");
                    String licenseKey = this.handleUpload(request);
                    log.info("LicenseKey after handleUpload:" + licenseKey);
                    if (licenseKey != null && !licenseKey.isEmpty() && this.isLicenseValid(licenseKey)) {
                        log.info("License is valid, redirecting to SP Config URL.");
                        response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/sp-config"));
                        return;
                    }
                    log.debug("Invalid License or empty license key from handleUpload.");
                    this.errorMessage = "Invalid_License!";
                } else if (Boolean.parseBoolean(request.getParameter("submitted"))) {
                    this.email = request.getParameter("email");
                    this.password = request.getParameter("password");
                    log.debug("customer email = " + this.email);
                    log.debug("password in request body  " + this.password);
                    Customer customer = this.pluginLicenseService.fetchCustomer(this.email, this.password);
                    if (customer != null) {
                        log.debug("Customer account verified successfully, redirecting to license configuration page =" + customer.getCustomerId());
                        this.pluginConfigService.saveCustomerDetails(customer);
                        response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/verify-license"));
                        return;
                    }
                    log.debug("Customer account verification failed");
                    this.errorMessage = "Authentication failed! Invalid customer credentials";
                } else {
                    log.warn("Unknown POST request. Neither JSON license upload nor form login.");
                    this.errorMessage = "Invalid request or missing parameters.";
                }
            } else {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render("/templates/customer-login.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
        }
        catch (PluginException pluginException) {
            log.error("Authentication failed! Invalid customer credentials");
            response.setContentType("text/html;charset=utf-8");
            this.templateRenderer.render("/templates/customer-login.vm", this.initializeConfig(request, response), (Writer)response.getWriter());
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while processing the request";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
        }
    }

    public boolean doValidate(Part licenseFilePart) {
        if (licenseFilePart == null) {
            log.debug("file not found");
            this.errorMessage = "File not found";
            return false;
        }
        if (licenseFilePart.getSize() == 0L) {
            log.debug("file is empty");
            this.errorMessage = "File is empty";
            return false;
        }
        String contentType = licenseFilePart.getContentType();
        log.debug("File content type: " + contentType);
        String fileName = licenseFilePart.getSubmittedFileName();
        log.debug("File name: " + fileName);
        if (fileName == null || fileName.trim().isEmpty()) {
            log.debug("filename is empty");
            this.errorMessage = "Filename is empty";
            return false;
        }
        log.debug("license file validation passed");
        return true;
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("successMessage", this.successMessage);
        context.put("errorMessage", this.errorMessage);
        context.put("pluginConfigService", this.pluginConfigService);
        context.put("pluginLicenseService", this.pluginLicenseService);
        return context;
    }

    private String handleUpload(HttpServletRequest request) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = request.getReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            String jsonBody = sb.toString();
            log.debug("Received JSON body: " + jsonBody);
            JSONObject json = new JSONObject(jsonBody);
            String licenseContent = json.optString("licenseContent");
            if (licenseContent == null || licenseContent.trim().isEmpty()) {
                log.error("License content is empty or null");
                this.errorMessage = "License file is empty";
                return null;
            }
            log.debug("Successfully received license content, length: " + licenseContent.length());
            return licenseContent;
        }
        catch (Exception e) {
            log.error("Error reading license JSON content", (Throwable)e);
            this.errorMessage = "Error processing uploaded content: " + e.getMessage();
            return null;
        }
    }

    private boolean isLicenseValid(String token) {
        try {
            String configuredKey = IOUtils.toString((InputStream)CustomerLoginAction.class.getResourceAsStream("/certificates/publicKey.crt"), (Charset)StandardCharsets.UTF_8);
            String serverId = "";
            if (this.licenseHandler.getServerId() != null) {
                serverId = this.licenseHandler.getServerId().trim();
                log.info("instance's serverID: " + serverId);
            }
            log.info("ServerID:" + serverId);
            URL domainURL = new URL(this.pluginSettingsService.getBaseUrl());
            String domainName = domainURL.getAuthority();
            log.info("Domain Name:" + domainName);
            token = EncryptionUtils.decrypt("u4JpSz2dti6u5kRB", token);
            log.debug("Token value after enc=" + token);
            RSAPublicKey publicKey = this.getPublicKey(configuredKey);
            Algorithm algorithm = Algorithm.RSA256(publicKey, null);
            JWTVerifier verifier = JWT.require(algorithm).withIssuer("miniOrange").build();
            DecodedJWT jwt = verifier.verify(token);
            log.debug("License Domain=" + jwt.getClaims().get("domainName").asString());
            if (jwt.getClaims().get("serverID").asString().equals(serverId) || jwt.getClaims().get("domainName").asString().contains(domainName) || jwt.getClaims().get("domainName").asString().contains("Skip_License_Check")) {
                return this.saveLicenseDetails(jwt.getClaims());
            }
        }
        catch (Exception exception) {
            log.debug("An error occurred while verifying license:" + String.valueOf(exception));
        }
        return false;
    }

    private RSAPublicKey getPublicKey(String configuredKey) {
        String publicKey = configuredKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        byte[] publicBytes = Base64.decodeBase64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("An error occurred while getting public key", (Throwable)e);
            return null;
        }
    }

    private boolean saveLicenseDetails(Map<String, Claim> claims) {
        try {
            log.debug("Saving license details");
            this.pluginSettingsService.setCustomerAPIKey(claims.get("customerKey").asString());
            this.pluginSettingsService.setCustomerEmail(claims.get("customerEmail").asString());
            this.pluginSettingsService.setCustomerId(claims.get("customerId").asString());
            this.pluginSettingsService.setCustomerTokenKey(claims.get("customerToken").asString());
            this.pluginSettingsService.setLicenseVerified(Boolean.TRUE);
            this.pluginSettingsService.setLicenseType(claims.get("licenseType").asString());
            this.pluginSettingsService.setLicencedUsers(Integer.valueOf(claims.get("userTier").asString()));
            this.pluginSettingsService.setLicenseExpireDate(claims.get("ExpiryDate").asString());
            if (!this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                this.errorMessage = "Invalid_Customer_Token_Key";
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error("Invalid License Details", (Throwable)e);
            this.errorMessage = "Invalid_License";
            return false;
        }
    }
}

