/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedPluginConfigAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdvancedPluginConfigAction.class);
    private static final String CONFIG_FILE_PATH = "/templates/advanced-configuration.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigService pluginConfigService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final PluginSettingsService pluginSettingsService;
    private final LoginUriProvider loginUriProvider;
    public String secretCode = "";
    public String successMessage = "";
    public String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Advanced Configurations: GET");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Advanced Configurations page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Advanced Configurations: POST");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Advanced Configurations page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        if (BooleanUtils.toBoolean((String)request.getParameter("configSubmitted"))) {
            this.generateRandomAlphaNumericKey(16);
        }
        context.put("secretKey", this.pluginSettingsService.getSecretKey().isEmpty() ? this.generateRandomAlphaNumericKey(16) : this.pluginSettingsService.getSecretKey());
        context.put("successMessage", this.successMessage);
        context.put("errorMessage", this.errorMessage);
        context.put("pluginConfigService", this.pluginConfigService);
        context.put("pluginLicenseService", this.pluginLicenseService);
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("timeDelay", this.pluginSettingsService.getTimeDelay());
        return context;
    }

    public String generateRandomAlphaNumericKey(int bytes) {
        String randomString = RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
        this.pluginSettingsService.setSecretKey(randomString);
        return randomString;
    }

    @Generated
    public AdvancedPluginConfigAction(TemplateRenderer templateRenderer, PluginLicenseService pluginLicenseService, PluginConfigService pluginConfigService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, PluginSettingsService pluginSettingsService, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigService = pluginConfigService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.pluginSettingsService = pluginSettingsService;
        this.loginUriProvider = loginUriProvider;
    }
}

