/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.miniorange.sso.saml.exception.SAMLException;
import com.miniorange.sso.saml.servlet.MoCustomDefaultBootstrap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xml.security.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAMLUtils {
    private static final Logger log = LoggerFactory.getLogger(SAMLUtils.class);
    public static List<String> certificates = new ArrayList<String>();
    private static boolean bootstrap = false;

    public static void doBootstrap() {
        if (!bootstrap) {
            try {
                bootstrap = true;
                MoCustomDefaultBootstrap.bootstrap();
            }
            catch (ConfigurationException e) {
                log.error("An error occurred while updating plugin configuration", (Throwable)e);
            }
        }
    }

    public static AuthnRequest buildAuthnRequest(String issuer, String acsUrl, String destination, String ssoBindingType, String nameIdFormat) {
        log.debug("Building authentication request");
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
        DateTime issueInstant = new DateTime();
        authnRequest.setID(SAMLUtils.generateRandomString());
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssueInstant(issueInstant);
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setIssuer(SAMLUtils.buildIssuer(issuer));
        authnRequest.setAssertionConsumerServiceURL(acsUrl);
        authnRequest.setDestination(destination);
        NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
        NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
        nameIdPolicy.setFormat(nameIdFormat);
        nameIdPolicy.setAllowCreate(true);
        authnRequest.setNameIDPolicy(nameIdPolicy);
        return authnRequest;
    }

    public static LogoutRequest buildLogoutRequest(String issuer, String destination, String nameId, String sessionIndex) {
        log.debug("Building Logout Request");
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutRequest", "samlp");
        DateTime issueInstant = new DateTime();
        logoutRequest.setIssueInstant(issueInstant);
        logoutRequest.setID(SAMLUtils.generateRandomString());
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        logoutRequest.setIssuer(SAMLUtils.buildIssuer(issuer));
        logoutRequest.setDestination(destination);
        NameID nameIdObj = new NameIDBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml");
        nameIdObj.setValue(nameId);
        logoutRequest.setNameID(nameIdObj);
        SessionIndex sessionIndexObj = new SessionIndexBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "SessionIndex", "samlp");
        sessionIndexObj.setSessionIndex(sessionIndex);
        logoutRequest.getSessionIndexes().add(sessionIndexObj);
        return logoutRequest;
    }

    public static LogoutResponse buildLogoutResponse(String issuer, String destination, String inResponseTo, String status) {
        log.debug("Building Logout Response");
        LogoutResponse logoutResponse = new LogoutResponseBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "LogoutResponse", "samlp");
        DateTime issueInstant = new DateTime();
        logoutResponse.setIssueInstant(issueInstant);
        logoutResponse.setID(SAMLUtils.generateRandomString());
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        logoutResponse.setIssuer(SAMLUtils.buildIssuer(issuer));
        logoutResponse.setDestination(destination);
        logoutResponse.setInResponseTo(inResponseTo);
        logoutResponse.setStatus(SAMLUtils.buildStatus(status));
        return logoutResponse;
    }

    public static LogoutRequest readLogoutRequest(String logoutRequestStr, Boolean isPostBinding) throws ParserConfigurationException, IOException, SAXException, UnmarshallingException, DataFormatException {
        log.debug("Reading Logout Request");
        byte[] base64Decoded = org.opensaml.xml.util.Base64.decode(logoutRequestStr);
        String requestXml = new String(base64Decoded, StandardCharsets.UTF_8);
        if (!isPostBinding.booleanValue()) {
            Inflater inflater = new Inflater(true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(byteArrayOutputStream, inflater);
            inflaterOutputStream.write(base64Decoded);
            inflaterOutputStream.close();
            byteArrayOutputStream.close();
            requestXml = byteArrayOutputStream.toString();
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        SAMLUtils.disableExternalEntityParsing(documentBuilderFactory);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(requestXml.getBytes());
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject xmlObj = unmarshaller.unmarshall(element);
        LogoutRequest logoutRequest = (LogoutRequest)xmlObj;
        return logoutRequest;
    }

    private static Issuer buildIssuer(String issuerValue) {
        log.debug("Building Issuer");
        Issuer issuer = new IssuerBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml");
        issuer.setValue(issuerValue);
        return issuer;
    }

    private static Status buildStatus(String statusCodeValue) {
        log.debug("Building status");
        StatusCode statusCode = new StatusCodeBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "StatusCode", "samlp");
        statusCode.setValue(statusCodeValue);
        Status status = new StatusBuilder().buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "Status", "samlp");
        status.setStatusCode(statusCode);
        return status;
    }

    public static String base64EncodeRequest(XMLObject request, Boolean isHttpPostBinding) throws Exception {
        log.debug("authn request = " + request.toString());
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(request);
        log.debug("marshaller = " + marshaller);
        Element authDOM = marshaller.marshall(request);
        log.debug("element dom = " + authDOM);
        StringWriter requestWriter = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, requestWriter);
        String requestMessage = requestWriter.toString();
        if (isHttpPostBinding.booleanValue()) {
            String authnRequestStr = org.opensaml.xml.util.Base64.encodeBytes(requestMessage.getBytes(StandardCharsets.UTF_8), 8);
            return authnRequestStr;
        }
        Deflater deflater = new Deflater(-1, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(requestMessage.getBytes(StandardCharsets.UTF_8));
        deflaterOutputStream.close();
        byteArrayOutputStream.close();
        String encodedRequestMessage = org.opensaml.xml.util.Base64.encodeBytes(byteArrayOutputStream.toByteArray(), 8);
        return encodedRequestMessage;
    }

    public static Response decodeResponse(String encodedResponse) throws Exception {
        log.debug("Decoding response.");
        String xml = new String(org.opensaml.xml.util.Base64.decode(encodedResponse), StandardCharsets.UTF_8);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        SAMLUtils.disableExternalEntityParsing(documentBuilderFactory);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        Document document = docBuilder.parse(is);
        Element element = document.getDocumentElement();
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
        XMLObject xmlObj = unmarshaller.unmarshall(element);
        Response response = (Response)xmlObj;
        return response;
    }

    public static Boolean verifyCertificate(SignableXMLObject response, String certificate) throws ValidationException, CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        log.debug("Verifying Certificate");
        if (response.isSigned()) {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(response.getSignature());
            Credential verificationCredential = SAMLUtils.getCredential(certificate, "");
            SignatureValidator sigValidator = new SignatureValidator(verificationCredential);
            sigValidator.validate(response.getSignature());
            log.debug("credential = " + verificationCredential);
            return Boolean.TRUE;
        }
        if (response instanceof Response) {
            throw new SAMLException(SAMLException.SAMLErrorCode.RESPONSE_NOT_SIGNED);
        }
        throw new SAMLException(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
    }

    private static Credential getCredential(String publicKey, String privateKeyStr) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException {
        log.debug("getCredential called.");
        publicKey = SAMLUtils.serializePublicCertificate(publicKey);
        ByteArrayInputStream is = new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8));
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        BasicX509Credential x509Credential = new BasicX509Credential();
        x509Credential.setPublicKey(cert.getPublicKey());
        PrivateKey privateKey = SAMLUtils.getPrivateKey(privateKeyStr);
        if (privateKey != null) {
            x509Credential.setPrivateKey(privateKey);
        }
        BasicX509Credential credential = x509Credential;
        log.debug("credential = " + credential);
        return credential;
    }

    private static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        log.debug("Getting private key.");
        if (StringUtils.isNotBlank((CharSequence)privateKey)) {
            privateKey = SAMLUtils.deserializePrivateCertificate(privateKey);
            byte[] bytes = org.opensaml.xml.util.Base64.decode(privateKey);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        return null;
    }

    public static String serializePublicCertificate(String certificate) {
        log.debug("Serializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            String cert = "-----" + BEGIN_CERTIFICATE + "-----\r\n" + certificate + "-----" + END_CERTIFICATE + "-----";
            return cert;
        }
        return certificate;
    }

    public static String serializePrivateCertificate(String certificate) {
        log.debug("Serializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
            Base64 encoder = new Base64(64);
            certificate = encoder.encodeToString(Base64.decodeBase64((String)certificate));
            String cert = "-----" + BEGIN_CERTIFICATE + "-----\r\n" + certificate + "-----" + END_CERTIFICATE + "-----";
            return cert;
        }
        return certificate;
    }

    public static String deserializePublicCertificate(String certificate) {
        log.debug("Deserializing Public Certificate");
        String BEGIN_CERTIFICATE = "BEGIN CERTIFICATE";
        String END_CERTIFICATE = "END CERTIFICATE";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static String deserializePrivateCertificate(String certificate) {
        log.debug("Deserializing Private Certificate");
        String BEGIN_CERTIFICATE = "BEGIN PRIVATE KEY";
        String END_CERTIFICATE = "END PRIVATE KEY";
        if (StringUtils.isNotBlank((CharSequence)certificate)) {
            certificate = StringUtils.remove((String)certificate, (String)"\r");
            certificate = StringUtils.remove((String)certificate, (String)"\n");
            certificate = StringUtils.remove((String)certificate, (String)"-");
            certificate = StringUtils.remove((String)certificate, (String)BEGIN_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)END_CERTIFICATE);
            certificate = StringUtils.remove((String)certificate, (String)" ");
        }
        return certificate;
    }

    public static Boolean isValidPublicCertificate(String certificate) {
        log.debug("Validating Public Certificate");
        certificate = SAMLUtils.serializePublicCertificate(certificate);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
            return Boolean.TRUE;
        }
        catch (CertificateException e) {
            log.debug(e.getMessage());
            return Boolean.FALSE;
        }
    }

    public static Boolean isValidPrivateCertificate(String certificate) {
        certificate = SAMLUtils.serializePrivateCertificate(certificate);
        try {
            SAMLUtils.getPrivateKey(certificate);
            return Boolean.TRUE;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            log.error("Error occurred while validating certificate", (Throwable)e);
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    public static String generateRandomString() {
        String uuid = UUID.randomUUID().toString();
        return "_" + StringUtils.remove((String)uuid, (char)'-');
    }

    public static String signHttpRedirectRequest(String requestQueryString, String sigAlgo, String pubicKey, String privateKey) throws Exception {
        log.debug("Signing HTTP Redirect Request.");
        String builder = requestQueryString + "&" + "SigAlg" + "=" + URLEncoder.encode(sigAlgo, "UTF-8");
        java.security.Signature signature = java.security.Signature.getInstance("SHA256withRSA");
        Credential credentials = SAMLUtils.getCredential(pubicKey, privateKey);
        signature.initSign(credentials.getPrivateKey());
        signature.update(builder.getBytes());
        byte[] signatureByteArray = signature.sign();
        String signatureBase64encodedString = org.opensaml.xml.util.Base64.encodeBytes(signatureByteArray);
        return signatureBase64encodedString;
    }

    public static SignableSAMLObject signHttpPostRequest(SignableSAMLObject request, String pubicKey, String privateKey) throws Exception {
        log.debug("Signing HTTP Post Request.");
        Signature signature = (Signature)Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        Credential credential = SAMLUtils.getCredential(pubicKey, privateKey);
        signature.setSigningCredential(credential);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        KeyInfoGeneratorManager keyInfoGeneratorManager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager().getDefaultManager();
        KeyInfoGeneratorFactory keyInfoGeneratorFactory = keyInfoGeneratorManager.getFactory(credential);
        KeyInfo keyInfo = keyInfoGeneratorFactory.newInstance().generate(credential);
        signature.setKeyInfo(keyInfo);
        String signatureAlgo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        signature.setSignatureAlgorithm(signatureAlgo);
        request.setSignature(signature);
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller(request);
        marshaller.marshall(request);
        Signer.signObject(signature);
        return request;
    }

    public static Assertion decryptAssertion(EncryptedAssertion encryptedAssertion, String publicKey, String privateKey) throws CertificateException, InvalidKeySpecException, NoSuchAlgorithmException, DecryptionException {
        log.debug("Decrypting Assertion");
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver(SAMLUtils.getCredential(publicKey, privateKey));
        Decrypter decrypter = new Decrypter(null, keyInfoCredentialResolver, new InlineEncryptedKeyResolver());
        Iterator<EncryptedKey> it = decrypter.getEncryptedKeyResolver().resolve(encryptedAssertion.getEncryptedData()).iterator();
        if (!it.hasNext()) {
            decrypter = new Decrypter(null, keyInfoCredentialResolver, new EncryptedElementTypeEncryptedKeyResolver());
        }
        decrypter.setRootInNewDocument(true);
        return decrypter.decrypt(encryptedAssertion);
    }

    public static String htmlEncode(String s) {
        log.debug("Encoding HTML String");
        if (StringUtils.isNotBlank((CharSequence)s)) {
            char[] chars;
            StringBuffer encodedString = new StringBuffer();
            for (char c : chars = s.toCharArray()) {
                if (c == '<') {
                    encodedString.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    encodedString.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    encodedString.append("&apos;");
                    continue;
                }
                if (c == '\"') {
                    encodedString.append("&quot;");
                    continue;
                }
                if (c == '&') {
                    encodedString.append("&amp;");
                    continue;
                }
                encodedString.append(c);
            }
            return encodedString.toString();
        }
        return "";
    }

    public static Boolean isValidCertificate(String certificate) {
        log.debug("Validating Certificate");
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8)));
            return Boolean.TRUE;
        }
        catch (CertificateException e) {
            return Boolean.FALSE;
        }
    }

    public static int getMetadataRefreshInterval(String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit) {
        log.debug("Getting Metadata refresh interval");
        int interval = StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"hourly") ? 60 : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"twicedaily") ? 720 : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"daily") ? 1440 : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"weekly") ? 10080 : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"monthly") ? 43200 : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"hours") ? customRefreshInterval * 60 : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"days") ? customRefreshInterval * 24 * 60 : customRefreshInterval))))));
        return interval;
    }

    public static Map<String, String> getCertificateInfo(String certificate) {
        log.debug("Retriving certificate information");
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
            LinkedHashMap<String, String> certificateInfo = new LinkedHashMap<String, String>();
            certificateInfo.put("Version", cert.getVersion() + "V");
            certificateInfo.put("Serial Number", cert.getSerialNumber().toString(16));
            certificateInfo.put("Signature Algorithm", cert.getSigAlgName());
            certificateInfo.put("Issuer", cert.getIssuerX500Principal().toString());
            certificateInfo.put("Subject", cert.getSubjectX500Principal().toString());
            certificateInfo.put("Valid From", cert.getNotBefore().toString());
            certificateInfo.put("Valid To", cert.getNotAfter().toString());
            certificateInfo.put("Public Key", cert.getPublicKey().getAlgorithm());
            certificateInfo.put("Thumbprint Algorithm", "sha1");
            certificateInfo.put("Thumbprint", SAMLUtils.getThumbPrint(cert));
            return certificateInfo;
        }
        catch (Exception e) {
            log.error("Error generating certificate info: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static String getThumbPrint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] encodedCert = cert.getEncoded();
            md.update(encodedCert);
            return SAMLUtils.hexify(md.digest());
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            log.error("Error generating thumbprint: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    private static String hexify(byte[] digest) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(digest.length * 2);
        for (int i = 0; i < digest.length; ++i) {
            buf.append(hexDigits[(digest[i] & 0xF0) >> 4]);
            buf.append(hexDigits[digest[i] & 0xF]);
        }
        return buf.toString();
    }

    public static KeyPair generateRSASHA256Certs() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            keyGen.initialize(2048, random);
            KeyPair pair = keyGen.generateKeyPair();
            return pair;
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error while generating RSA SHA 256 Key Pair.", (Throwable)e);
            return null;
        }
    }

    public static HashMap<String, Object> parseXml(String fileContents) {
        HashMap<String, Object> configValues = new HashMap<String, Object>();
        String idpEntityId = null;
        String singleSignOnUrl = null;
        String singleLogoutUrl = null;
        String ssoBinding = null;
        String sloBinding = null;
        Boolean isValidCertificate = true;
        certificates.clear();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new InputSource(new StringReader(fileContents)));
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName(doc.getDocumentElement().getNodeName());
            Node nNode = nList.item(0);
            if (nNode.getNodeType() == 1) {
                NodeList nList3;
                Element eElement = (Element)nNode;
                idpEntityId = eElement.getAttribute("entityID");
                NodeList nList1 = eElement.getElementsByTagName("md:KeyDescriptor");
                if (nList1.getLength() == 0) {
                    nList1 = eElement.getElementsByTagName("KeyDescriptor");
                }
                for (int temp1 = 0; temp1 < nList1.getLength(); ++temp1) {
                    Node nNode1 = nList1.item(temp1);
                    Element eElement1 = (Element)nNode1;
                    if (!eElement1.getAttribute("use").equals("signing")) continue;
                    boolean isRepeated = false;
                    for (int index = 0; index < certificates.size(); ++index) {
                        if (!SAMLUtils.isValidPublicCertificate(certificates.get(index)).booleanValue()) {
                            isValidCertificate = false;
                            continue;
                        }
                        if (!SAMLUtils.serializePublicCertificate(nNode1.getTextContent()).equals(certificates.get(index))) continue;
                        isRepeated = true;
                        break;
                    }
                    if (isRepeated) continue;
                    certificates.add(SAMLUtils.serializePublicCertificate(nNode1.getTextContent()));
                    if (SAMLUtils.isValidPublicCertificate(certificates.get(certificates.size() - 1)).booleanValue()) continue;
                    isValidCertificate = false;
                }
                NodeList nList2 = doc.getElementsByTagName("md:SingleSignOnService");
                if (nList2.getLength() == 0) {
                    nList2 = doc.getElementsByTagName("SingleSignOnService");
                }
                if (nList2.getLength() != 0) {
                    Node nNode2 = nList2.item(0);
                    Element eElement2 = (Element)nNode2;
                    ssoBinding = eElement2.getAttribute("Binding").contains("Redirect") ? "HttpRedirect" : "HttpPost";
                    singleSignOnUrl = eElement2.getAttribute("Location");
                }
                if ((nList3 = doc.getElementsByTagName("md:SingleLogoutService")).getLength() == 0) {
                    nList3 = doc.getElementsByTagName("SingleLogoutService");
                }
                if (nList3.getLength() != 0) {
                    Node nNode3 = nList3.item(0);
                    Element eElement3 = (Element)nNode3;
                    sloBinding = eElement3.getAttribute("Binding").contains("Redirect") ? "HttpRedirect" : "HttpPost";
                    singleLogoutUrl = eElement3.getAttribute("Location");
                }
            }
            if (idpEntityId == "" || singleSignOnUrl == "" || certificates.size() == 0 || !isValidCertificate.booleanValue()) {
                configValues.put("message", "error");
                return configValues;
            }
            configValues.put("idpEntityId", idpEntityId);
            configValues.put("ssoBinding", ssoBinding);
            configValues.put("singleSignOnUrl", singleSignOnUrl);
            configValues.put("sloBinding", sloBinding);
            configValues.put("singleLogoutUrl", singleLogoutUrl);
            configValues.put("X509Certificate", certificates.get(0));
            configValues.put("allX509Certificates", certificates);
            configValues.put("message", "success");
            return configValues;
        }
        catch (Exception e) {
            log.debug("There is an exception in parsing file" + e.getMessage());
            return null;
        }
    }

    private static void disableExternalEntityParsing(DocumentBuilderFactory dbf) {
        log.debug("Disabling External Entity Parsing from DocumentBuilderFactory");
        String FEATURE = null;
        try {
            FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
            dbf.setFeature(FEATURE, true);
            FEATURE = "http://xml.org/sax/features/external-general-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://xml.org/sax/features/external-parameter-entities";
            dbf.setFeature(FEATURE, false);
            FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            dbf.setFeature(FEATURE, false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException e) {
            log.debug("ParserConfigurationException was thrown. The feature '{}' is probably not supported by your XML processor.", (Object)FEATURE);
        }
    }
}

