/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.model.PluginAPIResponse;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.service.PluginUserService;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

public class PluginCertificateAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PluginCertificateAPI.class);
    private final PluginUserService pluginUserService;
    private final PluginSettingsService pluginSettingsService;
    private final PluginLicenseService pluginLicenseService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Crowd SAML plugin's public certificate endpoint");
        try {
            String action = request.getParameter("action");
            if (action == null) {
                response.sendError(400, "Action parameter is required");
                return;
            }
            log.debug("Action requested: {}", (Object)action);
            switch (action) {
                case "generateNewCert": {
                    this.handleGenerateNewCertificates(request, response);
                    break;
                }
                case "revertToOldCert": {
                    this.handleRevertOldCertificate(request, response);
                    break;
                }
                case "revertToNewCert": {
                    this.handleRevertNewCertificate(request, response);
                    break;
                }
                case "revertToOldConfiguredCert": {
                    this.handleRevertOldConfiguredCertificate(request, response);
                    break;
                }
                case "getCertificateExpiry": {
                    this.handleGetCertificateExpiry(request, response);
                    break;
                }
                case "downloadCertificate": {
                    this.downloadPluginCertificate(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(400, "Invalid Action. Please choose a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Plugin Certificate API Error : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    private void handleGenerateNewCertificates(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Generating new certificates");
        try {
            String companyName = request.getParameter("companyName");
            String locationName = request.getParameter("locationName");
            String countryCode = request.getParameter("countryCode");
            String orgUnit = request.getParameter("orgUnit");
            String emailAddress = request.getParameter("emailAddress");
            int validityDays = Integer.parseInt(request.getParameter("validityDays"));
            String distinguishedName = "";
            JSONObject jsonObject = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)emailAddress) && StringUtils.isNotBlank((CharSequence)companyName) && StringUtils.isNotBlank((CharSequence)locationName) && StringUtils.isNotBlank((CharSequence)countryCode) && StringUtils.isNotBlank((CharSequence)orgUnit) && validityDays > 0) {
                distinguishedName = "email=" + emailAddress + ", CN=" + companyName + ", OU=" + orgUnit + ", L=" + locationName + " , C=" + countryCode;
            } else {
                log.error("Plugin Certificate Generation Failed.  In sufficient date: ");
                response.setContentType("application/json");
                response.sendError(400, "Insufficient date");
            }
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(2048);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String algorithm = "SHA256withRSA";
            PrivateKey privateKey = keyPair.getPrivate();
            X509CertInfo info = new X509CertInfo();
            Date from = new Date();
            Date to = new Date(from.getTime() + (long)validityDays * 86400000L);
            CertificateValidity internal = new CertificateValidity(from, to);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            X500Name x500Name = new X500Name(companyName, orgUnit, orgUnit, countryCode);
            X500Principal dnName = new X500Principal(x500Name.toString());
            certGen.setSerialNumber(sn);
            certGen.setIssuerDN(dnName);
            certGen.setNotBefore(from);
            certGen.setNotAfter(to);
            certGen.setSubjectDN(dnName);
            certGen.setPublicKey(keyPair.getPublic());
            certGen.setSignatureAlgorithm(algorithm);
            X509Certificate cert = certGen.generate(keyPair.getPrivate(), new SecureRandom());
            byte[][] keyPairBytes = new byte[][]{keyPair.getPrivate().getEncoded(), cert.getEncoded()};
            Base64.Encoder encoder = Base64.getEncoder();
            this.pluginSettingsService.setOldConfiguredPrivateSPCertificate(this.pluginSettingsService.getPrivateSPCertificate());
            this.pluginSettingsService.setOldConfiguredPublicSPCertificate(this.pluginSettingsService.getPublicSPCertificate());
            this.pluginSettingsService.setPrivateSPCertificate(SAMLUtils.serializePrivateCertificate(encoder.encodeToString(keyPairBytes[0])));
            this.pluginSettingsService.setPublicSPCertificate(SAMLUtils.serializePublicCertificate(encoder.encodeToString(keyPairBytes[1])));
            this.setExpiryDate(this.pluginSettingsService.getPublicSPCertificate());
            this.pluginSettingsService.updateCertificateExpiredMessage(cert.getNotAfter());
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(200, "Plugin certificate generated successfully");
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("Plugin Certificate Generation Failed : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, "Plugin Certificate Generation Failed ");
        }
    }

    private void handleRevertOldCertificate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Reverting to previously configured certificate");
        try {
            this.pluginSettingsService.setOldConfiguredPrivateSPCertificate(this.pluginSettingsService.getPrivateSPCertificate());
            this.pluginSettingsService.setOldConfiguredPublicSPCertificate(this.pluginSettingsService.getPublicSPCertificate());
            this.pluginSettingsService.setPrivateSPCertificate("");
            this.pluginSettingsService.setPublicSPCertificate("");
            this.setExpiryDate(this.pluginSettingsService.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.pluginSettingsService.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.pluginSettingsService.updateCertificateExpiredMessage(expiryDate);
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
            pluginAPIResponse.setStatusCode(200);
            pluginAPIResponse.setMessage("Certificates are successfully reverted to previously configured certificate");
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("An error occurred while reverting to previously configured certificate : ", (Throwable)e);
            response.sendError(500, "An error occurred while reverting to previously configured certificate");
        }
    }

    private void handleRevertNewCertificate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Restoring newly configured certificate");
        try {
            this.pluginSettingsService.setOldConfiguredPrivateSPCertificate(this.pluginSettingsService.getPrivateSPCertificate());
            this.pluginSettingsService.setOldConfiguredPublicSPCertificate(this.pluginSettingsService.getPublicSPCertificate());
            this.pluginSettingsService.setPrivateSPCertificate(this.pluginSettingsService.getNewPrivateSPCertificate());
            this.pluginSettingsService.setPublicSPCertificate(this.pluginSettingsService.getNewPublicSPCertificate());
            this.setExpiryDate(this.pluginSettingsService.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.pluginSettingsService.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.pluginSettingsService.updateCertificateExpiredMessage(expiryDate);
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
            pluginAPIResponse.setStatusCode(200);
            pluginAPIResponse.setMessage("Newly configured certificates are restored successfully");
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("An error occurred while restoring newly configured certificate: ", (Throwable)e);
            response.sendError(500, "An error occurred while restoring newly configured certificate");
        }
    }

    private void handleRevertOldConfiguredCertificate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Reverting to default old certificate");
        try {
            this.pluginSettingsService.setPrivateSPCertificate(this.pluginSettingsService.getOldConfiguredPrivateSPCertificate());
            this.pluginSettingsService.setPublicSPCertificate(this.pluginSettingsService.getOldConfiguredPublicSPCertificate());
            this.setExpiryDate(this.pluginSettingsService.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.pluginSettingsService.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.pluginSettingsService.updateCertificateExpiredMessage(expiryDate);
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
            pluginAPIResponse.setStatusCode(200);
            pluginAPIResponse.setMessage("Default old certificates are restored successfully");
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("An error occurred while reverting to default old certificate: ", (Throwable)e);
            response.sendError(500, "An error occurred while reverting to default old certificate");
        }
    }

    private void handleGetCertificateExpiry(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Fetching expiry date of  configured certificate");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("days", (Object)this.pluginSettingsService.getSPCertExpireOn());
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
            pluginAPIResponse.setStatusCode(200);
            pluginAPIResponse.setMessage(jsonObject.toString());
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("An error occurred while getting expiry date of certificate: ", (Throwable)e);
            response.sendError(500, "An error occurred while getting expiry date of certificate");
        }
    }

    private void downloadPluginCertificate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Downloading Crowd SAML plugin's public certificate");
        try {
            String publicCertificate = this.pluginSettingsService.getPublicSPCertificate();
            response.setHeader("Content-Disposition", "attachment; filename=\"sp-certificate.crt\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
            pluginAPIResponse.setStatusCode(200);
            pluginAPIResponse.setMessage(publicCertificate);
            this.sendResponse(response, pluginAPIResponse);
        }
        catch (Exception e) {
            log.error("An error occurred while downloading certificate ", (Throwable)e);
            response.sendError(500, "An error occurred while downloading certificate");
        }
    }

    private void setExpiryDate(String publicCertificate) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(publicCertificate.getBytes(StandardCharsets.UTF_8)));
            this.pluginSettingsService.setSPCertExpireOn(cert.getNotAfter().toString());
        }
        catch (Exception e) {
            log.error("An error occurred while setting cert last date", (Throwable)e);
        }
    }

    private void sendResponse(HttpServletResponse response, PluginAPIResponse pluginAPIResponse) throws IOException {
        response.setStatus(pluginAPIResponse.getStatusCode());
        response.setContentType("application/json");
        response.getOutputStream().write(pluginAPIResponse.getMessage().getBytes(StandardCharsets.UTF_8));
        response.getOutputStream().close();
    }

    @Generated
    public PluginCertificateAPI(PluginUserService pluginUserService, PluginSettingsService pluginSettingsService, PluginLicenseService pluginLicenseService) {
        this.pluginUserService = pluginUserService;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginLicenseService = pluginLicenseService;
    }
}

