/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCert
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GenerateCert.class);
    private final PluginSettingsService settings;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        switch (action = req.getParameter("action")) {
            case "gennewcert": {
                this.generateNewCertificates(req, resp);
                break;
            }
            case "revertoldcert": {
                this.revertOldCertificate(req, resp);
                break;
            }
            case "revertnewcert": {
                this.revertNewCertificate(req, resp);
                break;
            }
            case "revertoldconfiguredcert": {
                this.revertOldConfiguredCertificate(req, resp);
                break;
            }
            case "getdays": {
                this.certExpireIN(req, resp);
                break;
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action.");
            }
        }
    }

    private void generateNewCertificates(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Generating new SP Key pairs");
        String companyName = request.getParameter("companyName");
        String locationName = request.getParameter("locationName");
        String countryCode = request.getParameter("countryCode");
        String orgUnit = request.getParameter("orgUnit");
        String emailAdsress = request.getParameter("emailAdsress");
        int validityDays = Integer.parseInt(request.getParameter("validityDays"));
        JSONObject jsonObject = new JSONObject();
        boolean resultStatus = false;
        if (!(StringUtils.isNotBlank((CharSequence)emailAdsress) && StringUtils.isNotBlank((CharSequence)companyName) && StringUtils.isNotBlank((CharSequence)locationName) && StringUtils.isNotBlank((CharSequence)countryCode) && StringUtils.isNotBlank((CharSequence)orgUnit) && validityDays > 0)) {
            this.sendErrorMessage(response, "Error");
            return;
        }
        String distinguishedName = "email=" + emailAdsress + ", CN=" + companyName + ", OU=" + orgUnit + ", L=" + locationName + " , C=" + countryCode;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(2048);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String algorithm = "SHA256withRSA";
            PrivateKey privateKey = keyPair.getPrivate();
            Date from = new Date();
            Date to = new Date(from.getTime() + (long)validityDays * 86400000L);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            X509Certificate cert = GenerateCert.generateCertificate(keyPair, companyName, orgUnit, countryCode, from, to, sn, algorithm);
            byte[][] keyPairBytes = new byte[][]{keyPair.getPrivate().getEncoded(), cert.getEncoded()};
            Base64.Encoder encoder = Base64.getEncoder();
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate(SAMLUtils.serializePrivateCertificate(encoder.encodeToString(keyPairBytes[0])));
            this.settings.setPublicSPCertificate(SAMLUtils.serializePublicCertificate(encoder.encodeToString(keyPairBytes[1])));
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            this.settings.updateCertificateExpiredMessage(cert.getNotAfter());
            jsonObject.put("resultStatus", true);
            resultStatus = true;
        }
        catch (Exception e) {
            log.debug("An error occurred while generating new cert", (Throwable)e);
        }
        if (resultStatus) {
            this.sendSuccessResponse(jsonObject.toString(), response);
            return;
        }
        this.sendErrorMessage(response, "Error");
    }

    private void revertOldCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate(this.settings.getOldDefaultPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getOldDefaultPublicSPCertificate());
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.settings.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.settings.updateCertificateExpiredMessage(expiryDate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            log.error("An error occurred while reverting old Certificates", (Throwable)e);
        }
    }

    private void revertNewCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate(this.settings.getNewPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getNewPublicSPCertificate());
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.settings.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.settings.updateCertificateExpiredMessage(expiryDate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            log.error("An error occurred while reverting old Certificates", (Throwable)e);
        }
    }

    private void revertOldConfiguredCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setPrivateSPCertificate(this.settings.getOldConfiguredPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getOldConfiguredPublicSPCertificate());
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            CertificateFactory cf = CertificateFactory.getInstance("x509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.settings.getPublicSPCertificate().getBytes(StandardCharsets.UTF_8)));
            Date expiryDate = x509Certificate.getNotAfter();
            this.settings.updateCertificateExpiredMessage(expiryDate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            log.error("An error occurred while reverting old Certificates", (Throwable)e);
        }
    }

    private void certExpireIN(HttpServletRequest request, HttpServletResponse response) {
        log.debug("Getting days remaining to expire Plugin Certificate");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("days", this.settings.getSPCertExpireOn());
            response.setContentType("application/json");
            response.setStatus(200);
            response.getOutputStream().write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.debug("An error occurred while getting days due to expire certificate", (Throwable)e);
        }
    }

    private void sendErrorMessage(HttpServletResponse resp, String errorMessages) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        if (errorMessages != null) {
            resp.getOutputStream().write(errorMessages.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendSuccessResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void setExpiryDate(String publicCertificate) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(publicCertificate.getBytes(StandardCharsets.UTF_8)));
            this.settings.setSPCertExpireOn(cert.getNotAfter().toString());
        }
        catch (Exception e) {
            log.error("An error occurred while setting cert last date", (Throwable)e);
        }
    }

    public static X509Certificate generateCertificate(KeyPair keyPair, String companyName, String orgUnit, String countryCode, Date from, Date to, BigInteger sn, String algorithm) throws GeneralSecurityException, OperatorCreationException, IOException {
        X500Name dnName = new X500Name(BCStyle.CN + "=" + companyName + ", " + BCStyle.OU + "=" + orgUnit + ", " + BCStyle.C + "=" + countryCode);
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(dnName, sn, from, to, dnName, keyPair.getPublic());
        try {
            X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certBuilder.build(new JcaContentSignerBuilder(algorithm).build(keyPair.getPrivate())));
            return cert;
        }
        catch (Exception e) {
            log.error("Certificate generation failed", (Throwable)e);
            throw new GeneralSecurityException("Certificate generation failed", e);
        }
    }

    @Generated
    public GenerateCert(PluginSettingsService settings) {
        this.settings = settings;
    }
}

