/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import com.miniorange.sso.saml.utils.PluginUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignInSettingsAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SignInSettingsAction.class);
    private static final String SIGN_IN_OPTIONS_VM_PATH = "/templates/signinoptions.vm";
    private final TemplateRenderer templateRenderer;
    private final I18nHelper i18nHelper;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseService pluginLicenseService;
    private String successMessage = "";
    private String errorMessage = "";
    private String message;

    public void doValidation(HttpServletRequest request, HttpServletResponse response) {
        log.info("SignInSettings Action doValidate called ");
        String relayState = request.getParameter("relayState");
        String timeDelay = request.getParameter("timeDelay");
        if (StringUtils.isNotBlank(relayState)) {
            try {
                new URL(relayState);
                if (!StringUtils.contains(relayState, this.pluginSettingsService.getSSODomain())) {
                    this.errorMessage = this.i18nHelper.getText("samlsso.error.sso.relaystate.domain.invalid");
                }
            }
            catch (MalformedURLException e) {
                this.errorMessage = this.i18nHelper.getText("samlsso.error.sso.relaystate.url.invalid");
            }
        }
        try {
            if (Integer.parseInt(timeDelay) < 0) {
                this.errorMessage = this.i18nHelper.getText("samlsso.timedelay.number.invalid");
            }
        }
        catch (NumberFormatException e) {
            this.errorMessage = this.i18nHelper.getText("samlsso.timedelay.number.invalid");
        }
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Crowd SAML Sign In settings: GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the Sign In Settings page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(SIGN_IN_OPTIONS_VM_PATH, this.initializeSignInSettingsConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Crowd SAML Sign In settings: POST ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(req), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                resp.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            Boolean disableDefaultLogin = Boolean.parseBoolean(req.getParameter("disableDefaultLogin"));
            String loginTemplate = req.getParameter("loginTemplate");
            Boolean enableBackdoor = Boolean.parseBoolean(req.getParameter("enableBackdoor"));
            String relayState = req.getParameter("relayState");
            String loginButtonText = req.getParameter("loginButtonText");
            String timeDelay = req.getParameter("timeDelay");
            String errorMsgTemplate = req.getParameter("errorMsgTemplate");
            Boolean autoActivateUser = Boolean.parseBoolean(req.getParameter("autoActivateUser"));
            Boolean enableSAMLSSO = Boolean.parseBoolean(req.getParameter("enableSAMLSSO"));
            Boolean enableErrorMsgTemplate = Boolean.parseBoolean(req.getParameter("enableErrorMsgTemplate"));
            String[] backdoorGroups = req.getParameterValues("backdoorGroups");
            Boolean restrictBackdoor = Boolean.parseBoolean(req.getParameter("restrictBackdoor"));
            String backdoorKey = req.getParameter("backdoorKey");
            String backdoorValue = req.getParameter("backdoorValue");
            List<String> backdoorGroupsList = PluginUtils.convertArrayToList(org.apache.commons.lang3.StringUtils.split((String)backdoorGroups[0], (String)","));
            if (restrictBackdoor == Boolean.TRUE && backdoorGroupsList.isEmpty()) {
                log.info("Backdoor Group/s Empty");
                this.errorMessage = this.i18nHelper.getText("samlsso.error.sso.autoredirect.restrict.groups.invalid");
            }
            this.doValidation(req, resp);
            this.pluginConfigHandler.saveSigninSettings(timeDelay, disableDefaultLogin, enableBackdoor, loginButtonText, relayState, loginTemplate, autoActivateUser, enableSAMLSSO, restrictBackdoor, backdoorGroupsList, enableErrorMsgTemplate, errorMsgTemplate, backdoorKey, backdoorValue);
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the Sign In Settings page";
            log.error(errorMessage, (Throwable)e);
            resp.sendError(500, errorMessage);
            return;
        }
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(SIGN_IN_OPTIONS_VM_PATH, this.initializeSignInSettingsConfig(req, resp), (Writer)resp.getWriter());
    }

    private HashMap<String, Object> initializeSignInSettingsConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("isCrowdVersionLatest", this.pluginSettingsService.getIsCrowdLatestVersion());
        context.put("disableDefaultLogin", this.pluginSettingsService.getDefaultLoginDisabled());
        context.put("enableBackdoor", this.pluginSettingsService.getBackdoorEnabled());
        context.put("relayState", this.pluginSettingsService.getRelayState());
        context.put("loginButtonText", this.pluginSettingsService.getLoginButtonText());
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("timeDelay", this.pluginSettingsService.getTimeDelay());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("loginTemplate", this.pluginSettingsService.getLoginTemplate());
        context.put("errorMsgTemplate", this.pluginSettingsService.getErrorMsgTemplate());
        context.put("autoActivateUser", this.pluginSettingsService.getAutoActivateUser());
        context.put("enableSAMLSSO", this.pluginSettingsService.getEnableSAMLSSO());
        context.put("enableErrorMsgTemplate", this.pluginSettingsService.getEnableErrorMsgTemplate());
        context.put("restrictBackdoor", this.pluginSettingsService.getRestrictBackdoor());
        context.put("backdoorGroupsList", this.pluginSettingsService.getBackdoorGroups());
        context.put("backdoorKey", this.pluginSettingsService.getBackdoorKey());
        context.put("backdoorValue", this.pluginSettingsService.getBackdoorValue());
        return context;
    }

    @Generated
    public SignInSettingsAction(TemplateRenderer templateRenderer, I18nHelper i18nHelper, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, LoginUriProvider loginUriProvider, PluginLicenseService pluginLicenseService) {
        this.templateRenderer = templateRenderer;
        this.i18nHelper = i18nHelper;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseService = pluginLicenseService;
    }
}

