/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionUtils {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtils.class);
    private static final String ENCRYPTION_ALGORITHM = "AES";

    public static String encrypt(String encryptionKey, String data) {
        if (StringUtils.isBlank((CharSequence)encryptionKey) || StringUtils.isBlank((CharSequence)data)) {
            log.warn("Encryption key or data is blank.");
            return "";
        }
        try {
            byte[] decodedKey = encryptionKey.getBytes(StandardCharsets.UTF_8);
            byte[] truncatedKey = decodedKey.length > 16 ? Arrays.copyOf(decodedKey, 16) : decodedKey;
            SecretKeySpec key = new SecretKeySpec(truncatedKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(1, key);
            byte[] encVal = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
            log.debug("Returning base 64 encoded encrypted value");
            return Base64.encodeBase64String(encVal);
        }
        catch (Exception e) {
            log.error("Encryption error: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static String decrypt(String encryptionKey, String data) {
        if (StringUtils.isBlank((CharSequence)encryptionKey) || StringUtils.isBlank((CharSequence)data)) {
            log.warn("Encryption key or data is blank.");
            return "";
        }
        try {
            byte[] decodedDataString = Base64.decodeBase64(data);
            byte[] decodedKey = encryptionKey.getBytes(StandardCharsets.UTF_8);
            byte[] truncatedKey = decodedKey.length > 16 ? Arrays.copyOf(decodedKey, 16) : decodedKey;
            SecretKeySpec key = new SecretKeySpec(truncatedKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(2, key);
            byte[] decVal = cipher.doFinal(decodedDataString);
            return new String(decVal, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("Decryption error: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public static String generateRandomAlphaNumericKey(int length) {
        if (length <= 0) {
            log.warn("Requested length for random key is non-positive: {}", (Object)length);
            return "";
        }
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    public static String encryptString(String toEncrypt, String twoFAKey) {
        try {
            SecretKeySpec secretKey = EncryptionUtils.getSecretKey(twoFAKey);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            return java.util.Base64.getEncoder().encodeToString(cipher.doFinal(toEncrypt.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            log.error("Error while encrypting", (Throwable)e);
            return null;
        }
    }

    public static SecretKeySpec getSecretKey(String myKey) {
        SecretKeySpec secretKey = null;
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            secretKey = new SecretKeySpec(key, ENCRYPTION_ALGORITHM);
            return secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

