/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.model.PluginAPIResponse;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.service.PluginUserService;
import com.miniorange.sso.saml.utils.PluginUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminPluginConfigAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AdminPluginConfigAPI.class);
    private final PluginUserService pluginUserService;
    private final PluginLicenseService pluginLicenseService;
    private final PluginSettingsService pluginSettingsService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Admin Plugin Config API : GET");
        try {
            if (!this.pluginUserService.isSystemAdminAuthenticated(request)) {
                log.warn("User is not a system admin");
                response.sendError(401, "Unauthorized access");
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(401, "Unauthorized access. Invalid License");
                return;
            }
            String returnTo = request.getParameter("return_to");
            if (StringUtils.contains((CharSequence)returnTo, (CharSequence)"testgroupregex")) {
                log.debug("regex test for group");
                this.showTestRegexGroupResult(request, response);
                return;
            }
            String action = request.getParameter("action");
            if (action == null) {
                response.sendError(400, "Action parameter is required");
                return;
            }
            String idpId = request.getParameter("idpId");
            log.debug("Admin Plugin Config GET API : Action: {}  and IDP ID : {}", (Object)action, (Object)idpId);
            switch (action) {
                case "enableSSO": {
                    this.handleEnableSSO(request, response);
                    break;
                }
                case "disableSSO": {
                    this.handleDisableSSO(request, response);
                    break;
                }
                case "deleteIdp": {
                    this.handleDeleteIdp(request, response);
                    break;
                }
                case "enableDebugLogs": {
                    this.handleEnableDebugLogs(request, response);
                    break;
                }
                case "downloadCrowdLogs": {
                    this.handleDownloadCrowdLogs(request, response);
                    break;
                }
                case "saveCompatibleDefaultLoginTemplate": {
                    this.saveCompatibleDefaultLoginTemplate(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(400, "Invalid Action. Please choose a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Admin Plugin Config API Error : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Admin Plugin Config API : POST");
        try {
            if (!this.pluginUserService.isSystemAdminAuthenticated(request)) {
                log.warn("User is not a system admin");
                response.sendError(401, "Unauthorized access");
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(401, "Unauthorized access. Invalid License");
                return;
            }
            String action = request.getParameter("action");
            if (action == null) {
                response.sendError(400, "Action parameter is required");
                return;
            }
            switch (action) {
                case "saveBackdoor": {
                    this.saveBackdoor(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(400, "Invalid Action. Please choose a valid action.");
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Admin Plugin Config API Error : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    private void saveBackdoor(HttpServletRequest request, HttpServletResponse response) {
        String backdoorKey = request.getParameter("backdoorKey");
        String backdoorValue = request.getParameter("backdoorValue");
        this.pluginSettingsService.setBackdoorKey(backdoorKey);
        this.pluginSettingsService.setBackdoorValue(backdoorValue);
    }

    private void saveCompatibleDefaultLoginTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("saving Compatible Default Login Template");
        String CompatibleDefaultLoginTemplate = PluginUtils.readFileFromResource("/templates/logintemplate.vm");
        this.pluginSettingsService.setLoginTemplate(CompatibleDefaultLoginTemplate);
        response.getWriter().write(CompatibleDefaultLoginTemplate);
    }

    private void handleEnableSSO(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Enabling SSO for IDP");
        this.pluginSettingsService.setEnableSAMLSSO(Boolean.TRUE);
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(200, "SSO Enabled Successfully");
        this.sendResponse(response, pluginAPIResponse);
    }

    private void handleDisableSSO(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Disabling SSO for IDP");
        this.pluginSettingsService.setEnableSAMLSSO(Boolean.FALSE);
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse(200, "SSO Disabled Successfully");
        this.sendResponse(response, pluginAPIResponse);
    }

    private void handleDeleteIdp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Deleting SSO for IDP");
        String idpId = request.getParameter("idpId");
        PluginAPIResponse pluginAPIResponse = new PluginAPIResponse();
    }

    private void handleEnableDebugLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
    }

    @Deprecated
    private void handleDownloadCrowdLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.debug("Deprecated method invoked: handleDownloadCrowdLogs. Log file download initiated from the current node.");
    }

    private void sendResponse(HttpServletResponse response, PluginAPIResponse pluginAPIResponse) throws IOException {
        response.setStatus(pluginAPIResponse.getStatusCode());
        response.setContentType("application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("status", pluginAPIResponse.getStatusCode());
        jsonObject.put("message", (Object)pluginAPIResponse.getMessage());
        response.getOutputStream().write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
        response.getOutputStream().close();
    }

    public void showTestRegexGroupResult(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = request.getParameter("regexp");
        String regexg = request.getParameter("regexg");
        String groupName = request.getParameter("groupName");
        String result = "";
        regexp = StringEscapeUtils.escapeJavaScript(regexp);
        regexg = StringEscapeUtils.escapeJavaScript(regexg);
        groupName = StringEscapeUtils.escapeJavaScript(groupName);
        log.debug("in show test regex function");
        log.debug("regexp is" + regexp + " regexq is" + regexg + " group name is =" + groupName);
        if (StringUtils.isNotEmpty((CharSequence)regexg) && StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = this.pluginUserService.getGroupNameFromRegexMethod(regexp, regexg, groupName);
            log.debug("result of test regex" + result);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)regexg) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)regexg)) {
                output.append("<li>Replace with field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Actual Value</th>\n        <th>Transformed Value</th>\n    </tr>\n    <tr>\n        <td align=\"center\">" + groupName + "</td>\n        <td align=\"center\">" + result + "</td>\n    </tr>    \n    </tbody></table>");
        } else if (StringUtils.isEmpty((CharSequence)result) && StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            output.append("<li>Regex not valid for the group Name.</li><br>");
            output.append("</div>");
        }
        output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    @Generated
    public AdminPluginConfigAPI(PluginUserService pluginUserService, PluginLicenseService pluginLicenseService, PluginSettingsService pluginSettingsService) {
        this.pluginUserService = pluginUserService;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginSettingsService = pluginSettingsService;
    }
}

