/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLIdpConfigAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLIdpConfigAction.class);
    private static final String CONFIG_FILE_PATH = "/templates/addidp.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigService pluginConfigService;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    public String secretCode = "";
    private String x509Certificate;
    private String idpID;
    private String idpName;
    private List<String> idpList;
    private Boolean shouldShowBackButton;
    private Integer customRefreshInterval;
    public String successMessage = "";
    public String errorMessage = "";
    public String allX509certificates;

    public SAMLIdpConfigAction(TemplateRenderer templateRenderer, PluginLicenseService pluginLicenseService, PluginConfigService pluginConfigService, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigService = pluginConfigService;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. SP Configurations: GET");
        if (!this.applicationServices.isSystemAdmin().booleanValue()) {
            log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
            return;
        }
        if (!this.pluginLicenseService.isValidLicense()) {
            log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
            response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
            return;
        }
        try {
            this.idpList = this.getIdpList();
            this.idpID = request.getParameter("idpid");
            if (StringUtils.isBlank((CharSequence)request.getParameter("idpid"))) {
                this.idpID = UUID.randomUUID().toString();
                if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                    log.debug("Storing old IDP config values and initializing idp: " + this.idpID);
                    this.idpName = "IDP";
                    this.pluginConfigService.replaceOldSettingsWithNew(this.idpID, this.idpName);
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"add", (CharSequence)request.getParameter("operation")) || this.idpList.size() > 1) {
                this.shouldShowBackButton = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the IDP configuration page";
            log.error("Failed to render the IDP Configurations page. Error details: {}", (Object)e.getMessage(), (Object)e);
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            this.idpList = this.getIdpList();
            this.idpID = request.getParameter("idpID");
            if (StringUtils.isBlank((CharSequence)request.getParameter("idpID"))) {
                this.idpID = UUID.randomUUID().toString();
                if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                    log.debug("Storing old IDP config values and initializing idp: " + this.idpID);
                    this.idpName = "IDP";
                    this.pluginConfigService.replaceOldSettingsWithNew(this.idpID, this.idpName);
                }
            }
            log.info("IdP configuration submitted");
            String[] x509Certificates = request.getParameterValues("x509AllCertificates");
            String x509Certificate = request.getParameter("x509Certificate");
            ArrayList<String> x509allcertificates = new ArrayList<String>();
            if (x509Certificate != null) {
                x509allcertificates.add(StringUtils.trim((String)x509Certificate));
            }
            if (x509Certificates != null && x509Certificates.length != 0) {
                x509allcertificates.addAll(Arrays.asList(x509Certificates));
            }
            if (x509Certificate == null && x509allcertificates.size() != 0) {
                x509Certificate = (String)x509allcertificates.get(0);
            }
            this.customRefreshInterval = request.getParameter("customRefreshInterval").isEmpty() ? 60 : Integer.valueOf(request.getParameter("customRefreshInterval"));
            this.pluginConfigService.saveIdPConfiguration(this.idpID, request.getParameter("idpName"), request.getParameter("idpEntityId"), request.getParameter("ssoBindingType"), request.getParameter("ssoUrl"), request.getParameter("sloBindingType"), request.getParameter("sloUrl"), x509allcertificates, StringUtils.trim((String)this.x509Certificate), Boolean.valueOf(request.getParameter("signedRequest")), request.getParameter("nameIdFormat"), request.getParameter("inputUrl"), Boolean.valueOf(request.getParameter("refreshMetadata")), request.getParameter("refreshInterval"), this.customRefreshInterval, request.getParameter("customRefreshIntervalUnit"));
            if (this.pluginSettingsService.getIdPList().size() > 1) {
                response.sendRedirect(this.pluginSettingsService.getSpBaseUrl() + "/plugins/servlet/crowd-saml/config/listidp?operation=add&status=success");
            }
            if (PluginSettingsService.isMetadataFileUploaded.booleanValue()) {
                PluginSettingsService.isMetadataFileUploaded = Boolean.FALSE;
                if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getMetadataUploadStatus()) && StringUtils.equalsIgnoreCase((CharSequence)this.pluginSettingsService.getMetadataUploadStatus(), (CharSequence)"Success.")) {
                    log.debug("Metadata Uploaded Succesfully");
                    if (this.pluginSettingsService.getIdPList().size() > 1) {
                        response.sendRedirect(this.pluginSettingsService.getSpBaseUrl() + "/plugins/servlet/crowd-saml/config/listidp?operation=add&status=success");
                    }
                }
            }
        }
        catch (MoPluginException e) {
            log.error("mo Plugin exeption occurs.", (Throwable)e);
        }
        catch (Exception e) {
            log.error("An exeption occurs while saving the configuration", (Throwable)e);
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("idpID", this.idpID);
        context.put("successMessage", this.successMessage);
        context.put("errorMessage", this.errorMessage);
        context.put("pluginConfigService", this.pluginConfigService);
        context.put("pluginLicenseService", this.pluginLicenseService);
        context.put("acsUrl", this.pluginSettingsService.getLoginServletUrl() + "?idp=" + this.idpID);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("spBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        IDPConfig idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(this.idpID);
        if (idpConfig == null) {
            this.initializeNewForm(context);
            return context;
        }
        context.put("idpName", idpConfig.getIdpName());
        context.put("idpEntityId", idpConfig.getIdpEntityId());
        context.put("ssoUrl", idpConfig.getSsoUrl());
        context.put("sloUrl", idpConfig.getSloUrl());
        context.put("ssoBindingType", idpConfig.getSsoBindingType());
        context.put("sloBindingType", idpConfig.getSloBindingType());
        context.put("x509Certificate", idpConfig.getX509Certificate());
        context.put("certificates", idpConfig.getCertificates());
        context.put("signedRequest", idpConfig.getSignedRequest());
        context.put("inputUrl", idpConfig.getMetadataUrl());
        context.put("shouldContainsAddIdp", true);
        context.put("nameIdFormats", this.getNameIdFormats());
        context.put("nameIdFormat", idpConfig.getNameIdFormat());
        context.put("refreshMetadata", idpConfig.getRefreshMetadata());
        context.put("refreshInterval", idpConfig.getRefreshInterval());
        context.put("customerRefreshInterval", idpConfig.getCustomRefreshInterval());
        context.put("customRefreshInterval", idpConfig.getCustomRefreshIntervalUnit().toString());
        context.put("shouldShowBackButton", this.shouldShowBackButton);
        return context;
    }

    private void initializeNewForm(HashMap<String, Object> context) {
        context.put("idpID", this.idpID);
        context.put("idpName", "");
        context.put("idpEntityId", "");
        context.put("ssoUrl", "");
        context.put("sloUrl", "");
        context.put("ssoBindingType", "HttpRedirect");
        context.put("sloBindingType", "HttpRedirect");
        context.put("x509Certificate", "");
        context.put("signedRequest", Boolean.TRUE);
        context.put("inputUrl", "");
        context.put("shouldContainsAddIdp", false);
        context.put("nameIdFormats", this.getNameIdFormats());
        context.put("nameIdFormat", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        context.put("refreshMetadata", Boolean.FALSE);
        context.put("refreshInterval", "hourly");
        context.put("customRefreshInterval", 60);
        context.put("customRefreshIntervalUnit", "minutes");
    }

    public List<String> getIdpList() {
        ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
        this.idpList = idpList;
        return this.idpList;
    }

    public List<String> getNameIdFormats() {
        ArrayList<String> nameIDFormats = new ArrayList<String>();
        nameIDFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        nameIDFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        nameIDFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIDFormats.add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        return nameIDFormats;
    }
}

