/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.artifact;

import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.artifact.BasicSAMLArtifactMapEntryFactory;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.util.storage.StorageService;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSAMLArtifactMap
implements SAMLArtifactMap {
    public static final String DEFAULT_STORAGE_PARTITION = "artifact";
    private final Logger log = LoggerFactory.getLogger(BasicSAMLArtifactMap.class);
    private StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> artifactStore;
    private String partition;
    private long artifactLifetime;
    private SAMLArtifactMap.SAMLArtifactMapEntryFactory entryFactory;

    public BasicSAMLArtifactMap(ParserPool parser, StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this(storage, DEFAULT_STORAGE_PARTITION, lifetime);
    }

    public BasicSAMLArtifactMap(StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this(storage, DEFAULT_STORAGE_PARTITION, lifetime);
    }

    public BasicSAMLArtifactMap(StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, String storageParition, long lifetime) {
        this(new BasicSAMLArtifactMapEntryFactory(), storage, storageParition, lifetime);
    }

    public BasicSAMLArtifactMap(SAMLArtifactMap.SAMLArtifactMapEntryFactory factory, StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this(factory, storage, DEFAULT_STORAGE_PARTITION, lifetime);
    }

    public BasicSAMLArtifactMap(SAMLArtifactMap.SAMLArtifactMapEntryFactory factory, StorageService<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, String storageParition, long lifetime) {
        this.entryFactory = factory;
        this.artifactStore = storage;
        this.partition = !DatatypeHelper.isEmpty(storageParition) ? DatatypeHelper.safeTrim(storageParition) : DEFAULT_STORAGE_PARTITION;
        this.artifactLifetime = lifetime;
    }

    @Override
    public boolean contains(String artifact) {
        return this.artifactStore.contains(this.partition, artifact);
    }

    @Override
    public SAMLArtifactMap.SAMLArtifactMapEntry get(String artifact) {
        this.log.debug("Attempting to retrieve entry for artifact: {}", (Object)artifact);
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactStore.get(this.partition, artifact);
        if (entry == null) {
            this.log.debug("No entry found for artifact: {}", (Object)artifact);
            return null;
        }
        if (entry.isExpired()) {
            this.log.debug("Entry for artifact was expired: {}", (Object)artifact);
            this.remove(artifact);
            return null;
        }
        this.log.debug("Found valid entry for artifact: {}", (Object)artifact);
        return entry;
    }

    @Override
    public void put(String artifact, String relyingPartyId, String issuerId, SAMLObject samlMessage) throws MarshallingException {
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.entryFactory.newEntry(artifact, issuerId, relyingPartyId, samlMessage, this.artifactLifetime);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing new artifact entry '{}' for relying party '{}', expiring at '{}'", new Object[]{artifact, relyingPartyId, artifactEntry.getExpirationTime()});
        }
        this.artifactStore.put(this.partition, artifact, artifactEntry);
    }

    @Override
    public void remove(String artifact) {
        this.log.debug("Removing artifact entry: {}", (Object)artifact);
        this.artifactStore.remove(this.partition, artifact);
    }
}

