/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.model.Customer;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateOTPAndRegisterAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ValidateOTPAndRegisterAction.class);
    private final UserManager userManager;
    private final PluginLicenseService pluginLicenseService;
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginConfigService pluginConfigService;
    private final String CONFIG_FILE_PATH = "/templates/customer-validate-otp.ftl";
    public String successMessage = "";
    public String errorMessage = "";

    public ValidateOTPAndRegisterAction(UserManager userManager, PluginLicenseService pluginLicenseService, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginConfigService pluginConfigService) {
        this.userManager = userManager;
        this.pluginLicenseService = pluginLicenseService;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigService = pluginConfigService;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer OTP Verification Action: GET");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue()) {
                if (this.pluginLicenseService.isValidLicense()) {
                    log.info("Valid license found, redirecting user: {} to plugin configuration", (Object)userProfile.getUsername());
                    response.sendRedirect("/plugins/servlet/crowd-saml/config/sp-config");
                } else {
                    log.warn("Invalid license, redirecting user {} to license configuration", (Object)userProfile.getUsername());
                    response.sendRedirect("/plugins/servlet/crowd-saml/config/license-config");
                }
                return;
            }
            HttpSession session = request.getSession();
            String txId = session.getAttribute("SAML_TXID").toString();
            if (StringUtils.isEmpty((CharSequence)txId)) {
                log.warn("Invalid tx id found, redirecting to registration page");
                response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-register");
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/customer-validate-otp.ftl", this.initializeConfig(), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer OTP Verification Action: POST");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            HttpSession session = request.getSession();
            String txId = session.getAttribute("SAML_TXID").toString();
            if (StringUtils.isEmpty((CharSequence)txId)) {
                log.warn("No txId found, redirecting to customer registration page");
                response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-register");
                return;
            }
            String token = request.getParameter("otp");
            if (this.pluginLicenseService.validateOTPToken(txId, token).booleanValue()) {
                String email = (String)session.getAttribute("SAML_USERNAME");
                String password = (String)session.getAttribute("SAML_PASSWORD");
                String phone = (String)session.getAttribute("SAML_PHONE");
                String firstName = (String)session.getAttribute("SAML_FIRST_NAME");
                String lastName = (String)session.getAttribute("SAML_LAST_NAME");
                log.debug("Email {} password ****** phone {} firstName {} lastName {}", new Object[]{email, phone, firstName, lastName});
                Customer customer = this.pluginLicenseService.createCustomer(email, password, phone, firstName, lastName, "");
                this.pluginConfigService.saveCustomerDetails(customer);
                session.invalidate();
                log.debug("Customer registration successful. Redirecting to license verification page");
                response.sendRedirect("/plugins/servlet/crowd-saml/config/license-config");
            }
        }
        catch (PluginException pluginException) {
            String errorMessage = "Customer registration failed! Please check logs for more details.";
            this.handleError(response, errorMessage, pluginException);
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while processing the request.";
            this.handleError(response, errorMessage, e);
        }
    }

    private void handleError(HttpServletResponse response, String errorMessage, Exception e) throws IOException {
        log.error(errorMessage, (Throwable)e);
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/customer-validate-otp.ftl", this.initializeConfig(), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("successMessage", this.successMessage);
        config.put("errorMessage", this.errorMessage);
        config.put("pluginConfigService", this.pluginConfigService);
        config.put("pluginLicenseService", this.pluginLicenseService);
        return config;
    }
}

