/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMappingAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GroupMappingAction.class);
    private static final String GROUP_MAPPING_VM_PATH = "/templates/group-mapping.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final PluginLicenseService pluginLicenseService;
    private final LoginUriProvider loginUriProvider;
    private String[] onTheFlyDoNotRemoveGroups;
    private List<String> onTheFlyDoNotRemoveGroupsList;
    private String successMessage = "";
    private String errorMessage = "";
    private String defaultGroups;
    private String idpID;
    private String idpName;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Group Mapping : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.idpID)) {
                if (!this.pluginSettingsService.getIdpMap().isEmpty()) {
                    this.idpID = this.pluginSettingsService.getIdPList().get(0);
                } else {
                    this.idpID = UUID.randomUUID().toString();
                    if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                        this.idpName = "IDP";
                        this.pluginConfigService.replaceOldSettingsWithNew(this.idpID, this.idpName);
                    }
                }
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Group Mapping page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(GROUP_MAPPING_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Group Mapping : POST ");
        log.debug("GroupMapping doPost execute Submitted: " + request.getParameter("roleMappingSubmitted"));
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            this.idpID = request.getParameter("idpID");
            if (BooleanUtils.toBoolean((String)request.getParameter("roleMappingSubmitted"))) {
                HashMap<String, String> roleMapping = new HashMap<String, String>();
                List<Object> defaultGroupList = new ArrayList();
                this.defaultGroups = request.getParameter("defaultGroups");
                if (this.defaultGroups != null) {
                    log.debug("multiple default groups -" + this.defaultGroups);
                    this.defaultGroups = this.defaultGroups.replaceAll("\\s", "");
                    String[] defaultGrp = this.defaultGroups.split(",");
                    defaultGroupList = Arrays.asList(defaultGrp);
                    defaultGroupList.removeAll(Arrays.asList(null, ""));
                }
                int totalNumberOfRoles = Integer.parseInt(request.getParameter("totalNumberOfRoles"));
                for (int i = 0; i < totalNumberOfRoles; ++i) {
                    String key = StringUtils.trimToEmpty((String)request.getParameter("userGroupKey_" + i));
                    String value = StringUtils.trimToEmpty((String)request.getParameter("userGroupValue_" + i));
                    if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value) || StringUtils.equalsIgnoreCase((CharSequence)"select-group-to-map", (CharSequence)key) || BooleanUtils.toBoolean((Boolean)roleMapping.containsKey(key))) continue;
                    roleMapping.put(key.trim(), value.trim());
                }
                log.debug("IS ON THE FLY ENABLED:" + this.pluginSettingsService.getOnTheFlyGroupCreation());
                this.onTheFlyDoNotRemoveGroups = new String[]{request.getParameter("onTheFlyDoNotRemoveGroups")};
                if (this.onTheFlyDoNotRemoveGroups != null) {
                    log.debug("Excluded groups from on-the-fly group mapping-" + this.onTheFlyDoNotRemoveGroups.length);
                    this.onTheFlyDoNotRemoveGroupsList = Arrays.asList(StringUtils.split((String)this.onTheFlyDoNotRemoveGroups[0], (String)","));
                    this.onTheFlyDoNotRemoveGroupsList.removeAll(Arrays.asList(null, ""));
                }
                this.pluginConfigService.saveRoleMapping(this.idpID, request.getParameter("roleAttribute"), BooleanUtils.toBoolean((String)request.getParameter("createUsersIfRoleMapped")), BooleanUtils.toBoolean((String)request.getParameter("keepExistingUserRoles")), roleMapping, defaultGroupList, BooleanUtils.toBoolean((String)request.getParameter("restrictUserCreation")), BooleanUtils.toBoolean((String)request.getParameter("updateUserOnlyIfRoleMapped")), request.getParameter("defaultDirectory"), request.getParameter("enableDefaultGroupsFor"), Boolean.parseBoolean(request.getParameter("onTheFlyGroupCreation")), this.onTheFlyDoNotRemoveGroupsList, BooleanUtils.toBoolean((String)request.getParameter("createNewGroups")), BooleanUtils.toBoolean((String)request.getParameter("onTheFlyAssignNewGroupsOnly")), BooleanUtils.toBoolean((String)request.getParameter("applicationGroupEnrollment")), BooleanUtils.toBoolean((String)request.getParameter("groupRegexPatternEnabled")), request.getParameter("onTheFlyFilterIDPGroupsOption"), request.getParameter("onTheFlyFilterIDPGroupsKey"), request.getParameter("regexPatternForGroup"), request.getParameter("regexGroups"), request.getParameter("testRegex"));
            }
            if (BooleanUtils.toBoolean((String)request.getParameter("gmIdpChanged"))) {
                this.idpID = request.getParameter("idpID");
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Group Mapping page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(GROUP_MAPPING_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    private HashMap<String, Object> initializeImportExportConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        IDPConfig idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(this.idpID);
        context.put("idpMap", this.pluginSettingsService.getIdpMap());
        context.put("idpID", this.idpID);
        if (idpConfig != null) {
            context.put("createUsersIfRoleMapped", idpConfig.getCreateUsersIfRoleMapped());
            context.put("keepExistingUserRoles", idpConfig.getKeepExistingUserRoles());
            context.put("defaultGroupsList", idpConfig.getDefaultGroups());
            context.put("roleMapping", idpConfig.getRoleMapping());
            context.put("roleAttribute", StringUtils.defaultIfBlank((CharSequence)idpConfig.getRoleAttribute(), (CharSequence)""));
            context.put("defaultDirectory", idpConfig.getDefaultDirectory());
            context.put("existingDirectory", this.pluginSettingsService.getExistingDirectory());
            context.put("existingGroups", this.pluginSettingsService.getExistingGroups());
            context.put("restrictUserCreation", idpConfig.getRestrictUserCreation());
            context.put("updateUserOnlyIfRoleMapped", idpConfig.getUpdateUserOnlyIfRoleMapped());
            context.put("enableDefaultGroupsFor", idpConfig.getEnableDefaultGroupsFor());
            context.put("onTheFlyGroupCreation", idpConfig.getOnTheFlyGroupCreation() != false ? "true" : "false");
            context.put("onTheFlyDoNotRemoveGroupsList", idpConfig.getOnTheFlyDoNotRemoveGroups());
            context.put("groupFilterOptionsList", this.pluginSettingsService.getGroupFilterOptionsList());
            context.put("createNewGroups", idpConfig.getCreateNewGroups());
            context.put("onTheFlyAssignNewGroupsOnly", idpConfig.getOnTheFlyAssignNewGroupsOnly());
            context.put("applicationGroupEnrollment", idpConfig.getApplicationGroupEnrollment());
            context.put("groupRegexPatternEnabled", idpConfig.getGroupRegexPatternEnabled());
            context.put("onTheFlyFilterIDPGroupsOption", StringUtils.defaultIfBlank((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)""));
            context.put("onTheFlyFilterIDPGroupsKey", StringUtils.defaultIfBlank((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsKey(), (CharSequence)""));
            context.put("regexPatternForGroup", StringUtils.defaultIfBlank((CharSequence)idpConfig.getRegexPatternForGroup(), (CharSequence)""));
            context.put("testRegex", StringUtils.defaultIfBlank((CharSequence)idpConfig.getTestRegex(), (CharSequence)""));
            context.put("regexGroups", StringUtils.defaultIfBlank((CharSequence)idpConfig.getRegexGroups(), (CharSequence)""));
        } else {
            context.put("createUsersIfRoleMapped", this.pluginSettingsService.getCreateUsersIfRoleMapped());
            context.put("keepExistingUserRoles", this.pluginSettingsService.getKeepExistingUserRoles());
            context.put("defaultGroupsList", this.pluginSettingsService.getDefaultGroups());
            context.put("roleMapping", this.pluginSettingsService.getRoleMapping());
            context.put("roleAttribute", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getRoleAttribute(), (CharSequence)""));
            context.put("defaultDirectory", this.pluginSettingsService.getDefaultDirectory());
            context.put("existingDirectory", this.pluginSettingsService.getExistingDirectory());
            context.put("existingGroups", this.pluginSettingsService.getExistingGroups());
            context.put("restrictUserCreation", this.pluginSettingsService.getRestrictUserCreation());
            context.put("updateUserOnlyIfRoleMapped", this.pluginSettingsService.getUpdateUserOnlyIfRoleMapped());
            context.put("enableDefaultGroupsFor", this.pluginSettingsService.getEnableDefaultGroupsFor());
            context.put("onTheFlyGroupCreation", this.pluginSettingsService.getOnTheFlyGroupCreation() != false ? "true" : "false");
            context.put("onTheFlyDoNotRemoveGroupsList", this.pluginSettingsService.getOnTheFlyDoNotRemoveGroups());
            context.put("groupFilterOptionsList", this.pluginSettingsService.getGroupFilterOptionsList());
            context.put("createNewGroups", this.pluginSettingsService.getCreateNewGroups());
            context.put("onTheFlyAssignNewGroupsOnly", this.pluginSettingsService.getOnTheFlyAssignNewGroupsOnly());
            context.put("applicationGroupEnrollment", this.pluginSettingsService.getApplicationGroupEnrollment());
            context.put("groupRegexPatternEnabled", this.pluginSettingsService.getGroupRegexPatternEnabled());
            context.put("onTheFlyFilterIDPGroupsOption", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)""));
            context.put("onTheFlyFilterIDPGroupsKey", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getOnTheFlyFilterIDPGroupsKey(), (CharSequence)""));
            context.put("regexPatternForGroup", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getRegexPatternForGroup(), (CharSequence)""));
            context.put("testRegex", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getTestRegex(), (CharSequence)""));
            context.put("regexGroups", StringUtils.defaultIfBlank((CharSequence)this.pluginSettingsService.getRegexGroups(), (CharSequence)""));
        }
        return context;
    }

    @Generated
    public GroupMappingAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, PluginLicenseService pluginLicenseService, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.pluginLicenseService = pluginLicenseService;
        this.loginUriProvider = loginUriProvider;
    }
}

