/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.service.PluginSettingsService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnableSSOAPI
extends HttpServlet {
    private final PluginSettingsService pluginSettingsService;
    private static Logger log = LoggerFactory.getLogger(EnableSSOAPI.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("EnableSSOAPI servlet called from doGet");
        this.showErrorMessage(response, "GET method is not allowed", "The method received in the request-line is known by the origin server but not supported by the target resource. Use POST instead of GET");
        JSONObject responseJson = new JSONObject();
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("EnableSSOAPI servlet called from doPost");
        String action = request.getParameter("action");
        if (StringUtils.isBlank((CharSequence)action)) {
            this.showErrorMessage(response, "No Parameter Sent", "Request does not contain any parameter");
            return;
        }
        switch (action) {
            case "disable": {
                this.disableSSO(request, response);
                break;
            }
            case "enable": {
                this.enableSSO(request, response);
                break;
            }
            default: {
                this.showErrorMessage(response, "Invalid Parameter", "Request contains invalid parameter");
            }
        }
    }

    private void disableSSO(HttpServletRequest request, HttpServletResponse response) {
        log.info("Disabling SSO for Crowd");
        this.pluginSettingsService.setEnableSAMLSSO(false);
        this.showSuccessMessage(response, "SSO Disabled Successfully", "SAML App Configured successfully.");
    }

    private void enableSSO(HttpServletRequest request, HttpServletResponse response) {
        log.info("Enabling SSO for Crowd");
        this.pluginSettingsService.setEnableSAMLSSO(true);
        this.showSuccessMessage(response, "SSO Enabled Successfully", "SAML App Configured successfully.");
    }

    private void showErrorMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "ERROR");
            json.put("Message", message);
            json.put("Description", description);
            response.setStatus(401);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("An error occurred. ", (Throwable)e);
        }
    }

    private void showSuccessMessage(HttpServletResponse response, String message, String description) {
        JSONObject json = new JSONObject();
        try {
            json.put("Status", "SUCCESS");
            json.put("Message", message);
            json.put("Description", description);
            response.setContentType("application/json");
            response.getOutputStream().write(json.toString().getBytes());
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("An error occurred. ", (Throwable)e);
        }
    }

    @Generated
    public EnableSSOAPI(PluginSettingsService pluginSettingsService) {
        this.pluginSettingsService = pluginSettingsService;
    }
}

