/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.PluginUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class SAMLLoginFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SAMLLoginFilter.class);
    private final UserManager userManager;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;
    private final PluginLicenseService pluginLicenseService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        log.debug("new logs just to check ");
        log.debug("SAML Login filter, intercepting authenticated request");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String url = request.getRequestURL().toString();
        if (this.userManager.getRemoteUser() != null) {
            log.debug("User is already logged in");
            chain.doFilter(req, res);
            return;
        }
        if (!this.pluginLicenseService.isCustomerRegistered().booleanValue() || this.pluginLicenseService.isLicenseExpired().booleanValue()) {
            log.debug("User is not registered or plugin license is expired ");
            chain.doFilter(req, res);
            return;
        }
        this.checkConfigurationAndRedirect(req, res, chain);
    }

    private void checkConfigurationAndRedirect(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String returnTo = request.getHeader("next");
        if ((!this.pluginSettingsService.getIdpMap().isEmpty() || StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) && this.pluginSettingsService.getEnableSAMLSSO().booleanValue()) {
            log.debug("SAML Plugin has a valid licensed and configured. Checking configuration for SSO ");
            Boolean defaultLoginDisabled = this.pluginSettingsService.getDefaultLoginDisabled();
            Boolean backdoorEnabled = this.pluginSettingsService.getBackdoorEnabled();
            Boolean restrictBackdoor = this.pluginSettingsService.getRestrictBackdoor();
            if (!(!defaultLoginDisabled.booleanValue() || backdoorEnabled.booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("saml_sso"), (CharSequence)"false") || StringUtils.containsIgnoreCase((CharSequence)request.getRequestURI(), (CharSequence)"/saml/auth"))) {
                if (!this.pluginSettingsService.getIdpMap().isEmpty() && this.pluginSettingsService.getIdpMap().size() <= 1) {
                    log.debug("Redirecting to SAML IdP for Authentication...");
                    StringBuffer buffer = new StringBuffer(this.pluginSettingsService.getLoginServletUrl());
                    String redirectTo = "";
                    if (request.getParameter("next") != null) {
                        redirectTo = request.getParameter("next");
                    }
                    log.debug("redirect to  " + redirectTo);
                    if (StringUtils.isNotBlank((CharSequence)redirectTo)) {
                        buffer.append("?return_to=").append(URLEncoder.encode(redirectTo, "UTF-8"));
                    }
                    log.debug("SAML Filter Redirecting user to {}", (Object)buffer);
                    String htmlStart = "<html><head><script>window.location.href=\"" + buffer + "\"</script></head><body>Please wait while we are redirecting you to IDP for authentication...</body></html>";
                    response.setContentType("text/html");
                    response.getOutputStream().write(htmlStart.getBytes(StandardCharsets.UTF_8));
                } else if (this.pluginSettingsService.getIdpMap().size() > 1) {
                    String renderIDPButtonsOnly = PluginUtils.getIDPButtonsTemplate(returnTo, this.pluginSettingsService.getSpBaseUrl(), this.pluginSettingsService.getIdpMap());
                    response.setContentType("text/html");
                    response.getOutputStream().write(renderIDPButtonsOnly.getBytes(StandardCharsets.UTF_8));
                }
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("show_login_form"), (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("error"), (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("saml_sso"), (CharSequence)"false") && !restrictBackdoor.booleanValue()) {
                log.debug("SAML Filter: Show default logging form");
                chain.doFilter(req, res);
            } else if (backdoorEnabled.booleanValue() && restrictBackdoor.booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("saml_sso"), (CharSequence)"false")) {
                if (this.pluginSettingsService.getUserPresent().booleanValue()) {
                    this.pluginSettingsService.setUserPresent(false);
                    chain.doFilter(req, res);
                } else {
                    response.setCharacterEncoding("iso-8859-1");
                    response.setContentType("text/html");
                    response.getOutputStream().write(PluginUtils.getBackdoorForm().getBytes(StandardCharsets.UTF_8));
                }
            } else {
                response.setCharacterEncoding("iso-8859-1");
                response.setContentType("text/html");
                response.getOutputStream().write(this.pluginSettingsService.getLoginTemplate().getBytes(StandardCharsets.UTF_8));
            }
        } else {
            log.debug("SAML Filter. Plugin is not configured");
            chain.doFilter(req, res);
        }
    }

    public void destroy() {
    }

    @Generated
    public SAMLLoginFilter(UserManager userManager, PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService, PluginLicenseService pluginLicenseService) {
        this.userManager = userManager;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
        this.pluginLicenseService = pluginLicenseService;
    }
}

