/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.exception;

import lombok.Generated;

public class SAMLException
extends RuntimeException {
    private final SAMLErrorCode errorCode;
    private String message;
    private String resolution;

    public SAMLException(String message, String resolution, SAMLErrorCode errorCode) {
        this.errorCode = errorCode;
        this.message = message;
        this.resolution = resolution;
    }

    public SAMLException(String message, SAMLErrorCode errorCode) {
        this.message = message;
        this.errorCode = errorCode;
    }

    public SAMLException(Throwable cause, SAMLErrorCode errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    public SAMLException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, SAMLErrorCode errorCode, String message1, String resolution) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.errorCode = errorCode;
        this.message = message1;
        this.resolution = resolution;
    }

    public SAMLException(SAMLErrorCode samlErrorCode) {
        this.errorCode = samlErrorCode;
    }

    @Generated
    public SAMLErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getResolution() {
        return this.resolution;
    }

    public static enum SAMLErrorCode {
        INVALID_IDP_ID("Invalid IDP ID", "Please check the configuration or contact Administrator for more details"),
        INVALID_ISSUER("Invalid Issuer in the SAML Response.", "Please verify IDP Entity ID value is correct."),
        INVALID_SIGNATURE("Invalid Signature in the SAML Response. The certificate you provided did not match the signature in SAML Response.", "Please verify the IDP Signing certificate is correct."),
        INVALID_DESTINATION("Invalid Destination in the SAML Response.", "Make sure that Destination value is configured correctly on your IDP."),
        INVALID_RECIPIENT("Invalid Recipient in the SAML Response.", "Make sure that Recipient value is configured correctly on your IDP."),
        INVALID_AUDIENCE("Invalid Audience in the SAML Response.", "Make sure that Audience value is configured correctly on your IDP."),
        INVALID_CERTIFICATE("Invalid Certificate provided for validation. Incorrect certificate format.", "Please provide the X.509 Certificate in the correct format."),
        RESPONSE_NOT_SIGNED("SAML Response not signed by your IdP.", "Make sure your IDP is signing at least SAML Response or SAML Assertion."),
        ASSERTION_NOT_SIGNED("SAML Assertion not signed by your IdP.", "Make sure your IDP is signing at least SAML Response or SAML Assertion."),
        INVALID_CONDITIONS("Invalid Conditions in the SAML Response.", "Make sure your Server time is in sync with your IDP Server."),
        INCORRECT_PROFILE_MAPPING("Incorrect profile mapping fields.", "Check user profile mapping."),
        UNKNOWN("An unknown error occurred.", "Please check logs for the exact error and contact support for help."),
        MULTIPLE_USER_WITH_EMAIL("Unable to identify SSO user, multiple user found with received email", "Please ensure all the users in Crowd have a unique email address"),
        USERNAME_REGEX_VALIDATION_FAILED("Invalid regular expression for username", "Please check logs for the exact error and contact support for help."),
        INVALID_SAML_STATUS("Invalid SAML Status code.", "The request could not be performed due to an error on the part of the SAML responder or SAML authority. Make sure IdP returns SUCCESS status code in SAML Response. Please unchecked the Send Signed Requests and try again"),
        INCORRECT_IDP_CONFIGURATION("Invalid IDP configurations.", "Please check the configuration or contact Administrator for more details"),
        RESPONDER("Invalid SAML Status code.", "The request could not be performed due to an error on the part of the SAML responder or SAML authority. Make sure IdP returns SUCCESS status code in SAML Response. Please unchecked the Send Signed Requests in Configure IDP Tab and try again.");

        private final String message;
        private final String resolution;

        private SAMLErrorCode(String message, String resolution) {
            this.message = message;
            this.resolution = resolution;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getResolution() {
            return this.resolution;
        }
    }
}

