/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobConfig;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.scheduler.UpdateLicenseService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLicenseTask
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(UpdateLicenseTask.class);
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigHandler pluginConfigHandler;
    private final PluginSettingsService pluginSettingsService;

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            log.debug("Executing update License Task");
            JobConfig jobConfig = jobRunnerRequest.getJobConfig();
            UpdateLicenseService service = (UpdateLicenseService)jobConfig.getParameters().get(UpdateLicenseService.KEY);
            if (service != null) {
                Boolean verified = this.pluginConfigHandler.verifyLicense(this.pluginSettingsService, this.pluginSettingsService.getCustomerLicenseKey());
                if (!verified.booleanValue()) {
                    log.error("License Verification Failed!!");
                    this.pluginConfigHandler.deactivateAndRemoveCustomerAccount();
                    service.unschedule();
                }
                if (!this.pluginLicenseService.checkLicenseCondition().booleanValue()) {
                    log.error("License condition failed-No. of user exceeded");
                    service.unschedule();
                }
                log.debug("Completed update License Task");
            }
        }
        catch (Exception e) {
            log.error("An error occurred while executing update license task" + e);
        }
        return null;
    }

    @Generated
    public UpdateLicenseTask(PluginLicenseService pluginLicenseService, PluginConfigHandler pluginConfigHandler, PluginSettingsService pluginSettingsService) {
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.pluginSettingsService = pluginSettingsService;
    }
}

