/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLSpConfigAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLSpConfigAction.class);
    private static final String CONFIG_FILE_PATH = "/templates/configure.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigService pluginConfigService;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    public String secretCode = "";
    public String successMessage = "";
    public String errorMessage = "";

    public SAMLSpConfigAction(TemplateRenderer templateRenderer, PluginLicenseService pluginLicenseService, PluginConfigService pluginConfigService, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, ApplicationServices applicationServices, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigService = pluginConfigService;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. IDP Configurations: GET");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the SP Configuration";
            log.error("Failed to render the SP Configuration page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            if (BooleanUtils.toBoolean((String)request.getParameter("addIdpSubmitted"))) {
                log.debug("Saving sp configuration.");
                this.pluginConfigService.saveSPConfiguration(request.getParameter("spBaseUrl"), request.getParameter("spEntityId"));
            } else if (BooleanUtils.toBoolean((String)request.getParameter("certificatesSubmitted"))) {
                log.debug("Saving sp metadata configuration.");
                this.pluginConfigService.saveSPCertificates(BooleanUtils.toBoolean((String)request.getParameter("signing")), BooleanUtils.toBoolean((String)request.getParameter("encryption")));
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the SP Configuration";
            log.error("Failed to render the SP configuration page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(CONFIG_FILE_PATH, this.initializeConfig(request, response), (Writer)response.getWriter());
    }

    public HashMap<String, Object> initializeConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("successMessage", this.successMessage);
        context.put("errorMessage", this.errorMessage);
        context.put("pluginConfigService", this.pluginSettingsService);
        context.put("pluginLicenseService", this.pluginLicenseService);
        context.put("spBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("spEntityId", this.pluginSettingsService.getSpEntityId());
        context.put("signing", this.pluginSettingsService.getSigning());
        context.put("encryption", this.pluginSettingsService.getEncryption());
        context.put("loginServletUrl", this.pluginSettingsService.getLoginServletUrl());
        context.put("logoutServletUrl", this.pluginSettingsService.getLogoutServletUrl());
        context.put("certificateInfo", this.pluginSettingsService.getCertificateInfo());
        context.put("getIdpGuides", this.pluginSettingsService.getIdpGuides());
        context.put("isJCEInstalled", this.pluginSettingsService);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        return context;
    }
}

