/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomerRegisterAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CustomerRegisterAction.class);
    private final UserManager userManager;
    private final PluginLicenseService pluginLicenseService;
    private final TemplateRenderer templateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PluginConfigService pluginConfigService;
    private final String CONFIG_FILE_PATH = "/templates/customer-register.ftl";
    public String successMessage = "";
    public String errorMessage = "";

    public CustomerRegisterAction(UserManager userManager, PluginLicenseService pluginLicenseService, TemplateRenderer templateRenderer, LoginUriProvider loginUriProvider, PluginConfigService pluginConfigService) {
        this.userManager = userManager;
        this.pluginLicenseService = pluginLicenseService;
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfigService = pluginConfigService;
    }

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Registration Action: GET");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (this.pluginLicenseService.isCustomerRegistered().booleanValue()) {
                if (this.pluginLicenseService.isValidLicense()) {
                    log.info("Valid license found, redirecting user: {} to plugin configuration", (Object)userProfile.getUsername());
                    response.sendRedirect("/plugins/servlet/crowd-saml/config/sp-config");
                } else {
                    log.warn("Invalid license, redirecting user {} to license configuration", (Object)userProfile.getUsername());
                    response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-login");
                }
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/customer-register.ftl", this.pluginConfigService.initializeConfig(this.successMessage, this.errorMessage, this.pluginLicenseService.isTrialLicense()), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SSO Configuration. Customer Registration Action: POST");
        UserProfile userProfile = this.userManager.getRemoteUser();
        try {
            if (userProfile == null || !this.userManager.isSystemAdmin(userProfile.getUserKey())) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            String email = request.getParameter("email");
            String password = request.getParameter("password");
            String confirmPassword = request.getParameter("confirmPassword");
            String firstName = request.getParameter("firstName");
            String lastName = request.getParameter("lastName");
            String phone = request.getParameter("phone");
            if (this.pluginLicenseService.checkIfCustomerExists(email).booleanValue()) {
                log.debug("Customer account already exists in miniOrange, redirecting to customer login page");
                response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-login");
            } else {
                log.debug("Customer not registered, creating account in miniOrange");
                String txId = this.pluginLicenseService.sendOTPToken(email);
                log.debug("TxID: {}, Email: {}", (Object)txId, (Object)email);
                HttpSession session = request.getSession();
                session.setAttribute("SAML_USERNAME", (Object)email);
                session.setAttribute("SAML_PASSWORD", (Object)password);
                session.setAttribute("SAML_PHONE", (Object)phone);
                session.setAttribute("SAML_FIRST_NAME", (Object)firstName);
                session.setAttribute("SAML_LAST_NAME", (Object)lastName);
                session.setAttribute("SAML_TXID", (Object)txId);
                log.debug("Redirecting user to OTP verification page");
                response.sendRedirect("/plugins/servlet/crowd-saml/config/customer-verify");
            }
        }
        catch (PluginException pluginException) {
            String errorMessage = "Customer registration failed! Please check logs for more details.";
            this.handleError(response, errorMessage, pluginException);
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while processing the request.";
            this.handleError(response, errorMessage, e);
        }
    }

    private void handleError(HttpServletResponse response, String errorMessage, Exception e) throws IOException {
        log.error(errorMessage, (Throwable)e);
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("/templates/customer-register.ftl", this.pluginConfigService.initializeConfig(this.successMessage, errorMessage, this.pluginLicenseService.isTrialLicense()), (Writer)response.getWriter());
    }

    @Generated
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Generated
    public PluginLicenseService getPluginLicenseService() {
        return this.pluginLicenseService;
    }

    @Generated
    public TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    @Generated
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @Generated
    public PluginConfigService getPluginConfigService() {
        return this.pluginConfigService;
    }

    @Generated
    public String getCONFIG_FILE_PATH() {
        return this.CONFIG_FILE_PATH;
    }

    @Generated
    public String getSuccessMessage() {
        return this.successMessage;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

