/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.event.user.UserAuthenticatedEvent;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.component.ComponentLocator;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.model.SAMLResponse;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.EncryptionUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(SAMLAuthenticationService.class);
    private final PluginSettingsService pluginSettingsService;
    private final ApplicationManager applicationManager;
    private final PropertyManager propertyManager;
    private final ApplicationService applicationService;
    private final DirectoryManager directoryManager;
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private long directoryId;

    public void createUserSessionAndRedirect(String username, HttpServletRequest request, HttpServletResponse response, SAMLResponse samlResponse, Boolean applicationGroupEnrollment) throws IOException {
        block13: {
            log.debug("MoCrowdSessionManager: MoCrowdSessionManager called");
            try {
                CookieConfiguration cookieConfiguration = this.propertyManager.getCookieConfiguration();
                String ssoDomain = StringUtils.isNotBlank((CharSequence)cookieConfiguration.getDomain()) ? cookieConfiguration.getDomain() : "";
                String crowdSSOCookieName = this.getSSOCookieName(cookieConfiguration);
                String relayState = samlResponse.getRelayStateURL();
                if (!relayState.startsWith("http") && !relayState.startsWith("/")) {
                    relayState = "/" + relayState;
                }
                if (!relayState.startsWith("http")) {
                    relayState = this.pluginSettingsService.getSpBaseUrl().concat(relayState);
                }
                URL url = new URL(relayState);
                String domain = url.getProtocol() + "://" + url.getAuthority();
                log.debug("Application Domain Name=" + domain);
                Application app = this.getUserApplicationFromRelayState(username, domain);
                String crowdToken = this.getCrowdSessiontoken(username, request, app);
                Boolean setSecureCookie = cookieConfiguration.isSecure();
                log.debug("crowdToken = " + crowdToken);
                if (crowdToken != null) {
                    log.debug("setting crowd token in request and cookies = " + crowdToken);
                    request.setAttribute(crowdSSOCookieName, (Object)crowdToken);
                    Cookie ssoCookie = new Cookie(crowdSSOCookieName, crowdToken);
                    ssoCookie.setPath("/");
                    if (setSecureCookie.booleanValue()) {
                        ssoCookie.setSecure(Boolean.TRUE.booleanValue());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)ssoDomain)) {
                        log.debug("Setting up crowd token in SSO Domain = " + ssoDomain);
                        ssoCookie.setDomain(ssoDomain);
                    } else {
                        log.debug("SSO Domain is not configured");
                    }
                    response.addCookie(ssoCookie);
                    String twoFAEncryptedKey = EncryptionUtils.encryptString(username, crowdToken + ":" + this.pluginSettingsService.getSecretKey());
                    if (twoFAEncryptedKey != null) {
                        Cookie twoFACookie = new Cookie("crowd.saml.2fa_token", twoFAEncryptedKey);
                        twoFACookie.setPath("/");
                        if (setSecureCookie.booleanValue()) {
                            twoFACookie.setSecure(Boolean.TRUE.booleanValue());
                        }
                        if (StringUtils.isNotEmpty((CharSequence)ssoDomain)) {
                            log.debug("Setting 2FA token in SSO Domain = " + ssoDomain);
                            twoFACookie.setDomain(ssoDomain);
                        }
                        response.addCookie(twoFACookie);
                    }
                    if (applicationGroupEnrollment.booleanValue()) {
                        this.fireApplicationBasedGroupEnrollment(username, app);
                    }
                    break block13;
                }
                MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.UNKNOWN;
                MoSAMLException samlException = new MoSAMLException(errorCode.getMessage(), null, errorCode);
                log.error("An exception occurs while creating the user session");
                throw samlException;
            }
            catch (MoSAMLException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable e) {
                log.error("An error occurred while creating the user session.", e);
                throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
            }
        }
    }

    public CookieConfiguration getCookieConfiguration() {
        return this.propertyManager.getCookieConfiguration();
    }

    private String getCrowdSessionToken(String username, Application application, HttpServletRequest request, HttpServletResponse response) {
        log.debug("Getting Crowd SESSION Token");
        try {
            Token crowdToken = null;
            UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
            userAuthContext.setApplication(application.getName());
            userAuthContext.setName(username);
            userAuthContext.setCredential(new PasswordCredential("", false));
            if (request.getHeader("X-Forwarded-For") == null) {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
                userAuthContext.setValidationFactors(factors);
            } else {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr()), new ValidationFactor("X-Forwarded-For", request.getHeader("X-Forwarded-For"))};
                userAuthContext.setValidationFactors(factors);
            }
            log.debug("User Authentication context: " + userAuthContext.toString());
            crowdToken = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(application, userAuthContext);
            long directoryId = crowdToken.getDirectoryId();
            log.debug("Crowd User Token : " + crowdToken.toString());
            return crowdToken.getRandomHash();
        }
        catch (Exception e) {
            log.debug("An exception occurs while getting session token for the user : " + username);
            log.error("An error occurs while getting session token", (Throwable)e);
            return null;
        }
    }

    public String getCrowdSSOCookieName(CookieConfiguration cookieConfiguration) {
        String ssoCookieName;
        String string = ssoCookieName = cookieConfiguration != null ? cookieConfiguration.getName() : "";
        if (StringUtils.isEmpty((CharSequence)ssoCookieName)) {
            log.debug("Crowd cookies are not configured. Using the default one.");
            ssoCookieName = "crowd.token_key";
        }
        log.debug("Crowd SSO cookie name: {}", (Object)ssoCookieName);
        return ssoCookieName;
    }

    public Application getUserApplicationFromRelayState(String username, String domain) throws ApplicationNotFoundException {
        try {
            List appList = this.applicationManager.findAll();
            for (Application application : appList) {
                String applicationUrl = (String)application.getAttributes().get("applicationURL");
                log.debug("Application URL = {}", (Object)applicationUrl);
                log.debug("All remote app addresses = {}", (Object)application.getRemoteAddresses());
                if (this.isDomainMatching(applicationUrl, domain, application) && this.applicationService.isUserAuthorised(application, username)) {
                    log.debug("User '{}' is allowed to authenticate for application '{}': {}", new Object[]{username, application.getName(), true});
                    return application;
                }
                log.error("User '{}' is not allowed to authenticate for application {}. Trying to authenticate from Crowd Application", (Object)username, (Object)application.getName());
            }
        }
        catch (Exception e) {
            log.error("Error occurred while fetching the application for domain '{}", (Object)domain, (Object)e);
        }
        return this.applicationManager.findByName("crowd");
    }

    public void fireApplicationBasedGroupEnrollment(String username, Application app) {
        try {
            log.debug("Application Domain Name=" + app);
            EventPublisher eventPublisher = (EventPublisher)ComponentLocator.getComponent(EventPublisher.class);
            Directory userDirectory = this.directoryManager.findDirectoryById(this.directoryId);
            User user = this.directoryManager.findUserByName(this.directoryId, username);
            if (app != null) {
                eventPublisher.publish((Object)new UserAuthenticatedEvent(ApplicationService.class, userDirectory, app, user));
            }
        }
        catch (Exception e) {
            log.error("An error occurred while publishing user authenticated event:", (Throwable)e);
        }
    }

    private boolean isDomainMatching(String applicationUrl, String domain, Application app) {
        return applicationUrl != null && (domain.contains(applicationUrl) || applicationUrl.contains(domain) || app.getRemoteAddresses().toString().contains(domain));
    }

    private String prepareRelayState(String relayStateUrl) {
        if (!relayStateUrl.startsWith("http") && !relayStateUrl.startsWith("/")) {
            relayStateUrl = "/" + relayStateUrl;
        }
        return relayStateUrl.startsWith("http") ? relayStateUrl : this.pluginSettingsService.getSpBaseUrl().concat(relayStateUrl);
    }

    private String getDomainFromRelayState(String relayState) throws MalformedURLException {
        URL url = new URL(relayState);
        return url.getProtocol() + "://" + url.getAuthority();
    }

    private ValidationFactor[] createValidationFactors(String username, HttpServletRequest request) {
        long randomNumber = this.createSecretValidationNumber();
        String remoteAddress = request.getRemoteAddr();
        String remoteHost = request.getRemoteHost();
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        return new ValidationFactor[]{new ValidationFactor("remote_address", remoteAddress), new ValidationFactor("Random-Number", String.valueOf(randomNumber)), new ValidationFactor("NAME", username), new ValidationFactor("remote_host", remoteHost), new ValidationFactor("X-Forwarded-For", xForwardedFor != null ? xForwardedFor : remoteAddress)};
    }

    private JSONObject createAuthRequestBody(String username, ValidationFactor[] factors) {
        JSONObject authRequestBody = new JSONObject();
        authRequestBody.put("username", (Object)username);
        authRequestBody.put("password", (Object)"");
        JSONObject validationFactorsObject = new JSONObject();
        JSONArray validationFactorsArray = new JSONArray();
        for (ValidationFactor vf : factors) {
            JSONObject validationFactor = new JSONObject();
            validationFactor.put(vf.getName(), (Object)vf.getValue());
            validationFactorsArray.put((Object)validationFactor);
        }
        validationFactorsObject.put("validationFactors", (Object)validationFactorsArray);
        authRequestBody.put("validation-factors", (Object)validationFactorsObject);
        return authRequestBody;
    }

    private HashMap<String, String> buildAuthorizationHeader() {
        String applicationName = this.pluginSettingsService.getCrowdAuthAppName();
        String applicationPassword = EncryptionUtils.decrypt(this.pluginSettingsService.getCustomerTokenKey(), this.pluginSettingsService.getCrowdAuthAppPassword());
        String auth = applicationName + ":" + applicationPassword;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Basic " + encodedAuth);
        return headers;
    }

    protected long createSecretValidationNumber() {
        long randomLong = RandomUtils.nextLong();
        return randomLong <= 0L ? -randomLong : randomLong;
    }

    public String getSSOCookieName(CookieConfiguration cookieConfiguration) {
        String ssoCookieName = "";
        ssoCookieName = cookieConfiguration.getName();
        if (StringUtils.isEmpty((CharSequence)ssoCookieName)) {
            log.debug("Crowd cookies is not configured. using default one.");
            ssoCookieName = "crowd.token_key";
        }
        log.debug("Crowd SSO cookie name : " + ssoCookieName);
        return ssoCookieName;
    }

    public String getCrowdSessiontoken(String username, HttpServletRequest request, Application application) throws URISyntaxException {
        log.debug("Getting Crowd SESSION Token");
        try {
            Token crowdToken = null;
            UserAuthenticationContext userAuthContext = new UserAuthenticationContext();
            userAuthContext.setApplication(application.getName());
            userAuthContext.setName(username);
            userAuthContext.setCredential(new PasswordCredential("", false));
            if (request.getHeader("X-Forwarded-For") == null) {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr())};
                userAuthContext.setValidationFactors(factors);
            } else {
                ValidationFactor[] factors = new ValidationFactor[]{new ValidationFactor("remote_address", request.getRemoteAddr()), new ValidationFactor("X-Forwarded-For", request.getHeader("X-Forwarded-For"))};
                userAuthContext.setValidationFactors(factors);
            }
            log.debug("User Authentication context: " + userAuthContext.toString());
            crowdToken = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(application, userAuthContext);
            this.directoryId = crowdToken.getDirectoryId();
            log.debug("Crowd User Token : " + crowdToken.toString());
            return crowdToken.getRandomHash();
        }
        catch (Exception e) {
            log.debug("An exception occurs while getting session token for the user : " + username);
            log.error("An error occurs while getting session token", (Throwable)e);
            return null;
        }
    }

    @Generated
    public SAMLAuthenticationService(PluginSettingsService pluginSettingsService, ApplicationManager applicationManager, PropertyManager propertyManager, ApplicationService applicationService, DirectoryManager directoryManager, TokenAuthenticationManager tokenAuthenticationManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.applicationManager = applicationManager;
        this.propertyManager = propertyManager;
        this.applicationService = applicationService;
        this.directoryManager = directoryManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }
}

