/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.sso.saml.scheduler.UpdateLicenseTask;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import java.util.Calendar;
import java.util.Date;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLicenseService
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(UpdateLicenseService.class);
    public static final String KEY = UpdateLicenseTask.class.getName() + ":instance";
    public static final String SETTINGS_KEY = UpdateLicenseTask.class.getName() + ":settings";
    public static final String PLUGIN_HANDLER_KEY = UpdateLicenseTask.class.getName() + ":pluginHandler";
    private static final String JOB_NAME = UpdateLicenseTask.class.getName() + ":job";
    private static final JobId JOB_ID = JobId.of((String)UpdateLicenseTask.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UpdateLicenseTask.class.getName());
    private final SchedulerService schedulerService;
    private final PluginLicenseService pluginLicenseService;
    private final PluginSettingsService pluginSettingsService;
    private int resetIntervalInHours = 168;

    public void onStart() {
        log.debug("License Scheduler on start called");
        try {
            if (!this.pluginSettingsService.getLicenseVerified().booleanValue() || this.pluginSettingsService.getLicenseVerified().booleanValue() && this.pluginLicenseService.isTrialLicense() && this.pluginLicenseService.isLicenseExpired().booleanValue()) {
                this.unschedule();
            } else {
                this.schedule();
            }
        }
        catch (Exception e) {
            log.error("An error occurred while Starting the scheduler service");
        }
    }

    public void onStop() {
        log.info("Scheduler onStop Called");
        try {
            this.unschedule();
        }
        catch (Exception e) {
            log.error("An error occurred while unscheduling : " + e.getMessage());
        }
    }

    public void schedule() {
        try {
            log.debug("Scheduling License service");
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(12, 1);
            long resetIntervalInMiliseconds = Integer.toUnsignedLong(this.resetIntervalInHours * 60 * 60 * 1000);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)resetIntervalInMiliseconds, (Date)cal.getTime()));
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Error scheduling Crowd SAML Licensing  Scheduler: {}", (Throwable)e);
        }
    }

    public void unschedule() {
        log.debug("Unscheduling License service");
        try {
            JobId jobId = JobId.of((String)JOB_NAME);
            this.schedulerService.unscheduleJob(jobId);
        }
        catch (IllegalArgumentException t) {
            log.error("No JOB exist. Can't unschedule.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Generated
    public UpdateLicenseService(SchedulerService schedulerService, PluginLicenseService pluginLicenseService, PluginSettingsService pluginSettingsService) {
        this.schedulerService = schedulerService;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginSettingsService = pluginSettingsService;
    }
}

