/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.model.Customer;
import com.miniorange.sso.saml.model.MoAPIRequest;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import com.miniorange.sso.saml.utils.PluginUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLicenseService {
    private static final Logger log = LoggerFactory.getLogger(PluginLicenseService.class);
    private final PluginSettingsService pluginSettingsService;

    public Boolean validateOTPToken(String txId, String token) {
        try {
            MoAPIRequest request = new MoAPIRequest(null, null, "EMAIL", txId, token);
            String json = request.getJSON();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/auth/validate", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                return StringUtils.equalsIgnoreCase((CharSequence)statusNode, (CharSequence)"success");
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            log.error("An error occurred while validating OTP", (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public String sendOTPToken(String email) {
        try {
            log.debug("Sending OTP to user : {}", (Object)email);
            MoAPIRequest request = new MoAPIRequest("16555", email, "EMAIL", null, null);
            String json = request.getJSON();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/auth/challenge", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            log.debug("OTP Response : {}", (Object)response);
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (statusNode != null && StringUtils.equalsIgnoreCase((CharSequence)statusNode, (CharSequence)"success")) {
                    String txId = jsonObj.getString("txId");
                    log.debug("OTP sent successfully. TxID : {}", (Object)txId);
                    return txId;
                }
                log.debug("OTP sent status : failed ");
                throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Status not Success", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            log.error("An error occurred while sending OTP token", (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Customer createCustomer(String email, String password, String phone, String fname, String lname, String companyName) {
        log.debug("Creating Customer : {}", (Object)email);
        try {
            Customer customer = new Customer(email, password, phone, fname, lname);
            customer.setCompanyName(companyName);
            customer.setAreaOfInterest("Crowd - SAML Single Sign On Plugin");
            String json = customer.getJSON();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/add", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            log.debug("Customer creation response : {}", (Object)response);
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode, (CharSequence)"success")) {
                    String customerId = jsonObj.getString("id");
                    customer = new Customer(Long.valueOf(customerId), email, "", phone, fname, lname);
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Status not Success", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "Response not JSON", null);
        }
        catch (Exception e) {
            log.error("An error occurred while creating Customer ", (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean isCustomerRegistered() {
        if (StringUtils.isBlank((CharSequence)this.pluginSettingsService.getCustomerID()) || StringUtils.isBlank((CharSequence)this.pluginSettingsService.getCustomerEmail()) || StringUtils.isBlank((CharSequence)this.pluginSettingsService.getCustomerAPIKey()) || StringUtils.isBlank((CharSequence)this.pluginSettingsService.getCustomerTokenKey())) {
            return Boolean.FALSE;
        }
        log.debug("customer is registered");
        return Boolean.TRUE;
    }

    public Boolean isNoOfUserExceed() {
        try {
            int licencedUsers = this.pluginSettingsService.getLicencedUsers();
            int crowdUserTier = this.pluginSettingsService.getCurrentLicenseUsers();
            if (crowdUserTier > licencedUsers && licencedUsers <= 20000) {
                log.warn("User limit exceeded: {} Crowd users registered, but the license only allows {} users.", (Object)crowdUserTier, (Object)licencedUsers);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            log.error("Error occurred during licensed user validation: {}", (Object)e.getMessage(), (Object)e);
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseExpired() {
        try {
            boolean isExpired;
            String licenseExpireDateString = this.pluginSettingsService.getLicenseExpireDate();
            if (StringUtils.isBlank((CharSequence)licenseExpireDateString)) {
                log.warn("License expiration date is blank or not set.");
                return Boolean.FALSE;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date licenseExpireDate = dateFormat.parse(licenseExpireDateString);
            Date currentDate = new Date();
            log.debug("License expiration date: {}", (Object)licenseExpireDate);
            log.debug("Current date: {}", (Object)currentDate);
            boolean bl = isExpired = !currentDate.before(licenseExpireDate);
            if (isExpired) {
                log.info("License has expired.");
                this.pluginSettingsService.setLicenseVerified(Boolean.FALSE);
            }
            return isExpired;
        }
        catch (ParseException e) {
            log.error("Error parsing the license expiration date: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            log.error("Unexpected error occurred while verifying the license: {}", (Object)e.getMessage(), (Object)e);
        }
        return Boolean.FALSE;
    }

    public boolean isValidLicense() {
        boolean licenseVerified = this.pluginSettingsService.getLicenseVerified();
        boolean licenseExpired = this.isLicenseExpired();
        if (!this.isCustomerRegistered().booleanValue()) {
            log.error("Customer is not registered.");
            return false;
        }
        if (!licenseVerified) {
            log.error("miniOrange SAML app's license is not verified.");
        }
        if (licenseExpired) {
            log.error("miniOrange SAML app's license has expired.");
        }
        boolean isValid = licenseVerified && !licenseExpired;
        log.info("miniOrange SAML app's license validity status: {}", (Object)(isValid ? "Valid" : "Invalid"));
        return isValid;
    }

    public boolean isTrialLicense() {
        String licenseType = this.pluginSettingsService.getLicenseType();
        boolean isTrial = "TRIAL".equalsIgnoreCase(licenseType);
        log.debug("License type: {}, is trial: {}", (Object)licenseType, (Object)isTrial);
        return isTrial;
    }

    public Boolean verifyLicense(String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", this.pluginSettingsService.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", this.pluginSettingsService.getSpBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf(this.pluginSettingsService.getCustomerID()), this.pluginSettingsService.getCustomerAPIKey()));
            log.debug("Verify license response: {}", (Object)response);
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                log.debug(" statusNode : {}", (Object)statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode, (CharSequence)"success")) {
                    this.getLicencedUsers();
                    this.pluginSettingsService.setCustomerLicenseKey(key);
                    this.pluginSettingsService.setLicenseVerified(Boolean.TRUE);
                    this.pluginSettingsService.setLicenseType(responseJson.getString("licenseType"));
                    this.pluginSettingsService.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                    return true;
                }
                return false;
            }
            log.debug("Please contact support. Response String: {}", (Object)response);
            return false;
        }
        catch (Exception e) {
            log.error("An error occurred while verifying license key", (Throwable)e);
            return false;
        }
    }

    public void getLicencedUsers() {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", this.pluginSettingsService.getCustomerID());
            jsonObject.put("applicationName", "crowd_saml_sso_premium_plan");
            String json = jsonObject.toString();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf(this.pluginSettingsService.getCustomerID()), this.pluginSettingsService.getCustomerAPIKey()));
            log.debug("check customer license response: {}", (Object)response);
            if (PluginUtils.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    this.pluginSettingsService.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    this.pluginSettingsService.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    log.debug("no of license in user = " + licensedUsers);
                    if (licensedUsers > 0) {
                        this.pluginSettingsService.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            log.error("Please contact support. Response String: {}", (Object)response);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            log.error("an error occurred while getting licensed users", (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public Boolean checkLicenseCondition() {
        if (this.isNoOfUserExceed().booleanValue() && !this.isTrialLicense()) {
            if (this.pluginSettingsService.getMailSent().booleanValue()) {
                this.deactivateAndRemoveCustomerAccount();
                return false;
            }
            log.debug("Sending User limit exceeded email");
            PluginUtils.sendEmail("You have exceeded license users count for miniOrange Crowd SAML SSO plugin. Please update you license otherwise plugin will stop working after 7 days from now", "Hello,<br><br>You have exceeded allowed users count (" + this.pluginSettingsService.getLicencedUsers() + " users) on your Crowd Server. <br>Your account will be deactivated after 7 days.Please upgrade your license.Contact us at support-atlassian@miniorange.atlassian.net to get more information and to upgrade your license.<br><br>Thanks,<br>miniOrange", this.pluginSettingsService.getCustomerID(), this.pluginSettingsService.getCustomerEmail(), this.pluginSettingsService.getCustomerAPIKey());
            this.pluginSettingsService.setMailSent(true);
        } else {
            this.pluginSettingsService.setMailSent(false);
        }
        return true;
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            if (this.pluginSettingsService.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", this.pluginSettingsService.getCustomerLicenseKey());
                jsonObject.put("customerKey", this.pluginSettingsService.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", this.pluginSettingsService.getSpBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf(this.pluginSettingsService.getCustomerID()), this.pluginSettingsService.getCustomerAPIKey()));
                log.debug("Deactivate license response: {}", (Object)response);
            }
            this.pluginSettingsService.removeCustomerAccount();
        }
        catch (Exception e) {
            log.error("An error occurred while deactivating the license.", (Throwable)e);
            this.pluginSettingsService.removeCustomerAccount();
        }
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/key", json, "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (PluginUtils.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode, (CharSequence)"success")) {
                    Long customerId = Long.valueOf(jsonObj.getString("id"));
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new PluginException(PluginException.PluginErrorCode.INVALID_MO_LOGIN, "Couldn't verify your account. Please contact support at support-atlassian@miniorange.atlassian.net", null);
            }
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            log.error("An account verification error occurred ", (Throwable)e);
            throw new PluginException(PluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public void generateTrial() {
        log.debug("Generating trial");
        Date expiry = DateUtils.addMonths((Date)new Date(), (int)1);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
        this.pluginSettingsService.setTrialActivated(true);
        this.pluginSettingsService.setCustomerAPIKey("NA");
        this.pluginSettingsService.setCustomerEmail("-");
        this.pluginSettingsService.setCustomerId("NA");
        this.pluginSettingsService.setCustomerTokenKey("PYBz3WIfBEn3DUHx");
        this.pluginSettingsService.setLicenseType("TRIAL");
        this.pluginSettingsService.setLicencedUsers(10);
        this.pluginSettingsService.setLicenseExpireDate(dateFormatter.format(expiry));
        this.pluginSettingsService.setLicenseVerified(Boolean.TRUE);
    }

    public Boolean checkIfCustomerExists(String email) {
        log.debug("checking if customer with email {} is already existing in miniOrange ", (Object)email);
        try {
            JSONObject jsonObj;
            String statusNode;
            Customer customer;
            String json;
            String response;
            if (StringUtils.isNotBlank((CharSequence)email) && PluginUtils.isJSONString(response = HttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/check-if-exists", json = (customer = new Customer(email, null, null, null, null)).getJSON(), "application/json", PluginUtils.getAuthorizationHeaders(Long.valueOf("16555"), "16555"))).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (jsonObj = new JSONObject(response)).getString("status")), (CharSequence)"success")) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while checking if customer already exists in miniOrange", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    @Generated
    public PluginLicenseService(PluginSettingsService pluginSettingsService) {
        this.pluginSettingsService = pluginSettingsService;
    }
}

