/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.miniorange.sso.saml.model.ConfigAjaxAttributes;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetConfigurationServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GetConfigurationServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginLicenseService pluginLicenseService;
    private final PropertyManager propertyManager;

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        log.debug("MoGetConfigurationServlet : doGet called.");
        if (this.pluginLicenseService.isCustomerRegistered().booleanValue() && this.pluginSettingsService.getLicenseVerified().booleanValue()) {
            if (this.pluginLicenseService.isTrialLicense() && !this.pluginLicenseService.isLicenseExpired().booleanValue()) {
                log.debug("Trial license is activated but not expired");
                this.getConfiguration(request, response);
            } else if (!this.pluginLicenseService.isTrialLicense()) {
                log.debug("Premium license is activated");
                this.getConfiguration(request, response);
            }
        }
    }

    public void getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        log.debug("MoGetConfigurationServlet : getConfiguration called. ");
        try {
            Integer licencedUsers = this.pluginSettingsService.getLicencedUsers();
            int crowdUserTier = this.propertyManager.getCurrentLicenseResourceTotal();
            log.debug("licencedUsers " + licencedUsers + " crowdUserTier : " + crowdUserTier);
            Boolean isConfigured = false;
            if (this.pluginSettingsService.isNoOfUserExceed().booleanValue() && !this.pluginLicenseService.isTrialLicense()) {
                log.error("No of user in Crowd is exceeded. Please upgrade you miniOrange license user tier");
                isConfigured = Boolean.FALSE;
            }
            Boolean canUserSaveDetails = false;
            if (this.pluginSettingsService.getIdpMap().size() > 0 || StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                canUserSaveDetails = true;
                isConfigured = true;
            }
            Boolean sloConfigured = StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSloServiceUrl());
            Boolean disableDefaultLogin = this.pluginSettingsService.getDefaultLoginDisabled();
            Boolean autoActivateUser = this.pluginSettingsService.getAutoActivateUser();
            Boolean backdoorEnabled = this.pluginSettingsService.getBackdoorEnabled();
            HashMap<String, String> idpMap = this.pluginSettingsService.getIdpMap();
            ArrayList<String> idpList = this.pluginSettingsService.getIdPList();
            Boolean restrictBackdoor = this.pluginSettingsService.getRestrictBackdoor();
            Boolean useDomainMapping = this.pluginSettingsService.getUseDomainMapping() != false && idpList.size() > 1;
            ConfigAjaxAttributes attrs = new ConfigAjaxAttributes(isConfigured, this.pluginSettingsService.getLoginButtonText(), sloConfigured, disableDefaultLogin, backdoorEnabled, canUserSaveDetails, autoActivateUser, idpMap, idpList, useDomainMapping, restrictBackdoor);
            String attrsJSON = attrs.getJSON();
            response.setContentType("application/json");
            response.getOutputStream().write(attrsJSON.getBytes("UTF-8"));
            response.getOutputStream().close();
        }
        catch (Exception e) {
            log.error("Error occured while getting plugin's configuration and the error message is: " + e);
        }
    }

    @Generated
    public GetConfigurationServlet(PluginSettingsService pluginSettingsService, PluginLicenseService pluginLicenseService, PropertyManager propertyManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginLicenseService = pluginLicenseService;
        this.propertyManager = propertyManager;
    }
}

