/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginMetadataService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchMetadataAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(FetchMetadataAPI.class);
    private final PluginLicenseService pluginLicenseService;
    private final PluginMetadataService pluginMetadataService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Fetch metadata servlet doGet() called");
        try {
            String pluginMetadata = this.pluginMetadataService.generatePluginMetadata();
            response.setContentType("text/xml");
            response.getOutputStream().write(pluginMetadata.getBytes());
        }
        catch (Exception e) {
            log.error("An error occured while generating the metadata.", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    @Generated
    public FetchMetadataAPI(PluginLicenseService pluginLicenseService, PluginMetadataService pluginMetadataService) {
        this.pluginLicenseService = pluginLicenseService;
        this.pluginMetadataService = pluginMetadataService;
    }
}

