<html>
    <head>
        <meta name="decorator" content="atl.general"/>
        <script>
			AJS.$(document).ready(function() {
	            AJS.$(".aui-nav li").removeClass("aui-nav-selected");
	            AJS.$("#LISTIDP").addClass("aui-nav-selected");
	            showImportFromMetadata();
	            AJS.$("#metadataOption").change(function () {
                showImportFromMetadata();});

                refreshMetadataSettings();
                AJS.$("#refreshMetadata").change(function () {
                    refreshMetadataSettings();
                });


                AJS.$("#refreshInterval").change(function () {
                    var value = AJS.$("#refreshInterval").val();
                    if (value == "custom") {
                        AJS.$("#customRefreshValue").show();
                        AJS.$("#customRefreshInterval").prop("required", true);
                    } else {
                        AJS.$("#customRefreshValue").hide();
                        AJS.$("#customRefreshInterval").prop("required", false);
                    }
                });

                function refreshMetadataSettings(){
                    var refreshMetadata = document.getElementById('refreshMetadata');
                    if (refreshMetadata.checked) {
                            AJS.$("#refreshInterval").prop("disabled", false);
                            AJS.$("#certificateRollover").show();
                            AJS.$("#inputUrl2").prop("required", true);
                            if (AJS.$("#refreshInterval").val() == "custom") {
                                AJS.$("#customRefreshValue").show();
                                AJS.$("#customRefreshInterval").prop("required", true);
                            } else {
                                AJS.$("#customRefreshValue").hide();
                                AJS.$("#customRefreshInterval").prop("required", false);
                            }
                        } else {
                            AJS.$("#certificateRollover").hide();
                            AJS.$("#refreshInterval").prop("disabled", true);
                            AJS.$("#inputUrl2").prop("required", false);
                            AJS.$("#customRefreshValue").hide();
                            AJS.$("#customRefreshInterval").prop("required", false);
                        }

                }

        	});



        	 var fromFile = {
                label: "Upload IDP Metadata File:",
                description: "This file is used to fetch your IDP settings. Reach out to us using Support if you need any help"
            }
            var fromUrl = {
                label: "Enter IDP Metadata URL:",
                description: "This URL is used to fetch your IDP settings. Please make sure that URL is accessible. Reach out to us using Support if you need any help"
            };



            /**
        	 * map is used to store the idp objects with the option value. This map is used in changeFieldValues() and changeFileFieldValues() functions
        	 */
            var map = {};
            map['fromUrl'] = fromUrl;
            map['fromFile'] = fromFile;

			 function popup(mylink, windowname) {
				if (! window.focus)return true;
				var href;
				if (typeof(mylink) == 'string') href=mylink;
				else href=mylink.href;
				window.open(href, windowname, 'width=800,height=600,scrollbars=yes');
				return false;
			}

            function showFileForm() {
                AJS.$("#importByFile").show();
                AJS.$("#importByUrl").hide();
                AJS.$("#importButtons").show();
                AJS.$("#inputUrl").prop("required", false);
                AJS.$("#xmlFile").prop("required", true);
                AJS.$("#fileSubmitted").val("true");
                AJS.$("#urlSubmitted").val("false");
            }
            function showUrlForm() {
                AJS.$("#importByUrl").show();
                AJS.$("#importByFile").hide();
                AJS.$("#importButtons").show();
                AJS.$("#inputUrl").prop("required", true);
                AJS.$("#xmlFile").prop("required", false);
                AJS.$("#fileSubmitted").val("false");
                AJS.$("#urlSubmitted").val("true");
                AJS.$("#effective_metadata_url_div").hide();
                document.getElementById('effective_metadata_url').innerHTML = "";
            }
            function changeFieldValues(idp, type) {
                var idpObj = map[idp];

                document.getElementById("metadata_url_label").innerHTML = idpObj.label;
                document.getElementById("metadata_url_description").innerHTML = idpObj.description;

                var inputUrl = document.getElementById("inputUrl");

                var hostname = document.createElement('input');
                hostname.id = inputUrl.id;
                hostname.name = inputUrl.name;
                hostname.style = inputUrl.style;
                hostname.className = "text long-field";
                hostname.placeholder = idpObj.label;
                hostname.type = type;
                hostname.value = inputUrl.value;
                inputUrl.parentNode.replaceChild(hostname, inputUrl);

            }
            function changeFileFieldValues(idp) {
                var idpObj = map[idp];

                document.getElementById("metadata_file_label").innerHTML = idpObj.label;
                document.getElementById("metadata_file_description").innerHTML = idpObj.description;
            }

            function showImportFromMetadata() {
                var value = AJS.$("#metadataOption").val();
                if (value != null) {
                    switch (value) {
                        case "fromUrl":
                            changeFieldValues('fromUrl', 'url');
                            showUrlForm();
                            break;
                        case "fromFile":
                            changeFileFieldValues('fromFile')
                            showFileForm();
                            break;
                    }
                }
            }
			 function showTestConfiguration(idpname){
             	        	var next = "testidpconfiguration"
             	        	var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/auth';
             	        	samlAuthUrl += "?return_to=" + next+"&idp="+idpname;
             	        	var myWindow = window.open(samlAuthUrl, "TEST SAML IDP", "scrollbars=1 width=800, height=600");
             }

			function DisplayRequest(idpname){
				var osDestination = "displaysamlrequest";
				var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/auth';
				samlAuthUrl += "?return_to=" + osDestination+"&idp="+idpname;
				var myWindow = window.open(samlAuthUrl, "TEST SAML IDP", "scrollbars=1 width=800, height=600");
			}

			function DisplayResponse(idpname){
				var osDestination = "displaysamlresponse";
				var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/auth';
				samlAuthUrl += "?return_to=" + osDestination +"&idp="+idpname;
				var myWindow = window.open(samlAuthUrl, "TEST SAML IDP", "scrollbars=1 width=800, height=600");
			}

			function copy(that, message) {
                         var inp = document.createElement('input');
                         document.body.appendChild(inp)
                         inp.value = that.textContent
                         inp.select();
                         document.execCommand('copy', false);
                         inp.remove();
                         $(message).show();
                         setTimeout(function () { $(message).hide("slow"); }, 5000);
             }

			function showmeta(){
	        	document.getElementById('browse').style.display= "block";
	        	document.getElementById('config').style.display= "none";
	        }

	        function showmetadata(){
	        	document.getElementById('browse').style.display= "none";
	        	document.getElementById('config').style.display= "block";
	        }
			function openTab(evt, tabName) {
                  var i, tabcontent, tablinks;

                  tabcontent = document.getElementsByClassName("tabcontent");
                  for (i = 0; i < tabcontent.length; i++) {
                      tabcontent[i].style.display = "none";
                  }
                  tablinks = document.getElementsByClassName("tablinks");
                  for (i = 0; i < tablinks.length; i++) {
                      tablinks[i].className = tablinks[i].className.replace(" active", "");
                  }
                  document.getElementById(tabName).style.display = "block";
                  evt.currentTarget.className += " active";
                  }

            function GetDynamicTextArea(){
                        return '<textarea id="x509Certificate" name="allX509certificates" class="textarea long-field" '+
                        'style="font-family:Courier New;" cols="64" rows="4"></textarea>'+
                        '&nbsp;<input type="button" value="-" id="removeCertificate" onclick="RemoveCertificate(this)" class="aui-button" style="vertical-align: text-bottom;"/>'
            }

        	AJS.$(document).on('click','#addIDPCertificate',function(){
                        var div = document.createElement('DIV');
                        div.innerHTML = GetDynamicTextArea();
                        var idpSigningCertificates = document.getElementById("idpSigningCertificates");
                        console.log("idp certificate is:"+idpSigningCertificates);
                        var addIDPCertificateButton = document.getElementById("addIDPCertificate");
                        idpSigningCertificates.insertBefore(div, addIDPCertificateButton);
            });

            function RemoveCertificate(div) {
                document.getElementById("idpSigningCertificates").removeChild(div.parentNode);
            }

        </script>
        <style>

			/* Style the tab */
         .tab {
         overflow: hidden;
         display: flex; //justify-content: center;
         }
         /* Style the buttons inside the tab */
         .tab a {
         //border: 1px solid #ccc;
         //background-color: #f1f1f1;
         cursor: pointer;
         padding: 14px 16px;
         font-size: 17px; //text-align:middle;
         margin-left: 1%;
         }
         .tab a:hover {
         transition: 0.3s; //background-color: inherit;
         border: none;
         outline: none;
         background: none !important;
         text-decoration: none !important;
         }
         /* Create an active/current tablink class */
         .tab a.active {
         border-bottom: 3px solid blue;
         background: none !important;
         text-decoration: none !important;
         }
         .tab li {
         margin: 0 auto;
         float: left;
         }
         #navbar {
         float: left;
         }
         /* Style the tab content */
         .tabcontent {
         display: none;
         padding: 0px 0px;
         -webkit-animation: fadeEffect 1s;
         animation: fadeEffect 1s;
         }
    		.aui-page-panel-content{
				padding: 0px !important;
			}

			.aui-page-panel{
				margin: 0px !important;
			}


			.labelClass {
                width: 275px !important;
                margin-left: -286px !important;
                margin-left: -250px;
                width: 235px;
                padding: 0 0 0 0;
             }

            .field-group{
                margin: 10px 100px 1px 100px !important;
                margin-left: 100px !important;
            }

			.group{
				margin: 10px 100px 1px 105px !important;
			}

			.legends{
				margin-left: -140px !important;
			}

			#admin{
				margin: 20px 100px 0px 0px !important;
			}

    	</style>
    </head>



    <body>
     <#include "*/header.ftl" parse=true>
	<div class="tabs-pane active-pane" id="configure-sp" aria-labelledby="aui-uid-1" role="tabpanel" aria-hidden="true">

		  <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
            <div class="aui-navgroup-inner">
               <div id="navbar" class="aui-navgroup-primary">
                  <span style="float:right;margin-right:25px;margin-top:-10px;">
                     <div class="tab idp-config">
                        <ul class="aui-nav">
                           <li>
                              <a class="tablinks active" onclick="openTab(event, 'config')" id="defaultOpen">Manual Configuration</a>
                           </li>
                           <li>
                              <a id= "importFromMetadataButton" class="tablinks " onclick="openTab(event, 'browse')">Import From Metadata</a>
                           </li>
                        </ul>
                     </div>
                  </span>
               </div>
            </div>
         </nav>
		 <!-- Import From Metadata Starts Here -->

	<div id="browse"  class="tabcontent" style="display: none;" style="margin-top:15px;">
	<#assign uploadMetadata = settings.getSpBaseUrl() + "/plugins/servlet/saml/uploadmetadata">
		<form id="metadata_url" name="metadata_url" method="POST" action="${uploadMetadata}" class="aui" enctype="multipart/form-data">
		    <input type="hidden" name="metadataImported" value="true">
            <input type="hidden" id="urlSubmitted" name="urlSubmitted" value="true" />
		    <input type="hidden" id="idpID" name="idpID" value="${idpID}"/>
            <table style="width:100%;">
                <tr>
                    <td colspan="3">
                        <p style="font-size:13pt;"><br>Import From IDP Metadata URL
                        </p>
                    </td>
                </tr>
                <tr><td colspan="4"><hr></td></tr>
                <tr>
                     <td width="20%">
                        IDP Name:
                        <span style="color: red">*</span>
                     </td>
                     <td>
                         <input type="text" required="true" id="idpNameImport" name="idpName" value="${idpName}" placeholder="Enter the name for your IDP"
                                              style="width:30%; padding: 5px;" class="text long-field" />
                     <div class="description">This IDP Name will be shown in the login widget to users.</div>
                     </td>
                </tr>
                <tr><td>&nbsp;</td></tr>
				<tr>
                    <td width="20%">Select Import Option: </td>
                    <td>
                        <div id="selectIDP">
                            <select class="select" id="metadataOption" name="metadataOption" style="width:200px">
                                <option value="fromUrl")selected #end> Import From Metadata URL </option>
                                <option value="fromFile" #end> Import From Metadata File </option>
                            </select>
                        </div>
                    </td>
                </tr>
            </table>
            <tr><td>&nbsp;</td></tr>
            <tr><td>&nbsp;</td></tr>
            <div id="importByUrl" style="display: none;">
                <!-- <form name="saml_form_url" id="saml_form_url" method="post" action="" class="aui long-label" > -->
                <table style="width:100%;">
                    <tr>
                        <td id="metadata_url_label" width="20%"></td>
                        <td>
                            <input type="hidden" id="urlSubmitted" name="urlSubmitted" value="true" />
                            <input type="url" id="inputUrl" name="inputUrl" required value="${inputUrl}" placeholder="Enter metadata URL of your IdP" style="width:70%; padding: 5px;"
                                class="text long-field" />
                            <div id="metadata_url_description" class="description"></div>
                        </td>
                    </tr>
                    <tr id="effective_metadata_url_div" style="display: none">

                        <td width="20%">Effective Metadata URL:</td>
                        <td>
                            <p id="effective_metadata_url" style="background-color: #f5f5f5; font-weight: bold"> </p>
                        </td>

                    </tr>
                </table>
            </div>
            <tr><td>&nbsp;</td></tr>
            <div id="importByFile" style="display: none;">
                                <table style="width:100%;">
                    <tr>
                        <td id="metadata_file_label" width="20%"></td>

                        <td>
                            <!-- <form name="saml_form_file" id="saml_form_file" method="post" action="" enctype="multipart/form-data"> -->
                            <input type="hidden" id="fileSubmitted" name="fileSubmitted" value="true" />
                            <input type="file" id="xmlFile" name="xmlFile" class="ignore-inline-attach" accept=".xml" required />
                            <div id="metadata_file_description" class="description"></div>
                            <!-- <input type="submit" onclick="showConfSP()" class="aui-button aui-button-primary" value="Upload"/> -->
                            <!-- </form> -->
                        </td>
                    </tr>
                </table>
            </div>
            <tr><td>&nbsp;</td></tr>
            <div id="importButtons" style="display: none;">
                <table style="width: 100%">
                    <tr>
                        <td style="width: 20%">&nbsp;</td>
                        <td>
                            <input type="submit" class="aui-button aui-button-primary" value="Import" />&nbsp;&nbsp;&nbsp;
                        </td>
                    </tr>
                </table>
            </div>
		</form>
        </div>
		<!-- Import From Metadata Ends Here -->





		<!-- Manual Configuration starts Here -->
		<div id="config" class="tabcontent" style="display: block;">
			<#assign idpSize = idpList?size >
              <div style="margin-top:15px;">
				  <p style="font-size:13pt;">Add Identity Provider
						<span style="float:right;margin-right:25px;">
								<#if shouldContainsAddIdp == true>
										<a class="aui-button aui-button-primary" href="addidp.action?operation=add">
											Add new IdP
										</a>
								</#if>
								<#if shouldShowBackButton == true>
										<a class="aui-button aui-button-primary" href="${crowdBaseUrl}/plugins/servlet/crowd-saml/config/listidp">
											Back
										</a>
								</#if>
						</span>
					</p>
                </div>

			<hr class="header"/>
			<form id="admin" class="aui" action="" method="POST">
				<input type="hidden" name="addIdpSubmitted" value="true"/>
				   <input type="hidden" id="idpID" name="idpID" value="${idpID}" />
				<p style="font-size:13pt;">
					  Configure IDP
				   </p>
				<p>Click on <b>Import From Metadata</b> to upload IDP's metadata URL <i>OR</i> copy the URLs from Step 2 below to setup IDP details.</p>
				<p>Need help with the configuration? You can reach out to us using <b>Support</b> widget or write to us at <a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a> and avail <b>free support</b> to setup the app.
				</p>
				<div id="newAcsUrl" class="field-group">
                     <label for="acsUrl"> ACS URL for IDP-Initiated SSO</label>
                    <span title="click to copy" style="cursor:default"> <span id="acsUrl" onmousedown="copy(this,'#c1')"><strong>${acsUrl}</strong></span>&nbsp;&nbsp;<span id="c1" title="Copied" class="show-title" hidden></span></span>
                    <br>
                    <div class="description">Update this ACS URL in IDP if you want to use IDP-Initiated SSO (optional). For copying click on ACS url.</div>
                </div>
					<div class="field-group">
					   <label for="idpNameImport">IDP Name:
						   <span class="aui-icon icon-required">(required)</span>
					   </label>
					   <input type="text" required="true" id="idpNameImport" name="idpName" value="${idpName}" placeholder="Enter the name for your IDP"
						   class="text long-field" />
					   <div class="description">This IDP Name will be shown in the login widget to users.</div>
				   </div>
				  <div class="field-group">
					  <label for="idpEntityId" class="labelClass">IDP Entity ID:
					  <span class="aui-icon icon-required">(required)</span>
					  </label>

					 <#if action.idpEntityId == "">
					 <input type="text" required="true" id="idpEntityId" name="idpEntityId" value=""
							 class="text long-field"/>
					 <#else>
					 <input type="text" required="true" id="idpEntityId" name="idpEntityId" value="${action.idpEntityId}"
						 class="text long-field"/>
					 </#if>
					  <div class="description">
						 Enter the Entity ID or Issuer value of your Identity Provider. You can find its value in the entityID attribute of EntityDescriptor tag in <br>IdP-Metadata XML file.
					  </div>
				   </div>

					<div class="field-group">
							<label for="signedRequest" class="labelClass">Send Signed Requests:</label>
							<#if signedRequest == true>
								<input class="checkbox" data-size="small" data-on-text="Yes" data-off-text="No" type="checkbox"
									name="signedRequest" checked="true" value="true" id="signedRequest"/>
							<#else>
								<input class="checkbox" data-size="small" data-on-text="Yes" data-off-text="No" type="checkbox"
									   name="signedRequest" value="true" id="signedRequest"/>
							</#if>
							<div class="description">
								 It is recommended to keep it checked. Uncheck it, only if your IdP is not accepting Signed SAML Request.
							</div>
							<#if  settings.getSignedRequest() == true && settings.getSigning() == false>
							<div class="description">
								<div class="aui-message aui-message-warning">
									<span> Warning: Signing certificate is disabled in IDP configuration. Please enable <b>Include Signing Certificate in Metadata</b> in <a href="${configure}.action">Service Provider Info</a>.</span>
								</div>
							</div>
						</#if>
					</div>

					<fieldset class="group">
						<legend class="legends">
							<span>SSO Binding Type:</span>
						</legend>
						<#if ssoBindingType == "HttpRedirect">
						<input class="radio" type="radio" name="ssoBindingType" id="httpRedirect" value="HttpRedirect"
							   checked="checked"/>
						<#else>
						<input class="radio" type="radio" name="ssoBindingType" id="httpRedirect" value="HttpRedirect"/>
						</#if>
						<label for="httpRedirect">Use HTTP-Redirect Binding for SSO</label>


						<#if ssoBindingType == "HttpPost" >
						<input class="radio" type="radio" name="ssoBindingType" id="httpPost" value="HttpPost"
							   checked="checked"/>
						<#else>
						<input class="radio" type="radio" name="ssoBindingType" id="httpPost" value="HttpPost"/>
						</#if>
						<label for="httpPost">Use HTTP-Post Binding for SSO</label>
					</fieldset>

					<div class="field-group">
						<label for="ssoUrl" class="labelClass">Single Sign On URL:
							<span class="aui-icon icon-required">(required)</span>
						</label>
						<#if action.ssoUrl == "">
						<input type="url" required="true" id="ssoUrl" name="ssoUrl" value="" class="text long-field"/>
						<#else>
						<input type="url" required="true" id="ssoUrl" name="ssoUrl" value="${action.ssoUrl}" class="text long-field"/>
						</#if>
						<div class="description">
							Enter the Single Sign-on Service endpoint of your Identity Provider. You can find its value in SingleSignOnService tag (Binding type: HTTP-Redirect) in IdP-Metadata XML file.
						</div>
					</div>

					<fieldset class="group">
						<legend class="legends">
							<span>SLO Binding Type:</span>
						</legend>
						<#if sloBindingType == "HttpRedirect">
						<input class="radio" type="radio" name="sloBindingType" id="httpRedirectslo" value="HttpRedirect"
							   checked="checked"/>
						<#else>
						<input class="radio" type="radio" name="sloBindingType" id="httpRedirectslo" value="HttpRedirect"/>
						</#if>
						<label for="httpRedirectslo">Use HTTP-Redirect Binding for SLO</label>


						<#if sloBindingType == "HttpPost">
						<input class="radio" type="radio" name="sloBindingType" id="httpPostslo" value="HttpPost"
							   checked="checked"/>
						<#else>
						<input class="radio" type="radio" name="sloBindingType" id="httpPostslo" value="HttpPost"/>
						</#if>
						<label for="httpPostslo">Use HTTP-Post Binding for SLO</label>
					 </fieldset>

					 <div class="field-group" class="labelClass">
						<label for="sloUrl" class="labelClass">Single Logout URL:</label>
						<input type="url" id="sloUrl" name="sloUrl" value="${sloUrl}" class="text long-field"/>
						<div class="description">
							Enter the Single Logout Service endpoint of your Identity Provider. You can find its value in SingleLogoutService tag in IdP-Metadata XML file. Leave blank if SLO not supported by IDP
						</div>
					</div>

					<div class="field-group">
		                  <label for="nameIdFormat">NameID Format:</label>
		                  <select class="select" name="nameIdFormat" id="nameIdFormat" style="max-width: 400px;">
			                  <#foreach nameID in  nameIdFormats>
				                  <option id="${nameID}" value="${nameID}"
					                  <#if nameIdFormat?? && nameIdFormat.equals(nameID)>selected</#if>
					                  >${nameID}
				                  </option>
			                  </#foreach>
		                  </select>
		                  <div class="description">
		                     Select the name identifier format supported by the IdP.Select <b>unspecified</b> by default.
		                  </div>
                    </div>

					<div class="field-group" id="idpSigningCertificates">
						<label for="x509Certificate">IDP Signing Certificate:
							<span class="aui-icon icon-required">(required)</span>
									</label>
                          <#assign loopCount = 0>
						  <#if certificates?has_content>
							  <#foreach x509Certificate in certificates>
								 <div>
									<textarea id="x509Certificate" name="allX509certificates" class="textarea long-field" style="font-family:Courier New;" cols="64" rows="4">${x509Certificate}</textarea>
								    <#if loopCount gt 0 >
								    <input type='button' value='-' id='removeCertificate' onclick='RemoveCertificate(this)' class="aui-button" style="vertical-align: text-bottom;">
								    </#if>
								 </div>
								 <#assign loopCount++>
							</#foreach>
						  <#else>
								<div>
									<textarea id="x509Certificate" required="true" name="x509Certificate" class="textarea long-field" style="font-family:Courier New;" cols="64" rows="4">${x509Certificate}</textarea>
								</div>
						  </#if>
						  <input type='button' value='+' id='addIDPCertificate' class="aui-button aui-button-primary">

							 <div class="description">This Certificate is used to validate SAML response from Identity Provider. You can find its value in X509Certificate tag in IdP-Metadata XML file. (parent tag: KeyDescriptor use="signing"). If your IDP provided you the certificate file, open it
								   in Notepad and copy/paste the content here.
						     <br>
                              Click on the "+" button to configure more than one IDP certificates.
							 </div>
					</div>
					<br/>
					<div class="field-group">
                            <label for="refreshMetadata" class="labelClass">Certificate Rollover:  </label>
                            <span style="vertical-align:middle;">
                                 <label class="moswitch" style="vertical-align:middle;">
                                    <#if refreshMetadata == true>
                                    <input type="checkbox" id="refreshMetadata" value="true" name="refreshMetadata" checked="true">
                                    <span class="moslider moround"></span> <#else>
                                    <input type="checkbox" id="refreshMetadata" value="true" name="refreshMetadata">
                                    <span class="moslider moround"></span></#if>
                                 </label>
                            </span>
                            <span>Refresh Certificate periodically?</span>
                    </div>

                    <div id="certificateRollover" class="field-group">
                        <span style="vertical-align:middle;">
                            <input type="url" id="inputUrl2" name="inputUrl" value="${inputUrl}" placeholder="Enter metadata URL of your IdP" style="width:70%; padding: 5px;" class="text long-field" />
                            <div id="metadata_url_description" class="description"></div>
                        </span>
                        <div class="description">You can store the metadata URL and refresh IDP Certificate periodically.</div>

                        <select class="select" id="refreshInterval" name="refreshInterval">
                        <option disabled hidden <#if refreshInterval == ""> selected </#if>>Select Time Interval</option>
                            <option  value="hourly" <#if refreshInterval.equals( "hourly")> selected </#if>>Hourly</option>
                            <option  value="twicedaily" <#if refreshInterval.equals( "twicedaily")> selected </#if>>Twice Daily</option>
                            <option  value="daily" <#if refreshInterval.equals( "daily")> selected </#if>>Daily</option>
                            <option  value="weekly" <#if refreshInterval.equals( "weekly")> selected </#if>>Weekly</option>
                            <option  value="monthly" <#if refreshInterval.equals( "monthly")> selected </#if>>Monthly</option>
                            <option  value="custom" <#if refreshInterval.equals( "custom")> selected </#if>>Custom</option>
                        </select>&nbsp;&nbsp;&nbsp;&nbsp;
                        <span id="customRefreshValue">
                            <input type="number" min="1" max="525600" id="customRefreshInterval" name="customRefreshInterval" value="${customRefreshInterval}"
                                class="text" />&nbsp;&nbsp;
                            <select name="customRefreshIntervalUnit" class="select">
                                <option  value="minutes" <#if customRefreshIntervalUnit.equals( "minutes") > selected </#if>>Minutes</option>
                                <option  value="hours" <#if customRefreshIntervalUnit.equals( "hours")> selected </#if>>Hours</option>
                                <option  value="days" <#if customRefreshIntervalUnit.equals( "days") > selected </#if>>Days</option>
                            </select>
                        </span>
                        <div class="description">Set Time Interval to update IDP Certificate.</div>
                     </div>
					 <br/>
					 <div class="field-group">
							  <input type="submit" value="Save" class="aui-button aui-button-primary" style="width:170px;"/>
							  &nbsp;&nbsp;&nbsp;
						 <#if (action.idpEntityId??) && (action.idpEntityId != "")>
							<input type="button" id="test-saml-configuration" value="Test Configuration" class="aui-button"  style="width: 169px;" onclick="showTestConfiguration('${idpID}')"/>
						<#else>
							<button class="aui-button" aria-disabled="true" style="width: 169px;" disabled>Test Configuration</button>
						</#if>

					 </div>
					 <div class="field-group">
						<#if (action.idpEntityId??) && (action.idpEntityId != "")>
							<input type="button" id="display-saml-request" style="width:170px;" value="View SAML Request"  class="aui-button"  onclick="DisplayRequest('${idpID}')"/>
							&nbsp;&nbsp;&nbsp;
							<input type="button" id="display-saml-response" style="width:170px;" value="View SAML Response" class="aui-button" onclick="DisplayResponse('${idpID}')" />
						<#else>
							<button class="aui-button" aria-disabled="true" style="width:170px;" disabled>View SAML Request</button>
							&nbsp;&nbsp;&nbsp;
							<button class="aui-button" aria-disabled="true" style="width:170px;" disabled>View SAML Response</button>
						</#if>
						<p><b>Note:</b> <b>View SAML Request</b> and <b>View SAML Response</b> buttons are needed for SAML debugging. In case, you don't get an appropriate result for Test Configuration and plan on asking for support, please copy the Authentication(SAML) Request and SAML Response you get and email it to us at <b>support-atlassian@miniorange.atlassian.net</b> for further help.</p>
					</div>

          </form>
      	</div>
		<!-- Manual Configuration Ends Here -->
	</div>
	</section>
  </body>
</html>