(function($) {
    var count = 0;
    var currentUrl = $(location).attr('href');

    if (currentUrl.match(/login.action/i)) {
        if(currentUrl.match(/reset-password/i)){
            var resetPassLink = addShowLoginFormPara(currentUrl);
            window.location = resetPassLink;
            return;
        }
        if (readCookie("SAMLCOOKIE") != "") {
            window.location.href = AJS.contextPath() + '/plugins/servlet/saml/logout';
            return;
        } else {
            loadLoginPage();
        }
    }

    function addShowLoginFormPara(currentURL){
        var url = new URL(currentURL);
        var search_params = url.searchParams;
        search_params.set('show_login_form', 'true');
        url.search = search_params.toString();
        var new_url = url.toString();
        return new_url;
    }

    function loadLoginForm(loginForm) {
        if (loginForm.length > 0) {
            loginForm.hide();
            $.ajax({
                url : AJS.contextPath() + "/plugins/servlet/saml/getconfig",
                type : "GET",
                error : function() {
                    loginForm.show();
                },
                success : function(response) {
                    console.log("response success");
                    if (response.configured === true) {
                        console.log("response configured");
                        if (response.backdoorEnabled === true) {
                            console.log("response backdoor enabled");
                            if (response.restrictBackdoor === true) {
                                var samlSso = getQueryParameterByName("saml_sso");
                                if (samlSso == "false") {
                                    renderLoginPage(response);
                                    loginForm.show();
                                    return;
                                }
                                else {
                                    renderLoginPage(response);
                                    loginForm.show();
                                    return;
                                }
                            }
                            else {
                                var samlSso = getQueryParameterByName("saml_sso");
                                if (samlSso == "false") {
                                    console.log("response showing login form");
                                    renderLoginPage(response);
                                    loginForm.show();
                                    return;
                                }
                            }
                        }
                        /*if (response.disableDefaultLogin === true) {
                            console.log("response redirecting to the idp");
                            redirectToIDP(loginForm);
                            return;
                        } else {*/
                        console.log("response showing login form");
                        renderLoginPage(response);
                        loginForm.show();
                        return;
                        //}
                    }
                    loginForm.show();
                }
            });
        }
    }
    /*
        function samlLogout() {
            AJS.$("#login").hide();
            AJS.$.ajax({
                        url : AJS.contextPath() + "/plugins/servlet/saml/getconfig",
                        type : "GET",
                        async : false,
                        error : function() {
                        },
                        success : function(response) {
                            if (response.configured === true) {
                                if (response.sloConfigured === true) {
                                    window.location.href = AJS.contextPath() + '/plugins/servlet/saml/logout';
                                    return;
                                } else {
                                    deleteCookie('SAMLCOOKIE');
                                    loadLoginPage(response);
                                }
                            }
                            AJS.$("#login").show();
                        }
                    });
        }
    */
    function renderLoginPage(response) {
        console.log("render login page");
        count++;
        var next = getQueryParameterByName('os_destination');

        var samlerror = getQueryParameterByName('samlerror');
        console.log("samlerror "+ samlerror);

        if (next) {
            var html = '<a class="aui-button aui-style aui-button-primary" href="'
                + AJS.contextPath()
                + '/plugins/servlet/saml/auth?return_to='
                + next
                + '" style="align:center;">'
                + response.loginButtonText
                + '</a>';

        } else {
            var html = '<a class="aui-button aui-style aui-button-primary" href="'
                + AJS.contextPath()
                + '/plugins/servlet/saml/auth" style="align:center;">'
                + response.loginButtonText + '</a>';
        }
        $(html).insertAfter($("input[value='Log in']"));

        if(samlerror!=null){
            if(samlerror == "sso_denied"){
                var htmlerror='<div class="aui-message aui-message-error closeable"><p>We couldn\'t sign you in. SSO in only enabled for Administrators. </p></div>';
            }else{
                var htmlerror='<div class="aui-message aui-message-error closeable"><p>We couldn\'t sign you in. Please contact your Administrator. </p></div>';
            }
            AJS.$(htmlerror).insertBefore(AJS.$("#login"));
        }

    }

    function redirectToIDP(loginForm) {
        var html = '<p>Please wait while we redirect you for authentication...</p>';
        AJS.$(html).insertBefore(loginForm);
        var osDestination = getQueryParameterByName("os_destination");
        var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/auth';
        if (!(!osDestination || /^\s*$/.test(osDestination))
            && osDestination != "/") {
            samlAuthUrl += "?return_to=" + osDestination;
        }
        window.location.href = samlAuthUrl;
    }

    function loadLoginPage() {
        count++;
        if ($("#login").length > 0) {
            loadLoginForm($("#login"));
        } else {
            var url = window.location.href;
            if (url.match(/login.action/i) && count <= 50) {
                setTimeout(loadLoginPage, 100);
            }
        }
    }

    function getQueryParameterByName(name) {
        var url = window.location.href;
        name = name.replace(/[\[\]]/g, "\\$&");
        var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"), results = regex
            .exec(url);
        if (!results)
            return null;
        if (!results[2])
            return '';
        return decodeURIComponent(results[2].replace(/\+/g, " "));
    }

    function readCookie(cname) {
        var name = cname;
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }
        return "";
    }

    function deleteCookie(name) {
        document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
    };

    //Configuration changes


    //Regular expression on username

    //OnLoad

    if (AJS.$("#regexPatternEnabled").is(":checked")) {
        AJS.$("#regexfield").show();
        AJS.$("#regexPattern").prop("required", true);
    } else {
        AJS.$("#regexfield").hide();
        AJS.$("#regexPattern").prop("required", false);
    }

    //On Change
    AJS.$(document).on('change','#regexPatternEnabled',function(){
        if(this.checked){
            AJS.$("#regexfield").show();
            AJS.$("#regexPattern").prop("required", true);
        }else{
            AJS.$("#regexfield").hide();
            AJS.$("#regexPattern").prop("required", false);
        }
    });

    //On Click shoow Test Configuration pop-up

    AJS.$(document).on('keyup', '#regexfield', function (e) {
        setTimeout(function enable() {
            if (AJS.$("#regexPattern").val() != "") {
                AJS.$("#test-regex").prop("disabled", false);
            } else {
                AJS.$("#test-regex").prop("disabled", true);
            }
        }, 500);
    });

    AJS.$(document).on('click', '#test-regex', function () {
        var osDestination = "testregex";
        var samlAuthUrl = AJS.contextPath() + '/plugins/servlet/saml/regex';
        var regex = document.getElementById('regexPattern').value;
        console.log('Escaped regex ' + regex);
        samlAuthUrl += "?return_to=" + encodeURIComponent(osDestination) + "&regexp=" + encodeURIComponent(regex);
        var testWindow = window.open(samlAuthUrl, "", "width=600,height=400");
    });


    AJS.$(document).on('change','#loginUserAttribute',function(){
        var value = AJS.$("#loginUserAttribute").val();
        if(value === "email"){
            AJS.$("#warningforemail").show();
        }else{
            AJS.$("#warningforemail").hide();
        }
    });

    AJS.$(document).on('change','#disableDefaultLogin',function(){
        if(this.checked){
            AJS.$("#enableBackdoor").prop("checked",true);
            AJS.$("#crowd_saml_backdoor_option_div").show();
            AJS.$("#crowd_saml_backdoor_url_div").show();
            AJS.$("#restrict-backdoor-div").show("slow");
        }else{
            AJS.$("#enableBackdoor").prop("checked",false);
            AJS.$("#restrictBackdoor").prop("checked",false);
            AJS.$("#crowd_saml_backdoor_option_div").hide();
            AJS.$("#crowd_saml_backdoor_url_div").hide();
            AJS.$("#restrict-backdoor-div").hide("slow");
            AJS.$("#backdoorAccessGroupsList").hide("slow");
            renderLoginPage(response);
            loginForm.show();
        }
    });

    AJS.$(document).on('change','#restrictBackdoor',function(){
        if(this.checked){
            AJS.$("#backdoorAccessGroupsList").show();
        }
        else{
            AJS.$("#backdoorAccessGroupsList").hide();
        }
    });

    AJS.$(document).on('keypress', '#login-form-email', function (e) {
        if (e.which == 13) {
            if (AJS.$("#backdoor-restriction-form").length > 0) {
                checkForBackdoorAccess();
            }
            e.preventDefault();
        }
    });

    AJS.$(document).on('click', "#check_backdoor_access", function (e) {
        checkForBackdoorAccess();
        e.preventDefault();
    });

    function checkForBackdoorAccess() {
        console.log("function checkForBackdoorAccess");
        var loginForm = document.getElementById("loginForm");

        var username = AJS.$("#login-form-email").val();
        console.log("username::",username);
        if (!username) {
            noAccessHtml = '<div id="backdoor_access_verification_error" class=\"aui-message aui-message-error closeable\"><p>Username Cannot be Empty</p></div>';
            AJS.$("#backdoor_access_verification_error").remove();
            AJS.$(noAccessHtml).insertBefore(AJS.$("#backdoor-restriction-form"));
            return;
        }
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/crowd-saml/moapi",
            data: {
                "action": "checkBackdoorAccess",
                "username": username
            },
            type: "GET",
            error: function (response) {
                console.log("error: function");
                noAccessHtml = '<div id="backdoor_access_verification_error" class=\"aui-message aui-message-error closeable\"><p>An Error Occurred while verifying access</p></div>';
                AJS.$("#backdoor_access_verification_error").remove();
                AJS.$(noAccessHtml).insertBefore(AJS.$("#backdoor-restriction-form"));
            },
            success: function (response) {
                console.log("success: function");
                console.log("response.isUserAllowedBackdoorAccess = " + response.isUserAllowedBackdoorAccess);
                if (response.isUserAllowedBackdoorAccess == true) {
                    AJS.$("#loginmultipartResolver-form-email").val(username);
                    var loginUrl = '/crowd/console/login.action?saml_sso=false';
                    window.location.href = loginUrl;
                    return;
                } else {
                    noAccessHtml = '<div id="no_backdoor_access_error" class=\"aui-message aui-message-error closeable\"><p><span>Sorry. You don\'t have access to this page. Please enter valid username for getting Login page.</span></p></div>';
                    if (!AJS.$("#no_backdoor_access_error").length)
                        AJS.$(noAccessHtml).insertBefore(AJS.$("#backdoor-restriction-form"));
                }
            }
        });
    }

    AJS.$(document).on('change', '#gmIdpName', function () {
        idp_name = AJS.$("#gmIdpName").val();
        AJS.$("#changedIdpName").val(idp_name);
        AJS.$("#group-mapping-idp-select-form").submit();
    });
    AJS.$(document).on('change', '#amIdpName', function () {
        idp_name = AJS.$("#amIdpName").val();
        AJS.$("#changedIdpName").val(idp_name);
        AJS.$("#attribute-mapping-idp-select-form").submit();
    });


    enableDisableButtons();
    function enableDisableButtons() {
        AJS.$.ajax({
            url: AJS.contextPath() + "/plugins/servlet/crowd-saml/moapi",
			data: {
			    "action": "getIdpList",
			},
            type: "GET",
            error: function () {},
            success: function (response) {
                if (response.idpList.length > 1) {
                    AJS.$("#selectIDPAm").prop("hidden", false);
                    AJS.$("#selectIDPGm").prop("hidden", false);
                }
                if (response.canUserSaveDetails == true) {
                    AJS.$("#amSubmit").prop("disabled", false);
                    AJS.$("#gmSubmit").prop("disabled", false);
                    AJS.$("#gm_Submit").prop("disabled", false);
                } else {
                    AJS.$("#amSubmit").prop("disabled", true);
                    AJS.$("#gmSubmit").prop("disabled", true);
                    AJS.$("#gm_Submit").prop("disabled", true);
                }

            }
        });
    }


})(AJS.$ || jQuery);