/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.service.SAMLService;
import com.miniorange.sso.saml.utils.EncryptionUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class SAMLLogoutServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SAMLLogoutServlet.class);
    private final PropertyManager propertyManager;
    private final PluginLicenseService pluginLicenseService;
    private final SAMLService samlService;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("SAML Logout :doGet called");
        String redirectURL = request.getParameter("conn_redirect_url");
        if (StringUtils.isNotBlank((CharSequence)redirectURL)) {
            Cookie cookie = new Cookie("redirectURL", redirectURL);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
        this.handleSAMLLogout(request, response, false);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("SAML Logout :doPost called");
        Cookie redirectURL = this.getCookie(request, "redirectURL");
        if (redirectURL != null) {
            String sloRedirect = redirectURL.getValue();
            this.clearCookie(request, response, "redirectURL");
            log.debug("Redirecting to  : " + sloRedirect);
            response.sendRedirect(sloRedirect);
            return;
        }
        this.handleSAMLLogout(request, response, true);
    }

    private void handleSAMLLogout(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest) throws IOException {
        log.info("SAML Logout : handleSAMLLogout called");
        Cookie logoutcookie = this.getCookie(request, "samlsso_idp.key");
        String idpId = "";
        if (logoutcookie != null) {
            idpId = logoutcookie.getValue();
        }
        log.debug("IDP ID= " + idpId);
        IDPConfig idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpId);
        this.clearCookie(request, response, "samlsso_idp.key");
        if (idpConfig != null && this.pluginLicenseService.isCustomerRegistered().booleanValue() && StringUtils.isNotBlank((CharSequence)idpConfig.getSloUrl())) {
            log.debug("SAML Logout :customer is registered and slo configured");
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("SAMLRequest"))) {
                try {
                    log.debug("SAML Logout :logout request");
                    this.samlService.createLogoutResponseAndRedirect(request, response, isPostRequest, idpConfig);
                    return;
                }
                catch (Exception e) {
                    log.error("An error occurred while executing logout request and redirecting", (Throwable)e);
                }
            } else {
                Cookie cookie = this.getCookie(request, "SAMLCOOKIE");
                if (cookie != null) {
                    log.debug("SAML Cookie found");
                    String decryptedCookie = EncryptionUtils.decrypt(this.pluginSettingsService.getCustomerTokenKey(), cookie.getValue());
                    String[] samlValues = StringUtils.split((String)decryptedCookie, (String)"::");
                    String nameId = samlValues[0];
                    String sessionIndex = samlValues[1];
                    this.clearCookie(request, response, "SAMLCOOKIE");
                    this.samlService.createLogoutRequestAndRedirect(request, response, nameId, sessionIndex, idpConfig);
                    return;
                }
            }
        } else if (idpConfig != null && StringUtils.isBlank((CharSequence)idpConfig.getSloUrl())) {
            log.debug("SLO url is not configured for IDP");
            this.clearCookie(request, response, "SAMLCOOKIE");
            response.sendRedirect(this.pluginSettingsService.getLoginPageUrl());
            return;
        }
        this.clearCookie(request, response, "SAMLCOOKIE");
        response.sendRedirect(this.pluginSettingsService.getLoginPageUrl());
    }

    public void clearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = this.getCookie(request, cookieName);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    @Generated
    public SAMLLogoutServlet(PropertyManager propertyManager, PluginLicenseService pluginLicenseService, SAMLService samlService, PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService) {
        this.propertyManager = propertyManager;
        this.pluginLicenseService = pluginLicenseService;
        this.samlService = samlService;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
    }
}

