/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginUserService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetPluginConfigAPI
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ResetPluginConfigAPI.class);
    private final PluginUserService pluginUserService;
    private final PluginLicenseService pluginLicenseService;

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Resting Plugin Configuration");
        try {
            if (!this.pluginUserService.isSystemAdminAuthenticated(request)) {
                log.warn("User is not a system admin");
                response.sendError(401, "Unauthorized access");
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Invalid Crowd SAML plugin license");
                response.sendError(401, "Unauthorized access. Invalid License");
                return;
            }
        }
        catch (Exception e) {
            log.error("An error occurred while resetting plugin configuration : ", (Throwable)e);
            response.setContentType("application/json");
            response.sendError(500, e.getMessage());
        }
    }

    @Generated
    public ResetPluginConfigAPI(PluginUserService pluginUserService, PluginLicenseService pluginLicenseService) {
        this.pluginUserService = pluginUserService;
        this.pluginLicenseService = pluginLicenseService;
    }
}

