/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ImportExportAction.class);
    private static final String IMPORT_EXPORT_VM_PATH = "/templates/importexport.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final ApplicationServices applicationServices;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseService pluginLicenseService;
    private final PluginConfigHandler pluginConfigHandler;
    private String successMessage = "";
    private String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Custom Certificates : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Import Export page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(IMPORT_EXPORT_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Crowd SAML Configuration. Custom Certificates : Post ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            if (Boolean.parseBoolean(request.getParameter("importFileSubmitted"))) {
                this.handleUpload();
            }
        }
        catch (Exception e) {
            this.errorMessage = "An error occurred while initializing the advance configuration page";
            log.error("Failed to render the Import Export page. Error details: {}", (Object)e.getMessage(), (Object)e);
            response.sendError(500, this.errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(IMPORT_EXPORT_VM_PATH, this.initializeImportExportConfig(request, response), (Writer)response.getWriter());
    }

    private HashMap<String, Object> initializeImportExportConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("IdPListSize", this.pluginSettingsService.getIdPList().size());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        return context;
    }

    private void handleUpload() throws IOException {
        String fileContents = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("configFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    fileContents = FileUtils.readFileToString((File)((File)file.getContent()));
                    if (StringUtils.isEmpty(fileContents)) {
                        this.pluginSettingsService.setSpConfigurationStatus("Uploaded app configuration file is empty.");
                        return;
                    }
                    this.pluginConfigHandler.importConfigurations(fileContents);
                    this.pluginSettingsService.setSpConfigurationStatus("success");
                    return;
                }
                catch (Exception e) {
                    log.error("exception message = " + e.getMessage());
                    log.error("Invalid file is  provided. Could not parse app configuration file. " + e);
                    this.pluginSettingsService.setSpConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
                    return;
                }
            }
        }
        log.error("An error occurred while uploading the app configuring file.");
        this.pluginSettingsService.setSpConfigurationStatus("An error occurred while uploading the app configuring file.");
    }

    @Generated
    public ImportExportAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, ApplicationServices applicationServices, LoginUriProvider loginUriProvider, PluginLicenseService pluginLicenseService, PluginConfigHandler pluginConfigHandler) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.applicationServices = applicationServices;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseService = pluginLicenseService;
        this.pluginConfigHandler = pluginConfigHandler;
    }
}

