/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import java.io.File;
import java.io.IOException;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class MoUploadMetadataServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoUploadMetadataServlet.class);
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigService pluginConfigService;
    private String idpID;
    private String idpName;
    private String inputUrl;
    private String fileSubmitted;
    private String urlSubmitted;
    private String metadataImported;
    private UserManager userManager;

    @Autowired
    public MoUploadMetadataServlet(PluginSettingsService pluginSettingsService, PluginConfigService pluginConfigService, UserManager userManager) {
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigService = pluginConfigService;
        this.userManager = userManager;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("UploadPluginConfigurationServlet: doPost Called");
        try {
            UserProfile user = this.userManager.getRemoteUser();
            Boolean isAdmin = Boolean.FALSE;
            if (user != null) {
                isAdmin = this.userManager.isAdmin(user.getUserKey());
            }
            if (!isAdmin.booleanValue()) {
                LOGGER.error("Access Denied. You will need admin privileges to make this API call");
                response.sendError(403, "Access Denied. You will need admin privileges to make this API call.");
                return;
            }
            PluginSettingsService.isMetadataFileUploaded = Boolean.TRUE;
            this.idpID = request.getParameter("idpID");
            this.idpName = request.getParameter("idpName");
            this.fileSubmitted = request.getParameter("fileSubmitted");
            this.urlSubmitted = request.getParameter("urlSubmitted");
            this.metadataImported = request.getParameter("metadataImported");
            this.inputUrl = request.getParameter("inputUrl");
            if (BooleanUtils.toBoolean((String)this.metadataImported)) {
                LOGGER.debug("metadataImported submited");
                if (BooleanUtils.toBoolean((String)this.urlSubmitted)) {
                    try {
                        LOGGER.info("Fetching Metadata from URL");
                        this.handleFetchMetadata();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Exception while importing Metadata from URL", e);
                    }
                } else if (BooleanUtils.toBoolean((String)this.fileSubmitted)) {
                    LOGGER.info("Uploading Metadata File");
                    this.handleUploadMetadata();
                }
            }
            response.sendRedirect(this.pluginSettingsService.getAddIdpConfigurationPageUrl() + "?idpid=" + this.idpID);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details." + e);
            this.pluginSettingsService.setMetadataUploadStatus("An error occurred while saving your details.Please check logs for more info.");
            response.sendRedirect(this.pluginSettingsService.getAddIdpConfigurationPageUrl());
        }
    }

    private void handleFetchMetadata() {
        LOGGER.info("handleFetchMetadata called");
        try {
            if (StringUtils.isBlank(this.inputUrl)) {
                LOGGER.error("Input Metadata URL is empty");
            }
            this.pluginConfigService.fetchMetadata(this.idpID, this.idpName, this.inputUrl);
            this.pluginSettingsService.setMetadataUploadStatus("Success.");
        }
        catch (MoPluginException e) {
            if (e.getErrorCode() == MoPluginException.PluginErrorCode.METADATA_PARSE) {
                this.pluginSettingsService.setMetadataUploadStatus("Invalid SAML Metadata provided. Could not parse metadata");
            }
            this.pluginSettingsService.setMetadataUploadStatus("Connection to Metadata URL failed. Download the metadata file and upload it using Upload Metadata file option.");
        }
    }

    private void handleUploadMetadata() throws IOException {
        LOGGER.debug("handleUploadMetadata called");
        String metadata = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("xmlFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    metadata = FileUtils.readFileToString((File)((File)file.getContent()));
                    LOGGER.debug("Metadata String from file = " + metadata);
                    this.pluginConfigService.configureFromMetadata(this.idpID, this.idpName, metadata, false);
                    this.pluginConfigService.saveImportMetadata(this.idpID, "", Boolean.FALSE, "", 60, "");
                    this.pluginSettingsService.setMetadataUploadStatus("Success.");
                    return;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                    this.pluginSettingsService.setMetadataUploadStatus("Invalid SAML Metadata provided. Could not parse metadata");
                    return;
                }
            }
        }
        LOGGER.debug("An error occurred while uploading the metadata file.");
        this.pluginSettingsService.setMetadataUploadStatus("An error occurred while uploading the metadata file.");
    }
}

