/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.servlet;

import com.atlassian.annotations.security.AdminOnly;
import com.miniorange.sso.saml.handler.MoPluginConfigurationsHandler;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoDownloadPluginConfigurationServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoDownloadPluginConfigurationServlet.class);
    private final MoPluginConfigurationsHandler moPluginConfigurationsHandler;

    @AdminOnly
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Download app configuration: doGet() called");
        try {
            String jsonConfigurations = this.moPluginConfigurationsHandler.generateConfigurationsJson();
            LOGGER.debug("Downloading json Configurations file.");
            response.setHeader("Content-Disposition", "attachment; filename=\"app_configurations.json\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/json");
            response.getOutputStream().write(jsonConfigurations.getBytes());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while generating the configuration file." + e);
            PrintWriter writer = response.getWriter();
            writer.print("An error occurred while generating the configuration file.");
            writer.close();
        }
    }

    @Generated
    public MoDownloadPluginConfigurationServlet(MoPluginConfigurationsHandler moPluginConfigurationsHandler) {
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
    }
}

