/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.configuration;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.handler.PluginConfigHandler;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.service.ApplicationServices;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginLicenseService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.HttpUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMappingAction
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AttributeMappingAction.class);
    private static final String ATTRIBUTE_MAPPING_VM_PATH = "/templates/attributemappingconfig.vm";
    private final TemplateRenderer templateRenderer;
    private final PluginSettingsService pluginSettingsService;
    private final PluginConfigHandler pluginConfigHandler;
    private final PluginConfigService pluginConfigService;
    private final ApplicationServices applicationServices;
    private final PluginLicenseService pluginLicenseService;
    private final LoginUriProvider loginUriProvider;
    private String successMessage = "";
    private String errorMessage = "";

    @AdminOnly
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Crowd SAML Configuration. Account Details : GET ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the customer login page";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(ATTRIBUTE_MAPPING_VM_PATH, this.initializeAccountDetailsConfig(request, response), (Writer)response.getWriter());
    }

    @AdminOnly
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Crowd SAML Configuration. Account Details : POST ");
        try {
            if (!this.applicationServices.isSystemAdmin().booleanValue()) {
                log.warn("User is not logged in or does not have System Admin permission, redirecting to login page");
                response.sendRedirect(this.loginUriProvider.getLoginUriForRole(HttpUtils.getUri(request), UserRole.ADMIN).toASCIIString());
                return;
            }
            if (!this.pluginLicenseService.isValidLicense()) {
                log.warn("Customer is not registered or license is invalid, Redirecting user : {} for registration and license activation ");
                response.sendRedirect(this.pluginSettingsService.getBaseUrl().concat("/plugins/servlet/crowd-saml/config/customer-login"));
                return;
            }
            String idpId = request.getParameter("idpID");
            if (StringUtils.isBlank((CharSequence)idpId)) {
                idpId = UUID.randomUUID().toString();
            }
            Boolean attributeMappingSubmitted = BooleanUtils.toBoolean((String)request.getParameter("attributeMappingSubmitted"));
            String usernameAttribute = request.getParameter("usernameAttribute");
            String emailAttribute = request.getParameter("emailAttribute");
            String fullNameAttribute = request.getParameter("fullNameAttribute");
            String firstNameAttribute = request.getParameter("firstNameAttribute");
            String lastNameAttribute = request.getParameter("lastNameAttribute");
            Boolean keepExistingUserAttributes = Boolean.parseBoolean(request.getParameter("keepExistingUserAttributes"));
            String loginUserAttribute = request.getParameter("loginUserAttribute");
            String regexPattern = request.getParameter("regexPattern");
            Boolean regexPatternEnabled = Boolean.parseBoolean(request.getParameter("regexPatternEnabled"));
            HashMap<String, String> customAttributeMapping = new HashMap<String, String>();
            int totalCustomattributes = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("totalCustomattributes"), (CharSequence)"0"));
            for (int i = 0; i < totalCustomattributes; ++i) {
                String key = request.getParameter("attrMappingKey[" + i + "]");
                String value = request.getParameter("attrMappingValue[" + i + "]");
                log.debug("key : " + key + " Value: " + value);
                if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                customAttributeMapping.put(key.trim(), value.trim());
            }
            this.Validation(usernameAttribute, emailAttribute, regexPatternEnabled, regexPattern);
            if (BooleanUtils.toBoolean((Boolean)attributeMappingSubmitted)) {
                this.pluginConfigHandler.saveAttributeMapping(idpId, usernameAttribute, emailAttribute, fullNameAttribute, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, loginUserAttribute, regexPatternEnabled, regexPattern, customAttributeMapping);
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while initializing the Attribute Mapping";
            log.error(errorMessage, (Throwable)e);
            response.sendError(500, errorMessage);
            return;
        }
        response.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render(ATTRIBUTE_MAPPING_VM_PATH, this.initializeAccountDetailsConfig(request, response), (Writer)response.getWriter());
    }

    private HashMap<String, Object> initializeAccountDetailsConfig(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> context = this.pluginConfigHandler.initializeDefaultConfig(request, response, this.successMessage, this.errorMessage);
        String idpID = request.getParameter("idpID");
        log.debug("initializeAccountDetails Config idpID : " + idpID);
        if (StringUtils.isBlank((CharSequence)idpID)) {
            if (!this.pluginSettingsService.getIdpMap().isEmpty()) {
                idpID = this.pluginSettingsService.getIdPList().get(0);
            } else if (StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getSsoServiceUrl())) {
                idpID = UUID.randomUUID().toString();
                String idpName = "IDP";
                this.pluginConfigHandler.replaceOldSettingsWithNew(idpID, idpName);
            } else {
                context = this.initializeNewForm(context);
                return context;
            }
        }
        context = this.initializeDefaultForm(context, idpID);
        return context;
    }

    private HashMap<String, Object> initializeNewForm(HashMap<String, Object> context) {
        log.debug("In initializeNewForm");
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("timeDelay", this.pluginSettingsService.getTimeDelay());
        context.put("idpMap", this.pluginSettingsService.getIdpMap());
        context.put("userLoginOptions", this.getUserLoginOptions());
        context.put("usernameAttribute", "NameID");
        context.put("emailAttribute", "NameID");
        context.put("fullNameAttribute", "");
        context.put("firstNameAttribute", "");
        context.put("lastNameAttribute", "");
        context.put("crokeepExistingUserAttributeswdBaseUrl", true);
        context.put("loginUserAttribute", this.pluginSettingsService.getLoginUserAttribute());
        context.put("regexPatternEnabled", this.pluginSettingsService.getRegexPatternEnabled());
        context.put("regexPattern", this.pluginSettingsService.getRegexPattern());
        context.put("customAttributeMapping", new HashMap<String, String>(this.pluginSettingsService.getCustomAttributeMapping()));
        return context;
    }

    private HashMap<String, Object> initializeDefaultForm(HashMap<String, Object> context, String idpID) {
        log.debug("In initializeDefaultForm");
        log.debug("IDP ID initializeDefaultForm : " + idpID);
        context.put("idpID", idpID);
        context.put("crowdBaseUrl", this.pluginSettingsService.getSpBaseUrl());
        context.put("licenseType", this.pluginSettingsService.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettingsService.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettingsService.isNoOfUserExceed());
        context.put("timeDelay", this.pluginSettingsService.getTimeDelay());
        context.put("idpMap", this.pluginSettingsService.getIdpMap());
        context.put("userLoginOptions", this.getUserLoginOptions());
        IDPConfig idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpID);
        log.debug("IDP ID idpConfig : " + idpConfig.toString());
        context.put("usernameAttribute", idpConfig.getUsernameAttribute());
        context.put("emailAttribute", idpConfig.getEmailAttribute());
        context.put("fullNameAttribute", idpConfig.getFullNameAttribute());
        context.put("firstNameAttribute", idpConfig.getFirstNameAttribute());
        context.put("lastNameAttribute", idpConfig.getLastNameAttribute());
        context.put("keepExistingUserAttributes", idpConfig.getKeepExistingUserAttributes());
        context.put("loginUserAttribute", idpConfig.getLoginUserAttribute());
        context.put("regexPatternEnabled", idpConfig.getRegexPatternEnabled());
        context.put("regexPattern", idpConfig.getRegexPattern());
        context.put("customAttributeMapping", new TreeMap<String, String>(idpConfig.getCustomAttributeMapping()));
        return context;
    }

    private void Validation(String usernameAttribute, String emailAttribute, Boolean regexPatternEnabled, String regexPattern) {
        if (StringUtils.isBlank((CharSequence)usernameAttribute)) {
            this.errorMessage = "Username Attribute can't left blank";
        }
        if (StringUtils.isBlank((CharSequence)emailAttribute)) {
            this.errorMessage = "Email Attribute can't left blank";
        }
        if (BooleanUtils.toBoolean((Boolean)regexPatternEnabled)) {
            if (StringUtils.isBlank((CharSequence)regexPattern)) {
                this.errorMessage = "Please add Regular Expression";
            } else {
                try {
                    Pattern.compile(regexPattern);
                }
                catch (PatternSyntaxException e) {
                    this.errorMessage = "Add valid regex pattern";
                }
            }
        }
    }

    public ArrayList getUserLoginOptions() {
        ArrayList<String> userLoginOptions = new ArrayList<String>();
        userLoginOptions.add("username");
        userLoginOptions.add("email");
        return userLoginOptions;
    }

    @Generated
    public AttributeMappingAction(TemplateRenderer templateRenderer, PluginSettingsService pluginSettingsService, PluginConfigHandler pluginConfigHandler, PluginConfigService pluginConfigService, ApplicationServices applicationServices, PluginLicenseService pluginLicenseService, LoginUriProvider loginUriProvider) {
        this.templateRenderer = templateRenderer;
        this.pluginSettingsService = pluginSettingsService;
        this.pluginConfigHandler = pluginConfigHandler;
        this.pluginConfigService = pluginConfigService;
        this.applicationServices = applicationServices;
        this.pluginLicenseService = pluginLicenseService;
        this.loginUriProvider = loginUriProvider;
    }
}

