/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opensaml.util.storage.StorageService;

public class MapBasedStorageService<KeyType, ValueType>
implements StorageService<KeyType, ValueType> {
    private Map<String, Map<KeyType, ValueType>> store;

    public MapBasedStorageService() {
        this.store = new ConcurrentHashMap<String, Map<KeyType, ValueType>>();
    }

    protected MapBasedStorageService(Map<String, Map<KeyType, ValueType>> serviceStore) {
        this.store = serviceStore;
    }

    @Override
    public Iterator<String> getPartitions() {
        Set<String> keys = this.store.keySet();
        if (keys != null) {
            return keys.iterator();
        }
        return null;
    }

    @Override
    public Iterator<KeyType> getKeys(String partition) {
        Set<KeyType> keys;
        if (this.store.containsKey(partition) && (keys = this.store.get(partition).keySet()) != null) {
            return keys.iterator();
        }
        return null;
    }

    @Override
    public boolean contains(String partition, KeyType key) {
        if (key == null) {
            return false;
        }
        if (this.store.containsKey(partition)) {
            return this.store.get(partition).containsKey(key);
        }
        return false;
    }

    @Override
    public ValueType get(String partition, KeyType key) {
        if (key == null) {
            return null;
        }
        if (this.store.containsKey(partition)) {
            return this.store.get(partition).get(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueType put(String partition, KeyType key, ValueType value) {
        Map<KeyType, ValueType> partitionMap;
        if (key == null) {
            return null;
        }
        Map<String, Map<KeyType, ValueType>> map = this.store;
        synchronized (map) {
            partitionMap = this.store.get(partition);
            if (partitionMap == null) {
                partitionMap = new ConcurrentHashMap<KeyType, ValueType>();
            }
            this.store.put(partition, partitionMap);
        }
        return partitionMap.put(key, value);
    }

    @Override
    public ValueType remove(String partition, KeyType key) {
        if (key == null) {
            return null;
        }
        if (this.store.containsKey(partition)) {
            return this.store.get(partition).remove(key);
        }
        return null;
    }
}

