/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.Applications;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.exception.SAMLException;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.model.SAMLResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUserService {
    private static final Logger log = LoggerFactory.getLogger(PluginUserService.class);
    private final UserManager userManager;
    private final ApplicationManager applicationManager;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;

    public String getGroupNameFromRegexMethod(String regexPatternForGroup, String regexGroups, String groupName) {
        log.debug("regex pattern for group={} regex groups{} group name={}", new Object[]{regexPatternForGroup, regexGroups, groupName});
        Pattern pattern = Pattern.compile(org.apache.commons.lang3.StringUtils.trimToEmpty((String)regexPatternForGroup));
        log.debug("pattern is ={}", (Object)pattern);
        Matcher matcher = pattern.matcher(groupName);
        if (matcher.find()) {
            groupName = matcher.groupCount() > 0 ? this.formStringAccordingToGroupname(matcher, org.apache.commons.lang3.StringUtils.trimToEmpty((String)regexGroups)) : matcher.group();
        }
        return groupName;
    }

    public String formStringAccordingToGroupname(Matcher matcher, String replaceWith) {
        log.info("forming String According To Groupname and replaceWith");
        StringBuffer groupname = new StringBuffer("");
        try {
            String[] groupPositions;
            for (String position : groupPositions = org.apache.commons.lang3.StringUtils.split((String)replaceWith, (char)'$')) {
                log.info("position " + position);
                groupname.append(matcher.group(Integer.parseInt(position.trim())));
            }
        }
        catch (Exception e) {
            log.error("An error occurred while applying regex on groupname. Kindly check Regex configuration.", (Throwable)e);
        }
        return groupname.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isSystemAdminAuthenticated(HttpServletRequest request) {
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        if (userProfile == null) {
            log.warn("No logged-in user found, checking for Authorization header.");
            String authHeader = request.getHeader("Authorization");
            if (!StringUtils.isNotEmpty(authHeader)) {
                return false;
            }
            String credentials = new String(Base64.getDecoder().decode(authHeader.split(" ")[1]));
            String[] authParts = credentials.split(":");
            if (authParts.length != 2) {
                log.warn("Malformed Authorization header.");
                return false;
            }
            String username = authParts[0];
            String password = authParts[1];
            if (!this.userManager.authenticate(username, password)) {
                log.warn("Failed authentication attempt with provided credentials.");
                return false;
            }
            userProfile = this.userManager.getUserProfile(username);
            log.debug("Authenticated user {} via Authorization header.", (Object)username);
        }
        if (this.userManager.isSystemAdmin(userProfile.getUserKey())) {
            log.debug("User {} is authenticated with system admin permissions.", (Object)userProfile.getUsername());
            return true;
        }
        log.warn("Unauthorized access attempt by user: {} (IP: {}) to retrieve or update SAML plugin configuration.", (Object)userProfile.getUsername(), (Object)request.getRemoteAddr());
        return false;
    }

    public UserTemplate createUser(String username, String email, SAMLResponse samlResponse, IDPConfig idpConfig) {
        try {
            log.info("Creating new user.");
            String firstName = "";
            String lastName = "";
            String fullName = "";
            if (samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()).length == 1) {
                firstName = samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute())[0];
            }
            if (samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()).length == 1) {
                lastName = samlResponse.getAttributes().get(idpConfig.getLastNameAttribute())[0];
            }
            fullName = samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()).length == 1 ? samlResponse.getAttributes().get(idpConfig.getFullNameAttribute())[0] : firstName + " " + lastName;
            String[] roleValues = samlResponse.getAttributes().get(idpConfig.getRoleAttribute());
            Object newUser = null;
            Directory directoryObjects = this.getApplicationDirectory(idpConfig, samlResponse.getRelayStateURL());
            UserTemplate user = new UserTemplate(username, directoryObjects.getId().longValue());
            user.setActive(true);
            user.setEmailAddress(email);
            user.setDirectoryId(directoryObjects.getId().longValue());
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setDisplayName(fullName);
            user.setName(username);
            PasswordCredential passwordCredential = new PasswordCredential(this.getRandomPassword(), true);
            Object groupName = null;
            ArrayList<String> defaultGroupsToAssign = new ArrayList<String>();
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"newUsers") || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                defaultGroupsToAssign.addAll(idpConfig.getDefaultGroups());
            }
            if (idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
                this.directoryManager.addUser(directoryObjects.getId().longValue(), user, passwordCredential);
                Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                this.directoryManager.storeUserAttributes(directoryObjects.getId().longValue(), username, custumAttributes);
                ArrayList<String> existingUserGroups = this.getAllGroupsOfUser(username);
                for (String group : defaultGroupsToAssign) {
                    if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                    log.debug("Assigning default group:  " + group + " to user : " + username);
                    try {
                        this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), username, group);
                    }
                    catch (Exception e) {
                        log.error("Exception while assigning group to user.");
                    }
                }
                this.onTheFlyGroupAssignment(roleValues, username, idpConfig, directoryObjects.getId(), existingUserGroups);
            } else {
                ArrayList<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValues, username, idpConfig);
                if (!idpConfig.getCreateUsersIfRoleMapped().booleanValue() || !groupsToAssign.isEmpty()) {
                    this.directoryManager.addUser(directoryObjects.getId().longValue(), user, passwordCredential);
                    Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                    this.directoryManager.storeUserAttributes(directoryObjects.getId().longValue(), username, custumAttributes);
                    log.debug("Roles found. Creating user with Username: {}, Email: {}, Name:{}", new Object[]{username, email, fullName});
                    try {
                        for (String group : defaultGroupsToAssign) {
                            if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                            log.debug("Assigning default group: {} to user : {}", (Object)group, (Object)username);
                            try {
                                this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), username, group);
                            }
                            catch (Exception e) {
                                log.debug("Exception while assigning group to user.");
                            }
                        }
                        log.debug("Mapped Group(s) is assigning to the created user ");
                        for (String group : groupsToAssign) {
                            if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                            log.debug("Assigning mapped group :{}to user = {}", (Object)group, (Object)username);
                            try {
                                this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), username, group);
                            }
                            catch (Exception e) {
                                log.error("Exception while assigning group to user.");
                            }
                        }
                        return user;
                    }
                    catch (Exception e) {
                        log.error("An exception occurs while creating new users", (Throwable)e);
                        return user;
                    }
                }
            }
            return user;
        }
        catch (SAMLException e) {
            log.error(e.getMessage() + e);
            throw e;
        }
        catch (Throwable e) {
            log.error("An error occurred while creating new user." + e);
            throw new SAMLException(e, SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public UserTemplate updateUser(User ssoUser, String email, SAMLResponse samlResponse, IDPConfig idpConfig) {
        try {
            ArrayList<String> groups;
            log.debug("Executing user update process");
            String username = ssoUser.getName();
            String[] roleValues = samlResponse.getAttributes().get(idpConfig.getRoleAttribute());
            HashMap<String, String> roleMapping = idpConfig.getRoleMapping();
            ArrayList<String> groupsToAssign = this.getListOfMappedGroupsToAssign(roleValues, ssoUser.getName(), idpConfig);
            UserTemplate userTemplate = new UserTemplate(ssoUser);
            long directoryId = userTemplate.getDirectoryId();
            Object groupName = null;
            Directory directoryObjects = this.directoryManager.findDirectoryById(directoryId);
            if (!idpConfig.getKeepExistingUserAttributes().booleanValue()) {
                log.debug("Updating profile of the user : {}", (Object)ssoUser);
                String fullName = "";
                String firstName = "";
                String lastName = "";
                if (samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute()).length == 1) {
                    firstName = samlResponse.getAttributes().get(idpConfig.getFirstNameAttribute())[0];
                }
                if (samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getLastNameAttribute()).length == 1) {
                    lastName = samlResponse.getAttributes().get(idpConfig.getLastNameAttribute())[0];
                }
                fullName = samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()) != null && samlResponse.getAttributes().get(idpConfig.getFullNameAttribute()).length == 1 ? samlResponse.getAttributes().get(idpConfig.getFullNameAttribute())[0] : firstName + " " + lastName;
                log.debug("username : {} email : {}First Name : {}Last Name : {} Full Name : {}", new Object[]{username, email, firstName, lastName, fullName});
                userTemplate.setFirstName(firstName);
                userTemplate.setLastName(lastName);
                userTemplate.setDisplayName(fullName);
                this.directoryManager.updateUser(directoryId, userTemplate);
                Map<String, Set<String>> custumAttributes = this.getCustomAttributes(samlResponse, idpConfig);
                if (custumAttributes != null) {
                    log.debug("Updating additional user information :  {}", custumAttributes);
                    this.directoryManager.storeUserAttributes(directoryId, username, custumAttributes);
                }
            }
            if (idpConfig.getOnTheFlyGroupCreation().booleanValue()) {
                if (idpConfig.getKeepExistingUserRoles().booleanValue()) {
                    return userTemplate;
                }
                groups = this.getAllGroupsOfUser(username);
                this.onTheFlyGroupAssignment(roleValues, username, idpConfig, directoryId, groups);
            } else if (!idpConfig.getKeepExistingUserRoles().booleanValue() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)idpConfig.getRoleAttribute()) && !roleMapping.isEmpty()) {
                if (this.userManager.isAdmin(username)) {
                    log.debug("Member of administrator group");
                } else {
                    log.debug("Not a Member of administrator group");
                    groups = this.getAllGroupsOfUser(username);
                    for (String group : groups) {
                        try {
                            if (!this.userManager.isUserInGroup(username, group) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)roleMapping.get(group)) || groupsToAssign.contains(group)) continue;
                            this.directoryManager.removeUserFromGroup(directoryId, username, group);
                        }
                        catch (Exception e) {}
                    }
                    if (!groupsToAssign.isEmpty()) {
                        for (String newGroups : groupsToAssign) {
                            if (this.userManager.isUserInGroup(username, newGroups) || !this.isDirectoryGroup(newGroups, directoryId).booleanValue()) continue;
                            log.debug("Assigning group : {}to user :{}", (Object)newGroups, (Object)username);
                            this.directoryManager.addUserToGroup(directoryId, username, newGroups);
                        }
                    }
                }
            } else {
                log.debug("KeepExistingUserRoles checked.");
            }
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getEnableDefaultGroupsFor(), (CharSequence)"allUsers")) {
                try {
                    ArrayList<String> defaultgroupsToAssign = new ArrayList<String>(idpConfig.getDefaultGroups());
                    for (String group : defaultgroupsToAssign) {
                        if (!this.isDirectoryGroup(group, directoryObjects.getId()).booleanValue()) continue;
                        log.debug("Assigning default group:  " + group + " to user : " + username);
                        try {
                            this.directoryManager.addUserToGroup(directoryObjects.getId().longValue(), username, group);
                        }
                        catch (Exception e) {
                            log.error("Error occurred. User already exist in group/user not found", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("An error occurred while adding user to group", (Throwable)e);
                }
            }
            return userTemplate;
        }
        catch (SAMLException e) {
            log.error("An error occurred while updating users {}", (Object)e.getMessage(), (Object)e);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
        catch (Throwable e) {
            log.error("An error occurred while updating the user information.", e);
            throw new SAMLException(e, SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void reactivateUser(User ssoUser) {
        try {
            log.debug("reactivateUser : {}", (Object)ssoUser.getName());
            UserTemplate user = new UserTemplate(this.crowdService.getUser(ssoUser.getName()));
            long directoryId = user.getDirectoryId();
            user.setActive(true);
            this.directoryManager.updateUser(directoryId, user);
        }
        catch (Throwable e) {
            log.error("An error occurred while updating the user information.", e);
            throw new SAMLException(e, SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public ArrayList<String> getAllGroups() {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        log.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        log.debug("groups =  " + groups);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public ArrayList<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(Integer.MAX_VALUE);
        log.debug("query =  {} ", (Object)query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public Boolean isDirectoryGroup(String groupName, Long directoryId) {
        try {
            this.directoryManager.findGroupByName(directoryId.longValue(), groupName);
            return Boolean.TRUE;
        }
        catch (Exception groupNotFound) {
            log.error("Group: " + groupName + " is not a member of directory : " + directoryId);
            return Boolean.FALSE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onTheFlyGroupAssignment(String[] roleValues, String username, IDPConfig idpConfig, long directoryId, ArrayList<String> existingUserGroups) {
        ArrayList<String> doNotRemoveFromGroups = new ArrayList<String>(idpConfig.getOnTheFlyDoNotRemoveGroups());
        if (!idpConfig.getOnTheFlyAssignNewGroupsOnly().booleanValue()) {
            try {
                for (String group : existingUserGroups) {
                    if (doNotRemoveFromGroups.contains(group) || org.apache.commons.lang3.StringUtils.equals((CharSequence)group, (CharSequence)"crowd-administrators")) continue;
                    this.directoryManager.removeUserFromGroup(directoryId, username, group);
                }
            }
            catch (Exception e) {
                log.debug("Cannot remove groups:" + e);
            }
        }
        log.debug("role values is={}", (Object[])roleValues);
        List<Object> onTheFlyGroupList = new ArrayList();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"None")) {
            onTheFlyGroupList = this.onTheFlyFilterIDPGroups(Arrays.asList(roleValues), idpConfig);
            log.debug("IDP group list after applying filter :" + onTheFlyGroupList);
        } else {
            onTheFlyGroupList = Arrays.asList(roleValues);
            log.debug(" group list on the fly=" + onTheFlyGroupList);
        }
        if (idpConfig.getGroupRegexPatternEnabled().booleanValue()) {
            void var11_12;
            log.debug("Applying regex on incoming groups");
            String regexp = idpConfig.getRegexPatternForGroup();
            String regexg = StringEscapeUtils.escapeJavaScript(idpConfig.getRegexGroups());
            log.debug("Applying regex on idp groups " + regexg + " " + regexp);
            log.debug("ont the fly group list=" + onTheFlyGroupList.size());
            boolean bl = false;
            while (var11_12 < onTheFlyGroupList.size()) {
                onTheFlyGroupList.set((int)var11_12, this.getGroupNameFromRegexMethod(regexp, regexg, (String)onTheFlyGroupList.get((int)var11_12)));
                ++var11_12;
            }
            log.debug("Group list value after applying OTF regex : {}", onTheFlyGroupList);
        }
        if (idpConfig.getCreateNewGroups().booleanValue()) {
            ArrayList<GroupTemplate> newGroups = new ArrayList<GroupTemplate>();
            List<Object> newGroupsToAdd = onTheFlyGroupList;
            for (String string : newGroupsToAdd) {
                newGroups.add(new GroupTemplate(string, directoryId));
            }
            try {
                this.directoryManager.addAllGroups(directoryId, newGroups, false);
                log.debug("New Groups created:" + newGroups);
                for (String string : newGroupsToAdd) {
                    if (this.directoryManager.isUserDirectGroupMember(directoryId, username, string)) continue;
                    this.directoryManager.addUserToGroup(directoryId, username, string);
                }
            }
            catch (Exception exception) {
                log.error("New Groups not created:{}", (Object)exception.getMessage(), (Object)exception);
            }
        } else {
            List<Object> groups = onTheFlyGroupList;
            for (String string : groups) {
                try {
                    if (this.directoryManager.isUserDirectGroupMember(directoryId, username, string)) continue;
                    this.directoryManager.addUserToGroup(directoryId, username, string);
                }
                catch (Exception exception) {
                    log.error("Group not found exception:", (Throwable)exception);
                }
            }
        }
    }

    private List<String> onTheFlyFilterIDPGroups(List<String> idpGroups, IDPConfig idpConfig) {
        ArrayList<String> filteredGroups;
        block6: {
            block7: {
                block5: {
                    log.debug("idp groups under onTheFlyFilterIDPGroups option : {}", idpGroups);
                    filteredGroups = new ArrayList<String>();
                    log.debug("Filtering IDP groups using filter type :{}, and filter key :{}", (Object)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (Object)idpConfig.getOnTheFlyFilterIDPGroupsKey());
                    if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Starts with")) break block5;
                    log.debug("Starts with");
                    for (String group : idpGroups) {
                        if (!org.apache.commons.lang3.StringUtils.startsWith((CharSequence)group.replace("\"", "").trim(), (CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsKey())) continue;
                        filteredGroups.add(group.replace("\"", ""));
                    }
                    break block6;
                }
                if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Contains")) break block7;
                log.debug("Contains");
                for (String group : idpGroups) {
                    if (!org.apache.commons.lang3.StringUtils.contains((CharSequence)group.replace("\"", ""), (CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsKey())) continue;
                    filteredGroups.add(group.replace("\"", ""));
                }
                break block6;
            }
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)idpConfig.getOnTheFlyFilterIDPGroupsOption(), (CharSequence)"Regex")) break block6;
            log.debug("Regex");
            Pattern pattern = Pattern.compile(org.apache.commons.lang3.StringUtils.trimToEmpty((String)idpConfig.getOnTheFlyFilterIDPGroupsKey()));
            for (String groupName : idpGroups) {
                Matcher matcher = pattern.matcher(groupName.replace("\"", ""));
                try {
                    if (!matcher.find()) continue;
                    filteredGroups.add(groupName.replace("\"", ""));
                }
                catch (Exception e) {
                    log.error("error occurred...", (Throwable)e);
                }
            }
        }
        return filteredGroups;
    }

    public ArrayList<String> getListOfMappedGroupsToAssign(String[] roleValues, String username, IDPConfig idpConfig) {
        try {
            ArrayList<String> groupsToAssign = new ArrayList<String>();
            if (roleValues != null && roleValues.length > 0) {
                HashMap<String, String> roleMapping = idpConfig.getRoleMapping();
                for (String key : roleMapping.keySet()) {
                    String value = roleMapping.get(key);
                    String[] groupNamesConfigured = org.apache.commons.lang3.StringUtils.split((String)value, (String)";");
                    for (int i = 0; i < groupNamesConfigured.length; ++i) {
                        String groupValue = groupNamesConfigured[i];
                        if (!Arrays.asList(roleValues).contains(groupValue)) continue;
                        try {
                            groupsToAssign.add(key);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            return groupsToAssign;
        }
        catch (Exception e) {
            log.error("An error occurred while getting mapped groups ", (Throwable)e);
            return null;
        }
    }

    public String getRandomPassword() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        return salt.toString();
    }

    public Map<String, Set<String>> getCustomAttributes(SAMLResponse samlResponse, IDPConfig idpConfig) {
        Map<String, String> customAttributeMapping = idpConfig.getCustomAttributeMapping();
        HashMap<String, Set<String>> custumAttributes = new HashMap<String, Set<String>>();
        String userProperty = "";
        for (String userAttributes : customAttributeMapping.keySet()) {
            HashSet<String> custumAttrValues = new HashSet<String>();
            try {
                userProperty = samlResponse.getAttributes().get(customAttributeMapping.get(userAttributes))[0];
            }
            catch (Exception e) {
                userProperty = "";
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)userProperty)) continue;
            custumAttrValues.add(userProperty);
            custumAttributes.put(userAttributes, custumAttrValues);
        }
        return custumAttributes;
    }

    public Directory getApplicationDirectory(IDPConfig idpConfig, String relayState) throws DirectoryNotFoundException {
        List appList = this.applicationManager.findAll();
        for (Application app : appList) {
            String applicationUrl = (String)app.getAttributes().get("applicationURL");
            if (applicationUrl == null || !relayState.contains(applicationUrl) && !applicationUrl.contains(relayState) && !app.getRemoteAddresses().toString().contains(relayState)) continue;
            List dirList = Applications.getActiveDirectories((Application)app);
            for (Directory dir : dirList) {
                if (!dir.getAllowedOperations().contains(OperationType.CREATE_USER)) continue;
                return dir;
            }
        }
        return this.directoryManager.findDirectoryByName(idpConfig.getDefaultDirectory());
    }

    public String findUserByEmail(String email) {
        String username = "";
        log.debug("searching for existing user with email  : {}", (Object)email);
        int size = 1;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(10);
        log.debug("user by email search query =  {}", (Object)query);
        Iterable usersByEmail = this.crowdService.search((Query)query);
        log.debug("usersByEmail =  {}", (Object)usersByEmail.toString());
        if (usersByEmail instanceof Collection) {
            size = ((Collection)usersByEmail).size();
            log.debug("Number of users found with email : {}, {}", (Object)email, (Object)size);
            if (size >= 2) {
                log.error(" Multiple users found with email : {} Unable to identify the right SSO user. Please check and delete/update duplicate users and try again.", (Object)email);
                throw new SAMLException(SAMLException.SAMLErrorCode.MULTIPLE_USER_WITH_EMAIL);
            }
        }
        for (User user : usersByEmail) {
            log.debug("user : {}", (Object)user.getName());
            username = user.getName();
        }
        return username;
    }

    public User findApplicationSpecificUser(String username, String relayState) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException {
        List appList = this.applicationManager.findAll();
        log.debug("Application relay state = {}", (Object)relayState);
        for (Application app : appList) {
            String applicationUrl = (String)app.getAttributes().get("applicationURL");
            boolean isTokenCreationEnabled = true;
            try {
                isTokenCreationEnabled = BooleanUtils.toBooleanDefaultIfNull((Boolean)app.isAuthenticationWithoutPasswordEnabled(), (boolean)true);
            }
            catch (NoSuchMethodError e) {
                log.info("Crowd version is older than 4.3");
            }
            log.debug("Token creation is enabled = {} for Application = {}", (Object)isTokenCreationEnabled, (Object)app.getName());
            if (!isTokenCreationEnabled || applicationUrl == null || !relayState.contains(applicationUrl) && !applicationUrl.contains(relayState) && !app.getRemoteAddresses().toString().contains(relayState)) continue;
            List dirList = Applications.getActiveDirectories((Application)app);
            for (Directory dir : dirList) {
                com.atlassian.crowd.model.user.User user = null;
                try {
                    user = this.directoryManager.findUserByName(dir.getId().longValue(), username);
                }
                catch (Exception e) {
                    log.warn("User not found in directory = {}", (Object)dir.getName());
                }
                if (user == null) continue;
                return user;
            }
            log.debug("User not found in the application directories = {}", (Object)app.getName());
        }
        return this.crowdService.getUser(username);
    }

    @Generated
    public PluginUserService(UserManager userManager, ApplicationManager applicationManager, CrowdService crowdService, DirectoryManager directoryManager) {
        this.userManager = userManager;
        this.applicationManager = applicationManager;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
    }
}

