/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.scheduler.MetadataRefreshTask;
import com.miniorange.sso.saml.service.PluginConfigService;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRefreshScheduler
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(MetadataRefreshScheduler.class);
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)MetadataRefreshTask.class.getName().concat(":instance"));
    public static final String IDP_ID = MetadataRefreshTask.class.getName() + ":idp";
    private final SchedulerService schedulerService;
    private final PluginConfigService pluginConfigService;
    private final PluginSettingsService pluginSettingsService;

    public void rescheduleJob(int refreshTimeInterval, IDPConfig idpConfig) {
        log.info("Scheduling Crowd SAML Metadata Refresh Job for IDP: {}", (Object)idpConfig.getIdpId());
        try {
            String jobName = this.buildJobName(idpConfig.getIdpId());
            long timeInterval = TimeUnit.MINUTES.toMillis(refreshTimeInterval);
            JobId jobId = JobId.of((String)jobName);
            Map<String, Serializable> jobData = this.createJobData(idpConfig);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)timeInterval, null)).withParameters(jobData);
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Error scheduling Crowd SAML Metadata Refresh Job for IDP: {}", (Object)idpConfig.getIdpId(), (Object)e);
        }
    }

    public void unscheduleJob(String idpId) {
        log.info("Unscheduling Crowd SAML Metadata Refresh Job for IDP: {}", (Object)idpId);
        String jobName = this.buildJobName(idpId);
        JobId jobId = JobId.of((String)jobName);
        try {
            this.schedulerService.unscheduleJob(jobId);
        }
        catch (IllegalArgumentException e) {
            log.warn("No job exists with ID: {}. Cannot unschedule Job.", (Object)jobId);
        }
        catch (Exception e) {
            log.error("Error unscheduling job with ID: {} for IDP: {}", new Object[]{jobId, idpId, e});
        }
    }

    private String buildJobName(String idpId) {
        if (idpId.equals("miniorange.saml.DEFAULT_IDP_ID")) {
            return MetadataRefreshTask.class.getName() + ":idp";
        }
        return MetadataRefreshTask.class.getName() + ":idp:" + idpId;
    }

    private Map<String, Serializable> createJobData(IDPConfig idpConfig) {
        HashMap<String, Serializable> jobData = new HashMap<String, Serializable>();
        jobData.put(this.buildJobName(idpConfig.getIdpId()), (Serializable)((Object)idpConfig));
        return jobData;
    }

    public void onStart() {
        log.info("MoMetadataRefreshService onStart Called");
        try {
            int interval;
            this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new MetadataRefreshTask(this.pluginConfigService, this.pluginSettingsService));
            IDPConfig idpConfig = null;
            if (this.pluginSettingsService != null && StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getInputMetadataUrl()) && BooleanUtils.toBoolean((Boolean)this.pluginSettingsService.getRefreshMetadata())) {
                interval = SAMLUtils.getMetadataRefreshInterval(this.pluginSettingsService.getRefreshInterval(), this.pluginSettingsService.getCustomRefreshInterval(), this.pluginSettingsService.getCustomRefreshIntervalUnit());
                idpConfig = this.pluginConfigService.buildIdpConfigForIdpId("miniorange.saml.DEFAULT_IDP_ID");
                this.rescheduleJob(interval, idpConfig);
            } else {
                log.debug("onStart-scheduling and unscheduling Refresh Metadata Task");
                this.unscheduleJob("miniorange.saml.DEFAULT_IDP_ID");
            }
            HashMap<String, String> idpMap = this.pluginSettingsService.getIdpMap();
            for (String idpID : idpMap.keySet()) {
                idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpID);
                if (idpConfig == null || !StringUtils.isNotBlank((CharSequence)idpConfig.getMetadataUrl()) || !BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) continue;
                interval = SAMLUtils.getMetadataRefreshInterval(idpConfig.getRefreshInterval(), idpConfig.getCustomRefreshInterval(), idpConfig.getCustomRefreshIntervalUnit());
                this.rescheduleJob(interval, idpConfig);
            }
        }
        catch (NullPointerException e) {
            log.error("An error occurred while rescheduling Refresh From Metadata Cycle: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("An illegal argument was passed during the scheduling process: ", (Throwable)e);
        }
        catch (SchedulerRuntimeException schedulerRuntimeException) {
            log.error("A scheduling error occurred: ", (Throwable)schedulerRuntimeException);
        }
    }

    public void onStop() {
        log.info("MoMetadataRefreshService onStop Called");
        try {
            IDPConfig idpConfig = null;
            if (this.pluginSettingsService != null && StringUtils.isNotBlank((CharSequence)this.pluginSettingsService.getInputMetadataUrl()) && BooleanUtils.toBoolean((Boolean)this.pluginSettingsService.getRefreshMetadata())) {
                this.unscheduleJob("miniorange.saml.DEFAULT_IDP_ID");
            }
            HashMap<String, String> idpMap = this.pluginSettingsService.getIdpMap();
            for (String idpID : idpMap.keySet()) {
                idpConfig = this.pluginConfigService.buildIdpConfigForIdpId(idpID);
                if (idpConfig == null || !StringUtils.isNotBlank((CharSequence)idpConfig.getMetadataUrl()) || !BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) continue;
                this.unscheduleJob(idpID);
            }
            this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        }
        catch (NullPointerException e) {
            log.error("An error occurred while rescheduling Refresh From Metadata Cycle: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error("An illegal argument was passed during the scheduling process: ", (Throwable)e);
        }
        catch (SchedulerRuntimeException schedulerRuntimeException) {
            log.error("A scheduling error occurred: ", (Throwable)schedulerRuntimeException);
        }
    }

    @Generated
    public MetadataRefreshScheduler(SchedulerService schedulerService, PluginConfigService pluginConfigService, PluginSettingsService pluginSettingsService) {
        this.schedulerService = schedulerService;
        this.pluginConfigService = pluginConfigService;
        this.pluginSettingsService = pluginSettingsService;
    }
}

