/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.service;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.exception.PluginException;
import com.miniorange.sso.saml.exception.SAMLException;
import com.miniorange.sso.saml.model.IDPConfig;
import com.miniorange.sso.saml.model.SAMLResponse;
import com.miniorange.sso.saml.service.PluginSettingsService;
import com.miniorange.sso.saml.utils.PluginUtils;
import com.miniorange.sso.saml.utils.SAMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class SAMLService {
    private static final Logger log = LoggerFactory.getLogger(SAMLService.class);
    private final PluginSettingsService pluginSettingsService;
    private final TemplateRenderer templateRenderer;

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        log.debug("Redirecting user to {}", (Object)redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    public void createAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String relayState, IDPConfig idpConfig) {
        try {
            log.debug("Creating Signed AuthnRequest...");
            SAMLUtils.doBootstrap();
            AuthnRequest authnRequest = SAMLUtils.buildAuthnRequest(this.pluginSettingsService.getSpEntityId(), this.pluginSettingsService.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            if (StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                log.debug("HTTP-POST Binding selected for SSO");
                if (idpConfig.getSignedRequest().booleanValue()) {
                    authnRequest = (AuthnRequest)SAMLUtils.signHttpPostRequest(authnRequest, this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
                }
                String encodedAuthnRequest = SAMLUtils.base64EncodeRequest(authnRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState);
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes("UTF-8"));
                response.getOutputStream().close();
                return;
            }
            log.debug("HTTP-Redirect Binding selected for SSO");
            String encodedAuthnRequest = SAMLUtils.base64EncodeRequest(authnRequest, false);
            log.debug("encoded request = " + encodedAuthnRequest);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedAuthnRequest, relayState);
            String signature = SAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
            String redirectUrl = "";
            redirectUrl = idpConfig.getSignedRequest() != false ? this.createRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false) : this.createUnSignedRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, false);
            SAMLService.httpRedirect(response, redirectUrl);
            return;
        }
        catch (Throwable t) {
            log.error("An unknown error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getSignedTestAuthnRequest(IDPConfig idpConfig) {
        try {
            log.debug("Creating AuthRequest");
            SAMLUtils.doBootstrap();
            AuthnRequest authnRequest = SAMLUtils.buildAuthnRequest(this.pluginSettingsService.getSpBaseUrl(), this.pluginSettingsService.getSpBaseUrl().concat("/plugins/servlet/saml/auth"), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            if (idpConfig.getSignedRequest().booleanValue() && StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                authnRequest = (AuthnRequest)SAMLUtils.signHttpPostRequest(authnRequest, this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
            }
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            log.debug(((Object)out).toString());
            return ((Object)out).toString();
        }
        catch (Throwable t) {
            log.error("An error occurred while creating the AuthnRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getUnSignedTestAuthnRequest(IDPConfig idpConfig) {
        try {
            log.debug("Creating Authn Request");
            SAMLUtils.doBootstrap();
            AuthnRequest authnRequest = SAMLUtils.buildAuthnRequest(this.pluginSettingsService.getSpBaseUrl(), this.pluginSettingsService.getSpBaseUrl().concat("/plugins/servlet/saml/auth"), idpConfig.getSsoUrl(), idpConfig.getSsoBindingType(), idpConfig.getNameIdFormat());
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            log.debug(((Object)out).toString());
            return ((Object)out).toString();
        }
        catch (Throwable t) {
            log.error("An error occurred while creating the AuthnRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public SAMLResponse readSAMLResponse(HttpServletRequest request, HttpServletResponse response, IDPConfig idpConfig) {
        try {
            log.debug("Verifying SAML Response...");
            SAMLUtils.doBootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            Response samlResponse = SAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                log.error("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                String message = "";
                if (samlResponse.getStatus().getStatusMessage() != null) {
                    log.error("Saml Status Message received: " + samlResponse.getStatus().getStatusMessage().getMessage());
                    message = samlResponse.getStatus().getStatusMessage().getMessage() + ". Status Code received in SAML response: " + samlResponse.getStatus().getStatusCode().getValue().split(":")[7];
                } else {
                    message = "Invalid status code \"" + samlResponse.getStatus().getStatusCode().getValue().split(":")[7] + "\" received in SAML response";
                }
                throw new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_SAML_STATUS);
            }
            Assertion assertion = samlResponse.getAssertions() != null && samlResponse.getAssertions().size() > 0 ? samlResponse.getAssertions().get(0) : SAMLUtils.decryptAssertion(samlResponse.getEncryptedAssertions().get(0), this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
            this.verifyConditions(assertion, this.pluginSettingsService.getSpEntityId());
            this.verifyIssuer(samlResponse, assertion, idpConfig.getIdpEntityId());
            this.verifyDestination(samlResponse, this.pluginSettingsService.getLoginServletUrl(), idpConfig.getIdpId());
            this.verifyRecipient(assertion, this.pluginSettingsService.getLoginServletUrl(), idpConfig.getIdpId());
            MoSAMLException samlException = null;
            Boolean verified = Boolean.FALSE;
            try {
                List<String> certificates = idpConfig.getCertificates();
                log.debug("no of certificates are:" + certificates.size());
                log.debug("certificates are :" + certificates);
                if (certificates != null) {
                    for (int index = 0; index < certificates.size(); ++index) {
                        try {
                            log.debug("verifying licence no: " + index);
                            verified = this.verifyCertificate(samlResponse, assertion, certificates.get(index));
                        }
                        catch (MoSAMLException e) {
                            samlException = e;
                        }
                        if (verified.booleanValue()) break;
                    }
                }
                if (certificates.size() == 0) {
                    log.debug("Certificates count is 0.");
                    try {
                        log.debug("Verifying licence.");
                        verified = this.verifyCertificate(samlResponse, assertion, idpConfig.getX509Certificate());
                    }
                    catch (MoSAMLException e) {
                        samlException = e;
                    }
                }
            }
            catch (MoSAMLException e) {
                samlException = e;
                log.debug("samlException :" + samlException.getMessage());
            }
            catch (NullPointerException e) {
                log.error(e.getMessage(), (Throwable)e);
                log.debug("samlException1 :" + samlException.getMessage());
            }
            if (!verified.booleanValue()) {
                log.error(samlException.getMessage(), (Throwable)samlException);
                throw samlException;
            }
            Map<String, String[]> attributes = this.getAttributes(assertion);
            log.debug("attributes " + attributes);
            NameID nameId = assertion.getSubject().getNameID();
            String nameIdValue = "";
            String sessionIndex = assertion.getAuthnStatements().get(0).getSessionIndex();
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            attributes.put("NameID", new String[]{nameIdValue});
            SAMLResponse samlResponseObj = new SAMLResponse(nameIdValue, sessionIndex, relayState, attributes);
            return samlResponseObj;
        }
        catch (MoSAMLException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            log.error("An error occurred while verifying the SAML Response.", e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private void verifyIssuer(Response response, Assertion assertion, String idpEntityId) {
        log.debug("Verifying Issuer in Response and Assertion...");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = assertion.getIssuer().getValue();
        log.debug("Issuer In Assertion : " + issuerInAssertion);
        log.debug("Issuer In Response : " + issuerInResponse);
        log.debug("Issuer configured : " + idpEntityId);
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            log.error("Invalid Issuer in the SAML Response");
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_ISSUER;
            SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            log.error("Invalid Issuer in the SAML Assertion");
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_ISSUER;
            throw new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
        }
    }

    private void verifyDestination(Response response, String acsUrl, String idpID) {
        log.debug("Verifying Destination if present...");
        String destInResponse = response.getDestination();
        log.debug("Issuer In destination : " + destInResponse);
        log.debug("Destination URL of the app(default) : " + acsUrl);
        String updatedAcsURL = acsUrl;
        if (StringUtils.isNotEmpty((CharSequence)idpID)) {
            updatedAcsURL = acsUrl + "?idp=" + idpID;
            log.debug("Updated Destination URL for the app : " + updatedAcsURL);
        }
        if (!(StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)updatedAcsURL))) {
            log.error("Invalid destination in the SAML Response");
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_DESTINATION;
            SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
            throw e;
        }
    }

    private void verifyRecipient(Assertion assertion, String acsUrl, String idpID) {
        log.debug("Verifying Recipient if present...");
        String recipientInResponse = assertion.getSubject().getSubjectConfirmations().get(0).getSubjectConfirmationData().getRecipient();
        log.debug("Issuer In Recipient : {}", (Object)recipientInResponse);
        log.debug("Recipient URL for the app : {}", (Object)acsUrl);
        String updatedAcsURL = acsUrl;
        if (StringUtils.isNotEmpty((CharSequence)idpID)) {
            updatedAcsURL = acsUrl + "?idp=" + idpID;
            log.debug("Updated Recipient URL for the app : {}", (Object)updatedAcsURL);
        }
        if (!(StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)updatedAcsURL))) {
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_RECIPIENT;
            SAMLException e = new SAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
            log.error("Invalid ACS URL in the SAML Response");
            throw e;
        }
    }

    private String TimeDiff(SAMLException.SAMLErrorCode error, long temp, String replacement) {
        return error.getResolution() + " Set your Server clock " + replacement + " by " + temp + " minutes  Or you can Increase " + temp + " minutes in  validate Saml Response in Advanced SSO Options tab.";
    }

    public long timeInMilliseconds() {
        String time = this.pluginSettingsService.getTimeDelay();
        log.debug("Time is: " + time);
        long timeDelay = Long.valueOf(time);
        timeDelay = timeDelay * 60L * 1000L;
        return timeDelay;
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        log.debug("Verifying Conditions...");
        String replacement = " ";
        SAMLException samlException = null;
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        long timeDifferenceInBefore = 0L;
        long timeDifferenceInAfter = 0L;
        if (assertion.getConditions().getNotBefore() != null) {
            notBefore = assertion.getConditions().getNotBefore().toDate();
            if (now.before(notBefore)) {
                timeDifferenceInBefore = Math.abs(notBefore.getTime() - now.getTime());
            }
            log.debug("timeDifferenceInBefore = " + timeDifferenceInBefore);
        }
        if (assertion.getConditions().getNotOnOrAfter() != null) {
            notOnOrAfter = assertion.getConditions().getNotOnOrAfter().toDate();
            if (now.after(notOnOrAfter)) {
                timeDifferenceInAfter = Math.abs(now.getTime() - notOnOrAfter.getTime());
            }
            log.debug("timeDifferenceInAfter = " + timeDifferenceInAfter);
        }
        long userAddedDelay = this.timeInMilliseconds();
        long timeDiff = 0L;
        if (notBefore != null && now.before(notBefore) && userAddedDelay - timeDifferenceInBefore < 0L) {
            timeDiff = -(userAddedDelay - timeDifferenceInBefore);
            replacement = "Forward";
        } else if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddedDelay - timeDifferenceInAfter < 0L) {
            timeDiff = timeDifferenceInAfter - userAddedDelay;
            replacement = "Back";
        }
        long valueInMinutes = timeDiff / 60000L % 60L;
        long finalValueInMinutes = Math.incrementExact(valueInMinutes);
        if (notBefore != null && now.before(notBefore) && userAddedDelay - timeDifferenceInBefore < 0L) {
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            samlException = new SAMLException(errorCode.getMessage(), this.TimeDiff(errorCode, finalValueInMinutes, replacement), errorCode);
            log.error(samlException.getMessage(), (Throwable)samlException);
            throw samlException;
        }
        if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddedDelay - timeDifferenceInAfter < 0L) {
            SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            samlException = new SAMLException(errorCode.getMessage(), this.TimeDiff(errorCode, finalValueInMinutes, replacement), errorCode);
            log.error(samlException.getMessage(), (Throwable)samlException);
            throw samlException;
        }
        List<Audience> audiencesInAssertion = assertion.getConditions().getAudienceRestrictions().get(0).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        samlException = new SAMLException(SAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        log.error(SAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage(), (Throwable)samlException);
        throw samlException;
    }

    private Boolean verifyCertificate(Response response, Assertion assertion, String x509Certificate) {
        log.debug("Verifying Certificate...");
        SAMLException samlException = null;
        if (x509Certificate != null) {
            try {
                if (!response.isSigned() && !assertion.isSigned()) {
                    SAMLException e = new SAMLException(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                    log.error(SAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage(), (Throwable)e);
                    throw e;
                }
                if (response.isSigned()) {
                    return SAMLUtils.verifyCertificate(response, x509Certificate);
                }
                if (assertion.isSigned()) {
                    return SAMLUtils.verifyCertificate(assertion, x509Certificate);
                }
                log.error("Error occurred while verifying the certificate");
            }
            catch (NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
                SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
                samlException = new SAMLException(errorCode.getMessage(), this.buildResolutionForCertificate(errorCode, assertion, response), errorCode);
                throw samlException;
            }
            catch (ValidationException e) {
                SAMLException.SAMLErrorCode errorCode = SAMLException.SAMLErrorCode.INVALID_SIGNATURE;
                samlException = new SAMLException(errorCode.getMessage(), this.buildResolutionForCertificate(errorCode, assertion, response), errorCode);
                throw samlException;
            }
        }
        return false;
    }

    private String buildResolutionForCertificate(SAMLException.SAMLErrorCode error, Assertion assertion, Response response) {
        String certificateExpected = " ";
        try {
            if (assertion.isSigned()) {
                List<X509Data> x509Datas = assertion.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        certificateExpected = certificate.getValue();
                    }
                }
            } else if (response.isSigned()) {
                List<X509Data> x509Datas = response.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        certificateExpected = certificate.getValue();
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return error.getResolution() + " Expected certificate : <textarea rows='6' cols='100' word-wrap='break-word;' style='width:580px; margin:0px; height:290px;' id ='errormsg' readonly>-----BEGIN CERTIFICATE-----" + certificateExpected + "-----END CERTIFICATE-----</textarea> <div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div><script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#errormsg\").select();document.execCommand('copy');};</script>";
    }

    private Map<String, String[]> getAttributes(Assertion assertion) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (assertion.getAttributeStatements().size() > 0) {
            for (Attribute attr : assertion.getAttributeStatements().get(0).getAttributes()) {
                if (attr.getAttributeValues().size() <= 0) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = attr.getAttributeValues().get(i).getDOM().getTextContent();
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    public void createLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex, IDPConfig idpConfig) {
        try {
            log.debug("Creating LogoutRequest...");
            SAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = SAMLUtils.buildLogoutRequest(this.pluginSettingsService.getSpEntityId(), idpConfig.getSloUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                log.debug("HTTP-POST Binding selected for SLO");
                logoutRequest = (LogoutRequest)SAMLUtils.signHttpPostRequest(logoutRequest, this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
                String encodedLogoutRequest = SAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSloUrl(), encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                log.debug("HTTP-Redirect Binding selected for SLO");
                String encodedLogoutRequest = SAMLUtils.base64EncodeRequest(logoutRequest, false);
                String urlForSignature = this.createRequestQueryParamsForSignature(encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"));
                String signature = SAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
                String redirectUrl = "";
                redirectUrl = idpConfig.getSignedRequest() != false ? this.createRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false) : this.createUnSignedRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"), false);
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Throwable t) {
            log.error("An unknown error occurred while creating the LogoutRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex) {
        try {
            log.debug("Creating LogoutRequest...");
            SAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = SAMLUtils.buildLogoutRequest(this.pluginSettingsService.getSpEntityId(), this.pluginSettingsService.getSloServiceUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)this.pluginSettingsService.getSloBindingType(), (CharSequence)"HttpPost")) {
                log.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutRequest = SAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(this.pluginSettingsService.getSloServiceUrl(), encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                log.debug("HTTP-Redirect Binding selected for SLO");
                String encodedLogoutRequest = SAMLUtils.base64EncodeRequest(logoutRequest, false);
                String redirectUrl = this.createUnSignedRedirectURL(this.pluginSettingsService.getSloServiceUrl(), encodedLogoutRequest, this.pluginSettingsService.getBaseUrl().concat("/console/login.action"), false);
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Throwable t) {
            log.error("An unknown error occurred while creating the LogoutRequest.", t);
            t.printStackTrace();
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest, IDPConfig idpConfig) {
        try {
            log.debug("Creating LogoutResponse...");
            SAMLUtils.doBootstrap();
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = SAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            LogoutResponse logoutResponse = SAMLUtils.buildLogoutResponse(this.pluginSettingsService.getSpEntityId(), idpConfig.getSloUrl(), logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                log.debug("HTTP-POST Binding selected for SLO");
                logoutResponse = (LogoutResponse)SAMLUtils.signHttpPostRequest(logoutResponse, this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
                String encodedLogoutResponse = SAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                log.debug("HTTP-Redirect Binding selected for SLO");
                String encodedLogoutResponse = SAMLUtils.base64EncodeRequest(logoutResponse, false);
                String urlForSignature = this.createResponseQueryParamsForSignature(encodedLogoutResponse, request.getParameter("RelayState"));
                String signature = SAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.pluginSettingsService.getPublicSPCertificate(), this.pluginSettingsService.getPrivateSPCertificate());
                String redirectUrl = this.createRedirectURL(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, true);
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Throwable t) {
            log.error("An unknown error occurred while creating the LogoutRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest) {
        try {
            log.debug("Creating LogoutResponse...");
            SAMLUtils.doBootstrap();
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = SAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            LogoutResponse logoutResponse = SAMLUtils.buildLogoutResponse(this.pluginSettingsService.getSpEntityId(), this.pluginSettingsService.getSloServiceUrl(), logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)this.pluginSettingsService.getSloBindingType(), (CharSequence)"HttpPost")) {
                log.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutResponse = SAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(this.pluginSettingsService.getSloServiceUrl(), encodedLogoutResponse, request.getParameter("RelayState"));
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
            } else {
                log.debug("HTTP-Redirect Binding selected for SLO");
                String encodedLogoutResponse = SAMLUtils.base64EncodeRequest(logoutResponse, false);
                String redirectUrl = this.createUnSignedRedirectURL(this.pluginSettingsService.getSloServiceUrl(), encodedLogoutResponse, request.getParameter("RelayState"), true);
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Throwable t) {
            log.error("An unknown error occurred while creating the LogoutRequest.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String buildResolutionMessage(SAMLException.SAMLErrorCode error, String expected, String found) {
        return error.getResolution() + " Add-on was expecting " + found + " but found: " + expected;
    }

    private String createRedirectURL(String url, String samlRequestOrResponse, String relayState, String sigAlgo, String signature, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        builder.append("&").append("SigAlg").append("=").append(URLEncoder.encode(sigAlgo, "UTF-8")).append("&").append("Signature").append("=").append(URLEncoder.encode(signature, "UTF-8"));
        return builder.toString();
    }

    private String createUnSignedRedirectURL(String url, String samlRequestOrResponse, String relayState, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        return builder.toString();
    }

    private String createRequestQueryParamsForSignature(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createResponseQueryParamsForSignature(String httpRedirectResponse, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLResponse").append("=").append(URLEncoder.encode(httpRedirectResponse, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createHttpPostRequestForm(String ssoUrl, String encodedRequest, String relayState) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ssoUrl", ssoUrl);
        context.put("encodedRequest", SAMLUtils.htmlEncode(encodedRequest));
        context.put("relayState", SAMLUtils.htmlEncode(relayState));
        String form = this.templateRenderer.renderFragment(this.pluginSettingsService.getSAMLPostRequest(), context);
        log.debug("result = {}", (Object)form);
        return form;
    }

    private String createHttpPostResponseForm(String ssoUrl, String encodedResponse, String relayState) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("ssoUrl", ssoUrl);
        context.put("encodedResponse", SAMLUtils.htmlEncode(encodedResponse));
        context.put("relayState", SAMLUtils.htmlEncode(relayState));
        String form = this.templateRenderer.renderFragment(this.pluginSettingsService.getSAMLPostResponse(), context);
        log.debug("result = {}", (Object)form);
        return form;
    }

    public String formatXML(String xml) {
        String responseMessage = xml;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            responseMessage = ((Object)out).toString();
        }
        catch (Throwable t) {
            log.error("An error occurred while parsing the response.", t);
            throw new SAMLException(SAMLException.SAMLErrorCode.UNKNOWN);
        }
        return responseMessage;
    }

    public void redirectToSAMLError(HttpServletRequest request, HttpServletResponse response, String errorMessage, SAMLException.SAMLErrorCode samlErrorCode, PluginException.PluginErrorCode pluginErrorCode) throws ServletException {
        log.debug("Redirecting to SAML error : {}", (Object)errorMessage);
        try {
            if (this.pluginSettingsService.getEnableErrorMsgTemplate().booleanValue()) {
                log.debug("Error template is enabled, rendering error template with error message : {}", (Object)errorMessage);
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("baseUrl", this.pluginSettingsService.getBaseUrl());
                if (samlErrorCode != null) {
                    context.put("errorCode", samlErrorCode.name());
                } else if (pluginErrorCode != null) {
                    context.put("errorCode", pluginErrorCode.name());
                }
                context.put("errorMessage", errorMessage);
                response.setContentType("text/html;charset=utf-8");
                this.templateRenderer.renderFragment(this.pluginSettingsService.getErrorMsgTemplate(), context);
            } else {
                String redirectUrl = this.pluginSettingsService.getLoginPageUrl() + "?samlerror=" + samlErrorCode.name();
                response.sendRedirect(redirectUrl);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while redirecting to SAML error : {}", (Object)errorMessage);
            throw new ServletException();
        }
    }

    public void redirectToSuccessfulAuthLandingPage(HttpServletRequest request, HttpServletResponse response, String relayState, String ssoDomain) throws IOException, InterruptedException {
        URL redirectUrl;
        log.debug("Relay state URL : {}", (Object)relayState);
        if (StringUtils.isBlank((CharSequence)relayState) || StringUtils.isEmpty((CharSequence)relayState)) {
            relayState = "/";
        }
        relayState = relayState.replace("\"", "");
        if (!(relayState = PluginUtils.sanitizeText(relayState)).startsWith("http") && !relayState.startsWith("/")) {
            relayState = "/" + relayState;
        }
        if (!relayState.startsWith("http")) {
            relayState = this.pluginSettingsService.getSpBaseUrl().concat(relayState);
        }
        if (!StringUtils.contains((CharSequence)(redirectUrl = new URL(relayState)).getHost(), (CharSequence)ssoDomain)) {
            log.debug("Relay state URL is from outside Crowd SSO domain.");
            HttpSession relayStateSession = request.getSession();
            relayState = "";
            if (relayStateSession.getAttribute("RELAY_STATE") != null) {
                log.debug("Relay state in session : {}", (Object)relayState);
                relayState = relayStateSession.getAttribute("RELAY_STATE").toString();
            }
            if (StringUtils.isEmpty((CharSequence)relayState)) {
                relayState = this.pluginSettingsService.getSpBaseUrl();
            }
        }
        response.sendRedirect(redirectUrl.toString());
    }

    public void displaySAMLResponse(HttpServletRequest request, HttpServletResponse response) {
        log.debug("Rendering SAML Response ");
        try {
            StringBuilder output = new StringBuilder("<div style='display:none'>");
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String xml = new String(Base64.decode(encodedSAMLResponse), StandardCharsets.UTF_8);
            xml = this.XmlFormatter(xml);
            output.append(xml);
            xml = HtmlUtils.htmlEscape((String)xml);
            output.append("</div>");
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>SAML Response</div>");
            output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:1062px; margin:0px; height:350px;' id ='reqmessage' readonly>" + xml + "</textarea> ");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
            output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(output.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("An error occurred while rendering Custom error template : {}", (Object)e.getMessage());
        }
    }

    public void displaySAMLRequest(HttpServletRequest request, HttpServletResponse response, IDPConfig idpConfig) {
        log.debug("Rendering SAML Request ");
        try {
            StringBuilder output = new StringBuilder("<div style='display:none'>");
            String message = idpConfig.getSignedRequest() != false ? this.getSignedTestAuthnRequest(idpConfig) : this.getUnSignedTestAuthnRequest(idpConfig);
            message = this.XmlFormatter(message);
            message = HtmlUtils.htmlEscape((String)message);
            output.append(message);
            output.append("</div>");
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Authentication(SAML) Request</div>");
            output.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:1062px; margin:0px; height:350px;' id ='reqmessage' readonly>" + message + "</textarea> ");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            output.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
            output.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#reqmessage\").select();document.execCommand('copy');};</script>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(output.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("An error occurred while rendering Custom error template : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void displayTestConfigurationResult(IDPConfig idpConfig, SAMLResponse samlResponse, HttpServletResponse response, SAMLException e) throws IOException {
        log.debug("Display Test Configuration Result");
        if (e == null) {
            String username = "";
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            String[] usernameArray = samlResponse.getAttributes().get(idpConfig.getUsernameAttribute());
            if (usernameArray != null && usernameArray.length == 1) {
                username = usernameArray[0];
            }
            htmlStart = StringUtils.isBlank((CharSequence)username) ? htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login.</div>") : htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
            htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
            for (String key : samlResponse.getAttributes().keySet()) {
                htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
                String[] values = samlResponse.getAttributes().get(key);
                for (int i = 0; i < values.length; ++i) {
                    htmlStart = i == values.length - 1 ? htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<br/>"})) : htmlStart.append(StringUtils.join((Object[])new String[]{values[i], "<hr/>"}));
                }
                htmlStart = htmlStart.append("</td></tr>");
            }
            htmlStart = htmlStart.append("</table></div>");
            htmlStart = htmlStart.append("<div style=\"margin:3%;display:block;text-align:center;\"><input style=\"padding:1%;width:100px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Done\" onClick=\"self.close();\"></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
            htmlStart = htmlStart.append("<div style=\"color:#a94442;background-color:#f2dede;padding:15px;margin-bottom:20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div>");
            htmlStart = htmlStart.append("<table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%;font-size:14pt;\"><tr style=\"padding-top:10px;padding-bottom:10px;\"><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Code</td><td style=\"word-wrap:break-word;\">" + (Object)((Object)e.getErrorCode()) + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Error Message</td><td style=\"word-wrap:break-word;\">" + e.getMessage() + "</td></tr><tr><td style=\"font-weight:bold;padding:10px 5px 10px 5px;\">Resolution</td><td style=\"word-wrap:break-word;\">" + e.getResolution() + "</tr></table></div>");
            response.setCharacterEncoding("iso-8859-1");
            response.setContentType("text/html");
            response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public String XmlFormatter(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String extractSSOUsernameUsingRegex(String username, IDPConfig idpConfig) {
        if (idpConfig.getRegexPatternEnabled().booleanValue() && StringUtils.isNotEmpty((CharSequence)idpConfig.getRegexPattern())) {
            log.debug("Extracting SSO User From Username {} with regex pattern {}", (Object)username, (Object)idpConfig.getRegexPattern());
            try {
                Pattern pattern = Pattern.compile(StringUtils.trimToEmpty((String)idpConfig.getRegexPattern()));
                Matcher matcher = pattern.matcher(username);
                if (matcher.find()) {
                    if (matcher.groupCount() > 0) {
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            username = username + matcher.group(i);
                        }
                    } else {
                        username = matcher.group();
                    }
                    log.debug("Username after applying regex: {}", (Object)username);
                }
            }
            catch (Exception e) {
                log.error("An error occurred while extracting SSO User From Username {}", (Object)username, (Object)e);
                throw new SAMLException(SAMLException.SAMLErrorCode.USERNAME_REGEX_VALIDATION_FAILED);
            }
        }
        return username;
    }

    @Generated
    public SAMLService(PluginSettingsService pluginSettingsService, TemplateRenderer templateRenderer) {
        this.pluginSettingsService = pluginSettingsService;
        this.templateRenderer = templateRenderer;
    }
}

